/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor;

import java.io.File;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class RepalyEditSaveDialog
extends DAMessageBox {
    public int MAX_SAVE_FILE_NAME_LENGTH = 35;
    public Text textBox = null;
    public String saveFileName = null;
    private DAButton okButton = null;
    private DAButton cancelButton = null;
    private String targetPath = "";
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            RepalyEditSaveDialog.this.saveFileName = RepalyEditSaveDialog.this.textBox.getText();
            if (RepalyEditSaveDialog.this.saveFileName.length() > RepalyEditSaveDialog.this.MAX_SAVE_FILE_NAME_LENGTH) {
                String old = RepalyEditSaveDialog.this.saveFileName;
                RepalyEditSaveDialog.this.saveFileName = old.substring(0, RepalyEditSaveDialog.this.MAX_SAVE_FILE_NAME_LENGTH - 1);
            }
            if (RepalyEditSaveDialog.this.executeSaveTrace()) {
                RepalyEditSaveDialog.this.result = 1;
            }
            RepalyEditSaveDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            RepalyEditSaveDialog.this.shell.dispose();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (!RepalyEditSaveDialog.this.checkValidFileName(RepalyEditSaveDialog.this.textBox.getText())) {
                RepalyEditSaveDialog.this.okButton.setButtonEnabled(false);
            } else {
                RepalyEditSaveDialog.this.okButton.setButtonEnabled(true);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public RepalyEditSaveDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean run() {
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(446, 149);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        Label label = new Label((Composite)this.shell, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 12);
        data.height = 15;
        data.width = 150;
        label.setLayoutData((Object)data);
        label.setForeground(ColorResources.BLACK);
        label.setText(AnalyzerLabels.SAVE_TRACE_DLG_SAVE_FILE_NAME);
        label.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.textBox = new Text((Composite)this.shell, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)label, 10);
        data.left = new FormAttachment(0, 9);
        data.height = 26;
        data.width = 410;
        this.textBox.setLayoutData((Object)data);
        this.textBox.setBackground(ColorResources.VIEW_BG_COLOR);
        this.textBox.addKeyListener(this.keyListener);
        this.textBox.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.BUTTON_OUTLINE_HOVER_IN_COLOR);
                Text text = (Text)e.widget;
                Rectangle rect = text.getClientArea();
                e.gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
        });
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setLayout((Layout)new FormLayout());
        buttonComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, 76);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        this.okButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, -90);
        data.height = 24;
        data.width = 86;
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addClickListener(this.okButtonListener);
        this.cancelButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, 4);
        data.height = 24;
        data.width = 86;
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.saveFileName = this.getSaveFileName();
        if (this.saveFileName == null) {
            Logger.debug((Object)"save file name is null");
            return false;
        }
        this.textBox.setText(this.saveFileName);
        String textString = this.textBox.getText();
        this.textBox.setSelection(0, textString.length());
        return true;
    }

    private String getSaveFileName() {
        Project project = Global.getProject();
        String sourcePath = project.getSavePath();
        String[] splitSourcePath = null;
        if (CommonUtil.isWin()) {
            splitSourcePath = sourcePath.split("\\\\");
        } else if (CommonUtil.isMac()) {
            splitSourcePath = sourcePath.split("\\/");
        } else if (CommonUtil.isLinux()) {
            splitSourcePath = sourcePath.split("\\/");
        } else {
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.OS_WARNING);
            return null;
        }
        if (splitSourcePath == null) {
            return null;
        }
        String saveFileName = new String(splitSourcePath[splitSourcePath.length - 1]);
        if (saveFileName == null || saveFileName.isEmpty()) {
            return null;
        }
        return saveFileName;
    }

    private boolean executeSaveTrace() {
        Project project = Global.getProject();
        String sourcePath = project.getSavePath();
        this.targetPath = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + this.saveFileName;
        if (Global.getProject().getSavePath().equals(this.targetPath)) {
            return true;
        }
        File sourceFolder = new File(sourcePath);
        if (!sourceFolder.isDirectory() && !sourceFolder.mkdirs()) {
            Logger.debug((Object)"source directory create failed...");
            return false;
        }
        File targetFolder = new File(this.targetPath);
        if (!targetFolder.isDirectory() && !targetFolder.mkdirs()) {
            Logger.debug((Object)"target directory create failed...");
            return false;
        }
        AnalyzerUtil.copyDirectory(sourceFolder, targetFolder);
        return true;
    }

    private boolean checkValidFileName(String str) {
        return str != null && !str.isEmpty() && !str.contains("\\") && !str.contains("/") && !str.contains(":") && !str.contains("*") && !str.contains("\\?") && !str.contains("\"") && !str.contains("<") && !str.contains(">") && !str.contains("|");
    }

    public String getSavedPath() {
        return this.targetPath;
    }
}

