/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.nl.ReplayEditLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.ReplayEditScreenshotTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReplayEditScreenshotDialog
extends DAMessageBox {
    private DATableComposite screenshotTable = null;
    int[] sortTypes = new int[]{3, 3, 3};
    private String[] columnNames = new String[]{"", "", ""};
    private int[] columnSizes;
    private boolean[] columnVisibility;
    protected GridItem item;
    private String resolutionWidth;
    private String resolutionHeight;
    private SelectionListener featureTableSelectionListener;
    private MouseListener mouseListener;

    public ReplayEditScreenshotDialog(Shell parent, GridItem item) {
        super(parent);
        int[] nArray = new int[3];
        nArray[0] = 285;
        this.columnSizes = nArray;
        this.columnVisibility = new boolean[]{true, true, true};
        this.item = null;
        this.resolutionWidth = "";
        this.resolutionHeight = "";
        this.featureTableSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Point DisplyPt = Display.getCurrent().getCursorLocation();
                int tableX = ((ReplayEditScreenshotDialog)ReplayEditScreenshotDialog.this).screenshotTable.getTable().getShell().getBounds().x;
                int tableY = ((ReplayEditScreenshotDialog)ReplayEditScreenshotDialog.this).screenshotTable.getTable().getShell().getBounds().y;
                int imgClickX = DisplyPt.x - tableX - 5;
                int imgClickY = DisplyPt.y - tableY - 55;
                int drawImagWidth = 270;
                int drawImagHeight = 430;
                int imgWidth = 720;
                int imgHeight = 1280;
                if (!ReplayEditScreenshotDialog.this.resolutionWidth.equals("")) {
                    imgWidth = Integer.parseInt(ReplayEditScreenshotDialog.this.resolutionWidth);
                }
                if (!ReplayEditScreenshotDialog.this.resolutionHeight.equals("")) {
                    imgHeight = Integer.parseInt(ReplayEditScreenshotDialog.this.resolutionHeight);
                }
                if (imgClickX >= 0 && imgClickX <= drawImagWidth && imgClickY >= 0 && imgClickY <= drawImagHeight) {
                    int x = imgClickX * imgWidth / drawImagWidth;
                    int y = imgClickY * imgHeight / drawImagHeight + 40;
                    ReplayEditScreenshotDialog.this.item.setText(4, String.valueOf(ReplayEditLabels.CONTEXT_VALUE_X) + Integer.toString(x));
                    ReplayEditScreenshotDialog.this.item.setText(5, String.valueOf(ReplayEditLabels.CONTEXT_VALUE_Y) + Integer.toString(y));
                    ReplayEditScreenshotDialog.this.shell.dispose();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.item = item;
    }

    protected boolean run() {
        this.shell.setSize(285, 492);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(ReplayEditLabels.REPLAY_EDIT_SNAPSHOT_TABLE_TITLE);
        Composite tableComp = new Composite((Composite)this.shell, 0);
        tableComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        tableComp.setLayoutData((Object)data);
        tableComp.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.screenshotTable = new ReplayEditScreenshotTable(tableComp, 516, this.getSavedPouchPoint(this.item.getText(4)), this.getSavedPouchPoint(this.item.getText(5)));
        this.screenshotTable.setTableName(ReplayEditLabels.TABLE_TITLE);
        this.screenshotTable.setComparator(new DefaultTableComparator());
        this.screenshotTable.setSortTypes(this.sortTypes);
        this.screenshotTable.setColumns(this.columnNames);
        this.screenshotTable.setColumnSize(this.columnSizes);
        this.screenshotTable.setColumnVisibility(this.columnVisibility);
        this.screenshotTable.setTableToolTipEnable(false);
        this.screenshotTable.getTable().addSelectionListener(this.featureTableSelectionListener);
        this.screenshotTable.getTable().addMouseListener(this.mouseListener);
        this.screenshotTable.getTable().setHeaderVisible(false);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.screenshotTable.setLayoutData(data);
        this.screenshotTable.getTable().setItemHeight(450);
        this.screenshotTable.updateTable();
        return true;
    }

    public int getSavedPouchPoint(String value) {
        int point = 0;
        if (!this.getDeviceResolution()) {
            return point;
        }
        if (value.contains(ReplayEditLabels.CONTEXT_VALUE_X)) {
            point = Integer.parseInt(value.replace(ReplayEditLabels.CONTEXT_VALUE_X, ""));
            point = point * 270 / Integer.parseInt(this.resolutionWidth);
        }
        if (value.contains(ReplayEditLabels.CONTEXT_VALUE_Y)) {
            point = Integer.parseInt(value.replace(ReplayEditLabels.CONTEXT_VALUE_Y, ""));
            point = point * 450 / Integer.parseInt(this.resolutionHeight);
        }
        return point;
    }

    private boolean getDeviceResolution() {
        String selDeviceName = Global.getCurrentDeviceInfo().getIDevice().getDeviceName();
        String resolutionInfoXmlPath = String.valueOf(PathManager.TIZEN_SDK_DATA_PATH) + File.separator + "emulator-vms" + File.separator + "vms" + File.separator + selDeviceName + File.separator + "vm_config.xml";
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(resolutionInfoXmlPath);
        }
        catch (ParserConfigurationException e) {
            Logger.exception((Throwable)e);
        }
        catch (SAXException e) {
            Logger.exception((Throwable)e);
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
        }
        if (doc == null) {
            return false;
        }
        Element root = doc.getDocumentElement();
        NodeList deviceNode = root.getElementsByTagName("device");
        Element deviceElement = (Element)deviceNode.item(0);
        NodeList displayNode = deviceElement.getElementsByTagName("display");
        Element displayElement = (Element)displayNode.item(0);
        NodeList resolutionNode = displayElement.getElementsByTagName("resolution");
        Element resolutionElement = (Element)resolutionNode.item(0);
        NodeList widthNodeList = resolutionElement.getElementsByTagName("width");
        Element widthElement = (Element)widthNodeList.item(0);
        Node widthNode = widthElement.getFirstChild();
        this.resolutionWidth = widthNode.getNodeValue();
        NodeList heightNodeList = resolutionElement.getElementsByTagName("height");
        Element heightElement = (Element)heightNodeList.item(0);
        Node heightNode = heightElement.getFirstChild();
        this.resolutionHeight = heightNode.getNodeValue();
        return true;
    }
}

