/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int COMPRESSION_LEVEL = 8;
    private static final int BUFFER_SIZE = 2048;

    public static void zip(String sourcePath, String output) throws Exception {
        File sourceFile = new File(sourcePath);
        if (!sourceFile.isFile() && !sourceFile.isDirectory()) {
            throw new Exception("Can't find directory.");
        }
        if (!output.toLowerCase().endsWith(".zip")) {
            output = String.valueOf(output) + ".zip";
        }
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(output);
            bos = new BufferedOutputStream(fos);
            zos = new ZipOutputStream(bos);
            zos.setLevel(8);
            ZipUtils.zipEntry(sourceFile, sourcePath, zos);
            zos.finish();
        }
        finally {
            if (zos != null) {
                zos.close();
            }
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private static void zipEntry(File sourceFile, String sourcePath, ZipOutputStream zos) throws Exception {
        if (sourceFile.isDirectory()) {
            if (sourceFile.getName().equalsIgnoreCase(".metadata")) {
                return;
            }
            File[] fileArray = sourceFile.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                ZipUtils.zipEntry(fileArray[i], sourcePath, zos);
                ++i;
            }
        } else {
            try (BufferedInputStream bis = null;){
                String sFilePath = sourceFile.getPath();
                String zipEntryName = sFilePath.substring(sourcePath.length() + 1, sFilePath.length());
                bis = new BufferedInputStream(new FileInputStream(sourceFile));
                ZipEntry zentry = new ZipEntry(zipEntryName);
                zentry.setTime(sourceFile.lastModified());
                zos.putNextEntry(zentry);
                byte[] buffer = new byte[2048];
                int cnt = 0;
                while ((cnt = bis.read(buffer, 0, 2048)) != -1) {
                    zos.write(buffer, 0, cnt);
                }
                zos.closeEntry();
            }
        }
    }

    public static void unzip(File zipFile, File targetDir, boolean fileNameToLowerCase) throws Exception {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        ZipEntry zentry = null;
        try {
            fis = new FileInputStream(zipFile);
            zis = new ZipInputStream(fis);
            while ((zentry = zis.getNextEntry()) != null) {
                String fileNameToUnzip = zentry.getName();
                if (fileNameToLowerCase) {
                    fileNameToUnzip = fileNameToUnzip.toLowerCase();
                }
                File targetFile = new File(targetDir, fileNameToUnzip);
                if (zentry.isDirectory()) {
                    File childFolder = new File(targetFile.getAbsolutePath());
                    if (childFolder.exists()) continue;
                    childFolder.mkdirs();
                    continue;
                }
                File parentFolder = new File(targetFile.getParent());
                if (!parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                ZipUtils.unzipEntry(zis, targetFile);
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    protected static File unzipEntry(ZipInputStream zis, File targetFile) throws Exception {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(targetFile);
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = zis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        return targetFile;
    }
}

