/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemoryMapDBTable
extends DBTable {
    public static final String TABLENAME = "PROCESS_MEMORY_MAP";

    public MemoryMapDBTable() {
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CAPTIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.LOWADDR.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.HIGHADDR.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.BINARYID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.MAINTAG.name, "", "BOOLEAN"));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setLong(COLUMN.CAPTIME.index + 1, (Long)rowData.get(COLUMN.CAPTIME.index));
                prep.setLong(COLUMN.LOWADDR.index + 1, (Long)rowData.get(COLUMN.LOWADDR.index));
                prep.setLong(COLUMN.HIGHADDR.index + 1, (Long)rowData.get(COLUMN.HIGHADDR.index));
                prep.setInt(COLUMN.BINARYID.index + 1, (Integer)rowData.get(COLUMN.BINARYID.index));
                prep.setBoolean(COLUMN.MAINTAG.index + 1, (Boolean)rowData.get(COLUMN.MAINTAG.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getLong(2));
            row.add(rs.getLong(3));
            row.add(rs.getLong(4));
            row.add(rs.getInt(5));
            row.add(rs.getBoolean(6));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        PID(0, "PID"),
        CAPTIME(1, "CAPTURED_TIME"),
        LOWADDR(2, "LOWEST_ADDRESS"),
        HIGHADDR(3, "HIGHEST_ADDRESS"),
        BINARYID(4, "BINARY_ID"),
        MAINTAG(5, "MAIN_TAG");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

