/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmMapProperties
extends HierarchyUIObjectProperties {
    private int zoom;
    private boolean paused;
    private boolean wheelDisabled;
    private int zoomMin;
    private double rotateDegree;
    private int[] rotatePoint = new int[2];
    private String userAgent;
    private int zoomMax;
    private String zoomMode;
    private double regionLongitude;
    private double regionLatitude;

    public ElmMapProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.zoom = parser.getInt();
        this.paused = parser.getBoolean();
        this.wheelDisabled = parser.getBoolean();
        this.zoomMin = parser.getInt();
        this.rotateDegree = parser.getFloat();
        this.rotatePoint[0] = parser.getInt();
        this.rotatePoint[1] = parser.getInt();
        this.userAgent = parser.getString();
        this.zoomMax = parser.getInt();
        this.zoomMode = this.getZoomModeMessage(parser.getChar());
        this.regionLongitude = parser.getFloat();
        this.regionLatitude = parser.getFloat();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("zoom", Integer.toString(this.zoom)));
        properties.add(new PropertyValue("zoomMin", Integer.toString(this.zoomMin)));
        properties.add(new PropertyValue("zoomMax", Integer.toString(this.zoomMax)));
        properties.add(new PropertyValue("zoomMode", this.zoomMode));
        properties.add(new PropertyValue("paused", Boolean.toString(this.paused)));
        properties.add(new PropertyValue("wheelDisabled", Boolean.toString(this.wheelDisabled)));
        properties.add(new PropertyValue("rotateDegree", Double.toString(this.rotateDegree)));
        properties.add(new PropertyValue("rotatePoint", "[" + this.rotatePoint[0] + ", " + this.rotatePoint[1] + "]"));
        properties.add(new PropertyValue("userAgent", this.userAgent));
        properties.add(new PropertyValue("regionLongitude", Double.toString(this.regionLongitude)));
        properties.add(new PropertyValue("regionLatitude", Double.toString(this.regionLatitude)));
        return properties;
    }

    private String getZoomModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_MAP_ZOOM_MODE_MANUAL";
            }
            case 1: {
                return "ELM_COLORSELECTOR_COMPONENTS";
            }
            case 2: {
                return "ELM_COLORSELECTOR_BOTH";
            }
            case 3: {
                return "ELM_COLORSELECTOR_PICKER";
            }
            case 4: {
                return "ELM_COLORSELECTOR_PLANE";
            }
            case 5: {
                return "ELM_COLORSELECTOR_PALETTE_PLANE";
            }
            case 6: {
                return "ELM_COLORSELECTOR_ALL";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

