/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common;

import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineMarker;

public class SetRangeMarkerMouseMoveListener
extends MouseAdapter
implements MouseMoveListener {
    private DATimeline timeline;

    public SetRangeMarkerMouseMoveListener(RangeDataManager rangeDataManager, DAChartBoard chartBoard, DATimeline timeline) {
        this.timeline = timeline;
    }

    public void mouseMove(MouseEvent e) {
        List markerList = this.timeline.getMarkerList();
        int i = 0;
        while (i < markerList.size()) {
            DATimelineMarker marker = (DATimelineMarker)markerList.get(i);
            if (marker.isPushed()) {
                long longTime = (long)(marker.getTime() * 1000000.0);
                AnalyzerUtil.moveMarker(i, longTime);
                break;
            }
            ++i;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        List markerList = this.timeline.getMarkerList();
        int i = 0;
        while (i < markerList.size()) {
            DATimelineMarker marker = (DATimelineMarker)markerList.get(i);
            int markerWidth = marker.getImage().getBounds().width;
            if ((double)e.x >= this.secondToPixel(marker.getTime()) - (double)(markerWidth / 2) && (double)e.x <= this.secondToPixel(marker.getTime()) + (double)(markerWidth / 2) && e.y >= 8) {
                long longTime = (long)(marker.getTime() * 1000000.0);
                AnalyzerUtil.removeMarker(i, longTime);
                break;
            }
            ++i;
        }
    }

    private double secondToPixel(double second) {
        return (second - this.timeline.getStartTime()) * (double)this.timeline.getScale() * 5.0;
    }
}

