/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.overview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.overview.HierarchyScaledGraphics;

public class HierarchyTreeOverViewFigure
extends Figure {
    private Viewport viewport;
    private IFigure sourceFigure;
    private ScrollSynchronizer syncher;
    private IFigure selector;
    private Dimension thumbnailSize = new Dimension(0, 0);
    private Point thumbnailLocation = new Point(0, 0);
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HierarchyTreeOverViewFigure.this.reconfigureSelectorBounds();
            HierarchyTreeOverViewFigure.this.repaint();
        }
    };
    private FigureListener figureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            HierarchyTreeOverViewFigure.this.reconfigureSelectorBounds();
            HierarchyTreeOverViewFigure.this.repaint();
        }
    };

    public HierarchyTreeOverViewFigure(Composite canvas) {
        this.initialize();
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
        this.hookViewport();
    }

    public void setSource(IFigure sourceFigure) {
        this.sourceFigure = sourceFigure;
    }

    public void paintFigure(Graphics graphics) {
        Image thumbnail = this.getThumbnailImage();
        if (thumbnail == null) {
            return;
        }
        this.thumbnailLocation.x = this.getClientArea().x + (this.getClientArea().width - thumbnail.getBounds().width) / 2;
        this.thumbnailLocation.y = this.getClientArea().y + (this.getClientArea().height - thumbnail.getBounds().height) / 2;
        graphics.drawImage(thumbnail, this.thumbnailLocation);
        thumbnail.dispose();
        this.reconfigureSelectorBounds();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            return this.adjustToAspectRatio(this.getBounds().getSize(), false);
        }
        Dimension preferredSize = this.adjustToAspectRatio(this.prefSize.getCopy(), true);
        if (this.maxSize == null) {
            return preferredSize;
        }
        Dimension maximumSize = this.adjustToAspectRatio(this.maxSize.getCopy(), true);
        if (preferredSize.contains(maximumSize)) {
            return maximumSize;
        }
        return preferredSize;
    }

    private Image getThumbnailImage() {
        this.thumbnailSize = this.getPreferredSize();
        this.thumbnailSize.expand(new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight()).negate());
        float scaleX = (float)this.thumbnailSize.width / (float)this.getSourceRectangle().width;
        if (this.thumbnailSize.isEmpty()) {
            Object thumbnailImage = null;
            return null;
        }
        Image thumbnailImage = new Image((Device)Display.getDefault(), this.thumbnailSize.width, this.thumbnailSize.height);
        GC thumbnailGC = new GC((Drawable)thumbnailImage, this.sourceFigure.isMirrored() ? 0x4000000 : 0);
        HierarchyScaledGraphics thumbnailGraphics = new HierarchyScaledGraphics((Graphics)new SWTGraphics(thumbnailGC));
        thumbnailGraphics.scale(scaleX);
        thumbnailGraphics.translate(this.getSourceRectangle().getLocation().negate());
        thumbnailGraphics.setBackgroundColor(ColorResources.TREEVIEW_BG);
        thumbnailGraphics.setFont(this.sourceFigure.getFont());
        Rectangle rect = this.getSourceRectangle().getCopy();
        thumbnailGraphics.fillRectangle(rect);
        this.sourceFigure.paint((Graphics)thumbnailGraphics);
        thumbnailGraphics.dispose();
        return thumbnailImage;
    }

    private Rectangle getSourceRectangle() {
        return this.sourceFigure.getBounds();
    }

    private Dimension adjustToAspectRatio(Dimension size, boolean adjustToMaxDimension) {
        int height;
        int width;
        Dimension sourceSize = this.getSourceRectangle().getSize();
        Dimension borderSize = new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight());
        size.expand(borderSize.getNegated());
        if (adjustToMaxDimension) {
            width = Math.max(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.max(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        } else {
            width = Math.min(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.min(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        }
        size.width = width;
        size.height = height;
        return size.expand(borderSize);
    }

    private void initialize() {
        this.selector = new SelectorFigure();
        this.selector.setFocusTraversable(true);
        this.hookSelector();
        ClickScrollerAndDragTransferrer transferrer = new ClickScrollerAndDragTransferrer();
        this.addMouseListener(transferrer);
        this.addMouseMotionListener((MouseMotionListener)transferrer);
    }

    private void hookSelector() {
        this.syncher = new ScrollSynchronizer();
        this.selector.addMouseListener((MouseListener)this.syncher);
        this.selector.addMouseMotionListener((MouseMotionListener)this.syncher);
        this.add(this.selector);
    }

    private void hookViewport() {
        this.viewport.addPropertyChangeListener("viewLocation", this.propListener);
        this.viewport.addFigureListener(this.figureListener);
    }

    private void reconfigureSelectorBounds() {
        Rectangle rect = new Rectangle();
        Point offset = this.viewport.getViewLocation();
        offset.x -= this.viewport.getHorizontalRangeModel().getMinimum();
        offset.y -= this.viewport.getVerticalRangeModel().getMinimum();
        rect.setLocation(offset);
        rect.setSize(this.viewport.getClientArea().getSize());
        rect.scale(this.getViewportScaleX(), this.getViewportScaleY());
        rect.translate(this.getClientArea().getLocation());
        int x = this.getParent().getClientArea().x + (this.getParent().getClientArea().width - this.thumbnailSize.width) / 2;
        int y = this.getParent().getClientArea().y + (this.getParent().getClientArea().height - this.thumbnailSize.height) / 2;
        rect.x += x;
        rect.y += y;
        this.selector.setBounds(rect);
    }

    private double getViewportScaleX() {
        return (double)this.thumbnailSize.width / (double)this.viewport.getContents().getBounds().width;
    }

    private double getViewportScaleY() {
        return (double)this.thumbnailSize.height / (double)this.viewport.getContents().getBounds().height;
    }

    private class ClickScrollerAndDragTransferrer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private boolean dragTransfer;

        private ClickScrollerAndDragTransferrer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.dragTransfer) {
                HierarchyTreeOverViewFigure.this.syncher.mouseDragged(me);
            }
        }

        public void mousePressed(MouseEvent me) {
            if (!HierarchyTreeOverViewFigure.this.getClientArea().contains(me.getLocation())) {
                return;
            }
            Point realPosition = new Point(me.getLocation().x - ((HierarchyTreeOverViewFigure)HierarchyTreeOverViewFigure.this).thumbnailLocation.x, me.getLocation().y - ((HierarchyTreeOverViewFigure)HierarchyTreeOverViewFigure.this).thumbnailLocation.y);
            Dimension selectorCenter = HierarchyTreeOverViewFigure.this.selector.getBounds().getSize().scale(0.5);
            Point scrollPoint = realPosition.getTranslated(HierarchyTreeOverViewFigure.this.getLocation().getNegated()).translate(selectorCenter.negate()).scale(1.0 / HierarchyTreeOverViewFigure.this.getViewportScaleX(), 1.0 / HierarchyTreeOverViewFigure.this.getViewportScaleY()).translate(HierarchyTreeOverViewFigure.this.viewport.getHorizontalRangeModel().getMinimum(), HierarchyTreeOverViewFigure.this.viewport.getVerticalRangeModel().getMinimum());
            HierarchyTreeOverViewFigure.this.viewport.setViewLocation(scrollPoint);
            HierarchyTreeOverViewFigure.this.syncher.mousePressed(me);
            this.dragTransfer = true;
        }

        public void mouseReleased(MouseEvent me) {
            HierarchyTreeOverViewFigure.this.syncher.mouseReleased(me);
            this.dragTransfer = false;
        }
    }

    private class ScrollSynchronizer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private Point startLocation;
        private Point viewLocation;

        private ScrollSynchronizer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.startLocation != null) {
                Dimension d = me.getLocation().getDifference(this.startLocation);
                d.scale(1.0 / HierarchyTreeOverViewFigure.this.getViewportScaleX(), 1.0 / HierarchyTreeOverViewFigure.this.getViewportScaleY());
                HierarchyTreeOverViewFigure.this.viewport.setViewLocation(this.viewLocation.getTranslated(d));
                me.consume();
            }
        }

        public void mousePressed(MouseEvent me) {
            this.startLocation = me.getLocation();
            this.viewLocation = HierarchyTreeOverViewFigure.this.viewport.getViewLocation();
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
        }
    }

    private class SelectorFigure
    extends Figure {
        private Rectangle iBounds;
        private ImageData iData;

        public SelectorFigure() {
            PaletteData pData = new PaletteData(255, 65280, 0xFF0000);
            RGB rgb = ColorConstants.menuBackgroundSelected.getRGB();
            int fillColor = pData.getPixel(rgb);
            this.iData = new ImageData(1, 1, 24, pData);
            this.iData.setPixel(0, 0, fillColor);
            this.iData.setAlpha(0, 0, 55);
            this.iBounds = new Rectangle(0, 0, 1, 1);
        }

        public void paintFigure(Graphics g) {
            Rectangle bounds = this.getBounds().getCopy();
            if (bounds.width < 5 || bounds.height < 5) {
                return;
            }
            Dimension size = this.getSize().getExpanded(1, 1);
            if (size.contains(HierarchyTreeOverViewFigure.this.thumbnailSize)) {
                return;
            }
            --bounds.height;
            --bounds.width;
            Image image = new Image((Device)Display.getCurrent(), this.iData);
            g.drawImage(image, this.iBounds, bounds);
            image.dispose();
            g.setForegroundColor(ColorConstants.menuBackgroundSelected);
            g.drawRectangle(bounds);
        }
    }
}

