/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.AppStartupData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.WebAppStartupData;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDBTable;
import org.tizen.dynamicanalyzer.ui.info.appStartup.WebAppStartupDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class AppStartupDataManager
extends PageDataManager {
    private static AppStartupDataManager instance = null;
    private AppStartupDBTable appStartupDBTable = new AppStartupDBTable();
    private DBInserter appStartupDBInserter = this.makeInserter(this.appStartupDBTable);
    private WebAppStartupDBTable webAppStartupDBTable = new WebAppStartupDBTable();
    private DBInserter webAppStartupDBInserter = this.makeInserter(this.webAppStartupDBTable);

    private AppStartupDataManager() {
    }

    public AppStartupDBTable getAppStartupDBTable() {
        return this.appStartupDBTable;
    }

    public WebAppStartupDBTable getWebAppStartupDBTable() {
        return this.webAppStartupDBTable;
    }

    public static synchronized AppStartupDataManager getInstance() {
        if (instance == null) {
            instance = new AppStartupDataManager();
        }
        return instance;
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs entryLogs = pack.getLogs(25);
        this.makeNativeData(entryLogs);
        entryLogs = pack.getLogs(26);
        this.makeWebData(entryLogs);
    }

    private void makeNativeData(Logs entryLogs) {
        if (entryLogs != null && entryLogs.getRawLogs().size() != 0) {
            List<LogData> logList = entryLogs.getLogs();
            ArrayList insertDataList = new ArrayList();
            int size = logList.size();
            int i = 0;
            while (i < size) {
                AppStartupData data = (AppStartupData)logList.get(i);
                ArrayList<Number> insertRowData = new ArrayList<Number>();
                try {
                    insertRowData.add(new Long(data.getSeq()));
                    insertRowData.add(new Integer(data.getPID()));
                    insertRowData.add(new Integer(data.getstageID()));
                    insertRowData.add(new Long(data.getStartTime()));
                    insertRowData.add(new Long(data.getEndTime()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertDataList.add(insertRowData);
                ++i;
            }
            if (insertDataList.size() > 0) {
                this.appStartupDBInserter.pushData(insertDataList);
            }
        }
    }

    private void makeWebData(Logs entryLogs) {
        if (entryLogs != null && entryLogs.getRawLogs().size() != 0) {
            List<LogData> logList = entryLogs.getLogs();
            ArrayList insertDataList = new ArrayList();
            int size = logList.size();
            int i = 0;
            while (i < size) {
                WebAppStartupData data = (WebAppStartupData)logList.get(i);
                ArrayList<Object> insertRowData = new ArrayList<Object>();
                try {
                    insertRowData.add(new Long(data.getSeq()));
                    insertRowData.add(new Integer(data.getPID()));
                    insertRowData.add(new Integer(data.getStageID()));
                    insertRowData.add(new Integer(data.getResourceID()));
                    insertRowData.add(data.getResourcePath());
                    insertRowData.add(new Long(data.getTime()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertDataList.add(insertRowData);
                ++i;
            }
            if (insertDataList.size() > 0) {
                this.webAppStartupDBInserter.pushData(insertDataList);
            }
        }
    }
}

