/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.chart;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.nl.InteractivePageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.PopupAnalysisMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupClearMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupEndMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupFromSelectionMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupStartMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class InteractiveChart {
    private InteractiveInfo interactiveInfo;
    private DAChart chartWidget;
    private DAPopupMenu popupMenu;
    DAChartSeries beforeCheckPointSeries;
    DAChartSeries afterCheckPointSeries;

    public InteractiveChart(InteractiveInfo interactiveInfo) {
        this.interactiveInfo = interactiveInfo;
        if (interactiveInfo.hasCheckLocation(1)) {
            this.beforeCheckPointSeries = new DAChartSeries(String.valueOf(interactiveInfo.getDescription()) + " Before", 2, ColorResources.SERIES_COLOR_INTERACTIVE_BEFORE);
        }
        if (interactiveInfo.hasCheckLocation(2)) {
            this.afterCheckPointSeries = new DAChartSeries(String.valueOf(interactiveInfo.getDescription()) + " After", 2, ColorResources.SERIES_COLOR_INTERACTIVE_AFTER);
        }
    }

    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard) {
        DAChartBoardItem item = new DAChartBoardItem(chartBoard, InteractivePageLabels.CHART_TITLE);
        item.setData((Object)this.interactiveInfo);
        this.chartWidget = item.getChart();
        this.setChartStyle();
        this.popupMenu = new DAPopupMenu((Composite)this.chartWidget);
        this.initPopupMenu(chartBoard, this.popupMenu);
        if (this.beforeCheckPointSeries != null) {
            this.chartWidget.addSeries(this.beforeCheckPointSeries);
        }
        if (this.afterCheckPointSeries != null) {
            this.chartWidget.addSeries(this.afterCheckPointSeries);
        }
        return item;
    }

    public InteractiveInfo getInteractiveInfo() {
        return this.interactiveInfo;
    }

    public DAChart getChartWidget() {
        return this.chartWidget;
    }

    private void initPopupMenu(DAChartBoard chartBoard, DAPopupMenu popupMenu) {
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem startItem = new DAPopupMenuItem(popupMenu);
        startItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_START);
        startItem.addListener((DAPopupMenuListener)new PopupStartMenuItemClickListener(startItem, chartBoard));
        DAPopupMenuItem endItem = new DAPopupMenuItem(popupMenu);
        endItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_END);
        endItem.addListener((DAPopupMenuListener)new PopupEndMenuItemClickListener(endItem, chartBoard));
        DAPopupMenuItem fromSelectionItem = new DAPopupMenuItem(popupMenu);
        fromSelectionItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_FROM_SELECTION);
        fromSelectionItem.addListener((DAPopupMenuListener)new PopupFromSelectionMenuItemClickListener(fromSelectionItem, chartBoard));
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupAnalysisMenuItemClickListener());
        DAPopupMenuItem clearItem = new DAPopupMenuItem(popupMenu);
        clearItem.setText(TimelineChartLabels.RANGE_CONTEXT_CLEAR);
        clearItem.addListener((DAPopupMenuListener)new PopupClearMenuItemClickListener());
    }

    private void setChartStyle() {
        DAChartPlot plot = this.chartWidget.getPlot();
        if (plot == null) {
            return;
        }
        plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.SEMI_AUTO);
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
    }

    public DAPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void clear() {
        List seriesList = this.chartWidget.getSeriesList();
        for (DAChartSeries series : seriesList) {
            series.clear();
        }
    }

    public void inputChartSeries(List<InteractiveUIData> parsedBeforeDataList, List<InteractiveUIData> parsedAfterDataList) {
        String tooltipText;
        double chartTime;
        InteractiveUIData valueData;
        int i;
        if (this.beforeCheckPointSeries != null) {
            this.beforeCheckPointSeries.clear();
            i = 0;
            while (i < parsedBeforeDataList.size()) {
                valueData = parsedBeforeDataList.get(i);
                chartTime = Formatter.longTimeToDoubleTime(valueData.getTime());
                tooltipText = valueData.getChartTooltipString();
                this.beforeCheckPointSeries.addSeriesItem(new DAChartSeriesItem(chartTime, 0.0, tooltipText));
                ++i;
            }
        }
        if (this.afterCheckPointSeries != null) {
            this.afterCheckPointSeries.clear();
            i = 0;
            while (i < parsedAfterDataList.size()) {
                valueData = parsedAfterDataList.get(i);
                chartTime = Formatter.longTimeToDoubleTime(valueData.getTime());
                tooltipText = valueData.getChartTooltipString();
                this.afterCheckPointSeries.addSeriesItem(new DAChartSeriesItem(chartTime, 0.0, tooltipText));
                ++i;
            }
        }
    }
}

