/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryAllocationTraceTable;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryAllocationTraceTableView
extends DAViewComposite {
    public static final String ID = MemoryAllocationTraceTableView.class.getName();
    public static final int SEC_TABLE_INDEX = 0;
    public static final int TIMESTAMP_TABLE_INDEX = 1;
    public static final int LIVE_TABLE_INDEX = 2;
    public static final int ADDRESS_TABLE_INDEX = 3;
    public static final int SIZE_TABLE_INDEX = 4;
    public static final int LIBRARY_TABLE_INDEX = 5;
    public static final int CALLER_FUNCTION_TABLE_INDEX = 6;
    private MemoryAllocationTraceTable tableComp = null;
    private boolean tableUpdate;
    private boolean firstUpdate;
    private boolean tableVisible;
    private boolean[] columnVisibilityEnable;
    private boolean[] columnVisibilityDisable;

    public MemoryAllocationTraceTableView(Composite parent, int style) {
        super(parent, style, false);
        boolean[] blArray = new boolean[9];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        this.columnVisibilityEnable = blArray;
        boolean[] blArray2 = new boolean[9];
        blArray2[8] = true;
        this.columnVisibilityDisable = blArray2;
        this.setLayout((Layout)new FillLayout());
        this.setTitle(MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setLayout((Layout)new FillLayout());
        this.tableUpdate = false;
        this.tableVisible = false;
        this.firstUpdate = true;
        this.tableComp = new MemoryAllocationTraceTable(contents, 0, 68352);
        this.tableComp.setColumnVisibility(this.columnVisibilityEnable);
    }

    public void updateView() {
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        if (this.tableComp == null) {
            return;
        }
        if (!DAState.isRunning() && this.firstUpdate) {
            this.firstUpdate = false;
            this.tableUpdate = true;
            this.tableVisible = true;
        }
        if (this.tableVisible) {
            this.tableComp.setColumnVisibility(this.columnVisibilityEnable);
        } else {
            this.tableComp.clear();
            this.tableComp.setColumnVisibility(this.columnVisibilityDisable);
        }
        if (this.tableUpdate) {
            this.tableComp.updateTable();
            this.tableUpdate = false;
        }
    }

    public void updateView(DAViewData vdata) {
        if (!(vdata instanceof DASelectionData)) {
            return;
        }
        DASelectionData selData = (DASelectionData)vdata;
        if (selData.getStartTime() == selData.getEndTime()) {
            this.tableComp.setSelectionRange(0L, 0L);
            boolean bl = this.tableUpdate = !DAState.isRunning();
            if (DAState.isRunning()) {
                this.tableVisible = false;
                this.tableComp.setColumnVisibility(this.columnVisibilityDisable);
                return;
            }
        } else {
            this.tableComp.setSelectionRange(selData.getStartTime(), selData.getEndTime());
            this.tableUpdate = true;
            this.tableVisible = true;
        }
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        if (this.tableVisible) {
            this.tableComp.setColumnVisibility(this.columnVisibilityEnable);
        } else {
            this.tableComp.clear();
            this.tableComp.setColumnVisibility(this.columnVisibilityDisable);
        }
        this.tableComp.updateTable();
        this.tableUpdate = false;
    }

    public void clear() {
        this.tableComp.clear();
        this.tableUpdate = false;
        this.firstUpdate = true;
        this.tableVisible = false;
    }

    public Control getControl() {
        return this.tableComp;
    }
}

