/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemHeapDBTable
extends DBTable {
    private static final String TABLENAME = "MEM_HEAP_DB";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public MemHeapDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CALL_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_LIBRARY_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ALLOC_SIZE.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOC_COUNT.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.FREE_SIZE.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.FREE_COUNT.name, "NOT NULL", "BIGINT"));
        this.setIndexColumn(COLUMN.PID.index);
        this.setIndexColumn(COLUMN.CALL_TIME.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(2, (Integer)rowData.get(COLUMN.PID.index));
                prep.setLong(3, (Long)rowData.get(COLUMN.CALL_TIME.index));
                prep.setInt(4, (Integer)rowData.get(COLUMN.CALLER_LIBRARY_ID.index));
                prep.setLong(5, (Long)rowData.get(COLUMN.ALLOC_SIZE.index));
                prep.setLong(6, (Long)rowData.get(COLUMN.ALLOC_COUNT.index));
                prep.setLong(7, (Long)rowData.get(COLUMN.FREE_SIZE.index));
                prep.setLong(8, (Long)rowData.get(COLUMN.FREE_COUNT.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getLong(3));
            row.add(rs.getInt(4));
            row.add(rs.getLong(5));
            row.add(rs.getLong(6));
            row.add(rs.getLong(7));
            row.add(rs.getLong(8));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        CALL_TIME(2, "CALL_TIME"),
        CALLER_LIBRARY_ID(3, "CALLER_LIBRARY_ID"),
        ALLOC_SIZE(4, "ALLOC_SIZE"),
        ALLOC_COUNT(5, "ALLOC_COUNT"),
        FREE_SIZE(6, "FREE_SIZE"),
        FREE_COUNT(7, "FREE_COUNT");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

