/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLAPIData;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLAPIDBTableManager
extends DBTable {
    public static final String TABLENAME = "GL_API";
    public static final String SEQ = "SEQUENCE_NUMBER";
    public static final String FRAME_INDEX = "FRAME_INDEX";
    public static final String CONTEXT_ID = "CONTEXT_ID";
    public static final String TIME = "SATRT_TIME";
    public static final String API_ID = "API_ID";
    public static final String ARGUMENT = "ARGUMENT";
    public static final String RET = "RETURN_VALUE";
    public static final String ELAPSED_TIME = "ELAPSED_TIME";
    public static final String ERROR = "ERROR_NUMBER";
    public static final String PID = "PID";
    public static final String TID = "TID";
    public static final String CALLER_PC_ADDRESS = "CALLER_PC_ADDRESS";
    public static final String LIB_NAME = "CALLER_LIBRARY_NAME";
    public static final int TABLE_SEQ_INDEX = 0;
    public static final int TABLE_CONTEXT_ID_INDEX = 1;
    public static final int TABLE_FRAME_INDEX_INDEX = 2;
    public static final int TABLE_TIME_INDEX = 3;
    public static final int TABLE_API_ID_INDEX = 4;
    public static final int TABLE_ARGUMENT_INDEX = 5;
    public static final int TABLE_RET_INDEX = 6;
    public static final int TABLE_ELAPSED_TIMEQ_INDEX = 7;
    public static final int TABLE_ERROR_INDEX = 8;
    public static final int TABLE_PID_INDEX = 9;
    public static final int TABLE_TID_INDEX = 10;
    public static final int TABLE_CALLER_PC_ADDRESS_INDEX = 11;
    public static final int TABLE_LIB_NAME_INDEX = 12;
    private static final String SELECT_API_TABLE_QUERY_FROM_FRAME_RATE_CHART = "select SEQUENCE_NUMBER,CONTEXT_ID,FRAME_INDEX,SATRT_TIME,API_ID,ARGUMENT,RETURN_VALUE,ELAPSED_TIME,ERROR_NUMBER,PID,TID,CALLER_PC_ADDRESS,CALLER_LIBRARY_NAME from GL_API where FRAME_INDEX between '%s' and '%s'";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLAPIDBTableManager() {
        this.addColumn(new DBColumn(SEQ, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(CONTEXT_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(FRAME_INDEX, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(API_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ARGUMENT, "NOT NULL", "VARCHAR(1024)"));
        this.addColumn(new DBColumn(RET, "NOT NULL", "VARCHAR(1024)"));
        this.addColumn(new DBColumn(ELAPSED_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(ERROR, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(PID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(CALLER_PC_ADDRESS, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(LIB_NAME, "NOT NULL", "INTEGER"));
        this.setIndexColumn(2);
    }

    public void insert(List<GLAPIData> apiData) {
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        int i = 0;
        while (i < apiData.size()) {
            insertDataList.add(apiData.get(i).getDBInsertData());
            ++i;
        }
        this.insertData(insertDataList);
    }

    public List<GLAPIData> selectOpenGLAPIData(int frameStartIndex, int frameEndIndex, List<String> whereClause) {
        ResultSet rs;
        String query = String.format(SELECT_API_TABLE_QUERY_FROM_FRAME_RATE_CHART, frameStartIndex, frameEndIndex);
        if (whereClause != null) {
            int i = 0;
            while (i < whereClause.size()) {
                query = String.valueOf(query) + " and " + whereClause.get(i);
                ++i;
            }
        }
        if ((rs = SqlConnectionManager.executeQueryRS(query)) == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<GLAPIData> returnValue = new ArrayList<GLAPIData>();
        try {
            while (rs.next()) {
                GLAPIData data = new GLAPIData();
                data.setSeq(rs.getLong(1));
                data.setContextID(rs.getLong(2));
                data.setFrameIndex(rs.getInt(3));
                data.setTime(rs.getLong(4));
                data.setApiId(rs.getInt(5));
                data.setArgs(rs.getString(6));
                data.setReturn(rs.getString(7));
                data.setElapsedTime(rs.getLong(8));
                data.setErrNo(rs.getLong(9));
                data.setPid(rs.getInt(10));
                data.setTid(rs.getInt(11));
                data.setCallerAddress(rs.getLong(12));
                data.setBinaryId(rs.getInt(13));
                returnValue.add(data);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return returnValue;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(0));
                prep.setLong(2, (Long)rowData.get(1));
                prep.setInt(3, (Integer)rowData.get(2));
                prep.setLong(4, (Long)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setString(6, (String)rowData.get(5));
                prep.setString(7, (String)rowData.get(6));
                prep.setLong(8, (Long)rowData.get(7));
                prep.setLong(9, (Long)rowData.get(8));
                prep.setInt(10, (Integer)rowData.get(9));
                prep.setInt(11, (Integer)rowData.get(10));
                prep.setLong(12, (Long)rowData.get(11));
                prep.setInt(13, (Integer)rowData.get(12));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

