/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.api;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLFrameRateInfo;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.opengl.table.api.GLAPITable;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLAPIListView
extends DAAdvancedViewComposite {
    GLAPITable glAPIListTable;
    private String[] columnNames = new String[]{GLPageLabels.GL_API_LIST_VIEW_SEQ, GLPageLabels.GL_API_LIST_VIEW_FRAME, GLPageLabels.GL_API_LIST_VIEW_TIME, GLPageLabels.GL_API_LIST_VIEW_NAME, GLPageLabels.GL_API_LIST_VIEW_PARAMETER, GLPageLabels.GL_API_LIST_VIEW_RETURN, GLPageLabels.GL_API_LIST_VIEW_ELAPSED_TIME, GLPageLabels.GL_API_LIST_VIEW_ERROR, GLPageLabels.GL_API_LIST_VIEW_PID, GLPageLabels.GL_API_LIST_VIEW_TID};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private int[] columnSizes;
    private int[] columnAlignment;
    private int[] sortTypes;

    public GLAPIListView(Composite parent, int style) {
        super(parent, style, false, false);
        int[] nArray = new int[10];
        nArray[0] = 40;
        nArray[2] = 70;
        nArray[3] = 120;
        nArray[4] = 250;
        nArray[5] = 70;
        nArray[6] = 105;
        nArray[7] = 95;
        nArray[8] = 60;
        nArray[9] = 60;
        this.columnSizes = nArray;
        this.columnAlignment = new int[]{131072, 16384, 16384, 16384, 16384, 16384, 131072, 16384, 131072, 131072};
        this.sortTypes = new int[]{1, 2, 2, 2, 2, 2, 1, 2, 1, 1};
        this.setLayout((Layout)new FillLayout());
        this.setTitle(GLPageLabels.GL_API_LIST_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.glAPIListTable = new GLAPITable(contents, 0, 2820);
        this.glAPIListTable.setTableName(GLPageLabels.GL_API_LIST_VIEW_TITLE);
        this.glAPIListTable.setComparator(new DefaultTableComparator());
        this.glAPIListTable.setSortTypes(this.sortTypes);
        this.glAPIListTable.setColumnAlignment(this.columnAlignment);
        this.glAPIListTable.setColumns(this.columnNames);
        this.glAPIListTable.setColumnSize(this.columnSizes);
        this.glAPIListTable.setColumnVisibility(this.columnVisibility);
        this.glAPIListTable.setTableToolTipEnable(true);
        contents.addControlListener((ControlListener)new TableColumnSizePackListener(this.glAPIListTable, this.columnSizes));
        this.setTable(this.glAPIListTable);
    }

    public void updateView() {
    }

    public void updateView(DAViewData vdata) {
        if (vdata instanceof GLSelectionData) {
            this.handleEventOfGLSelectionData((GLSelectionData)vdata);
        } else if (vdata instanceof DASelectionData) {
            this.handleEventOfDASelectionData((DASelectionData)vdata);
        }
    }

    private void handleEventOfGLSelectionData(GLSelectionData data) {
        String id = data.getViewID();
        if (id.equals(GLPage.chartViewID)) {
            this.handleEventOfChartView(data);
        } else if (id.equals("contextHistoryID.id")) {
            this.handleEventOfContextHistoryButton(data);
        } else if (!id.endsWith(this.ID)) {
            this.glAPIListTable.removeSelection();
        }
        this.glAPIListTable.updateTable();
    }

    private void handleEventOfChartView(GLSelectionData data) {
        int endFrameIndex;
        int startFrameIndex = data.getFrameTimeIndex();
        this.title = startFrameIndex == (endFrameIndex = data.getSecondFrameIndex()) ? String.valueOf(GLPageLabels.GL_API_LIST_VIEW_TITLE) + "(" + startFrameIndex + GLPageLabels.GL_FRAME + ")" : String.valueOf(GLPageLabels.GL_API_LIST_VIEW_TITLE) + "(" + startFrameIndex + "-" + endFrameIndex + GLPageLabels.GL_FRAME + ")";
        this.setTitle(this.title);
        this.glAPIListTable.updateTableFromChart(startFrameIndex, endFrameIndex);
    }

    private void handleEventOfContextHistoryButton(GLSelectionData data) {
        if (GLDataManager.getInstance().isSelectFrameRateChart()) {
            int frameRateIndex = data.getFrameRateIndex();
            if (frameRateIndex == 1) {
                frameRateIndex = GLDataManager.getInstance().getStartFrameRateTime();
            }
            this.setSelectedAPI(frameRateIndex, data.getSeq());
        } else {
            int frameIndex = data.getFrameTimeIndex();
            this.title = String.valueOf(GLPageLabels.GL_API_LIST_VIEW_TITLE) + "(" + data.getFrameTimeIndex() + GLPageLabels.GL_FRAME + ")";
            this.setTitle(this.title);
            this.glAPIListTable.updateTableFromContext(frameIndex, frameIndex, data.getSeq());
        }
    }

    private void handleEventOfDASelectionData(DASelectionData selData) {
        double selectionTime = (double)selData.getStartTime() / 1000000.0;
        if (selectionTime <= 1.0) {
            selectionTime = GLDataManager.getInstance().getStartFrameRateTime();
        }
        long selectSeq = 0L;
        Object obData = selData.getData();
        if (obData != null) {
            selectSeq = ((LogData)obData).getSeq();
        }
        this.setSelectedAPI((int)selectionTime, Long.toString(selectSeq));
    }

    private void setSelectedAPI(int selectionTime, String seq) {
        GLFrameRateInfo selectionFrameCountInfo = GLDataManager.getInstance().getFrameRateStartIndex(selectionTime, selectionTime);
        if (selectionFrameCountInfo == null) {
            return;
        }
        int startFrameIndex = selectionFrameCountInfo.getStartFrameIndex();
        int endFrameIdnex = selectionFrameCountInfo.getEndFrameIndex();
        this.title = String.valueOf(GLPageLabels.GL_API_LIST_VIEW_TITLE) + "(" + startFrameIndex + "-" + endFrameIdnex + GLPageLabels.GL_FRAME + ")";
        this.setTitle(this.title);
        this.glAPIListTable.updateTableFromContext(startFrameIndex, endFrameIdnex, seq);
    }

    public Control getControl() {
        return this.glAPIListTable;
    }

    public void clear() {
        this.setTitle(GLPageLabels.GL_API_LIST_VIEW_TITLE);
        this.glAPIListTable.clear();
    }
}

