/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.page;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.setting.SettingConstants;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataManager;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyDataManager;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyPage;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDataManager;
import org.tizen.dynamicanalyzer.ui.interactive.InteractivePage;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.kernel.KernelPage;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataManager;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemoryDataManager;
import org.tizen.dynamicanalyzer.ui.network.NetworkPage;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.page.PageInfo;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.replay.data.ReplayDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.UIPage;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;

public class PageInfoRegistry {
    private static ArrayList<PageInfo> pagesList;
    private static Map<String, PageInfo> pagesMapByName;
    private static Map<String, PageInfo> pagesMapByID;
    private static ArrayList<String> pageNamesList;
    private static HashSet<String> defaultPages;

    static {
        pagesMapByName = new HashMap<String, PageInfo>();
        pagesMapByID = new HashMap<String, PageInfo>();
        pageNamesList = new ArrayList();
        defaultPages = new HashSet();
        PageInfo filePageInfo = new PageInfo(FilePage.class, SettingConstants.PAGE_NAME_FILE);
        filePageInfo.addDataManager(FileDataManager.class);
        PageInfo glPageInfo = new PageInfo(GLPage.class, SettingConstants.PAGE_NAME_OPENGL);
        glPageInfo.addDataManager(GLDataManager.class);
        PageInfo kernelPageInfo = new PageInfo(KernelPage.class, SettingConstants.PAGE_NAME_KERNEL);
        kernelPageInfo.addDataManager(KernelDataManager.class);
        PageInfo networkPageInfo = new PageInfo(NetworkPage.class, SettingConstants.PAGE_NAME_NETWORK);
        networkPageInfo.addDataManager(NetworkDataManager.class);
        PageInfo summaryPageInfo = new PageInfo(SummaryPage.class, SettingConstants.PAGE_NAME_SUMMARY);
        summaryPageInfo.addDataManager(SummaryDataManager.class);
        summaryPageInfo.addDataManager(FunctionUsageProfiler.class);
        PageInfo threadPageInfo = new PageInfo(ThreadPage.class, SettingConstants.PAGE_NAME_THREAD);
        threadPageInfo.addDataManager(ThreadDataManager.class);
        PageInfo timelinePageInfo = new PageInfo(TimelinePage.class, SettingConstants.PAGE_NAME_TIME_LINE, true);
        timelinePageInfo.addDataManager(TimelineDataManager.class);
        timelinePageInfo.addDataManager(ReplayDataManager.class);
        timelinePageInfo.addDataManager(CallTraceDataManager.class);
        if (Global.isGUIMode()) {
            timelinePageInfo.addDataManager(InteractiveDataManager.class);
        }
        timelinePageInfo.addDataManager(ScreenshotDataManager.class);
        timelinePageInfo.addDataManager(MemoryDataManager.class);
        timelinePageInfo.addDataManager(DLogDataManager.class);
        timelinePageInfo.addDataManager(FunctionUsageProfiler.class);
        timelinePageInfo.addDataManager(SummaryDataManager.class);
        PageInfo uiPageInfo = new PageInfo(UIPage.class, SettingConstants.PAGE_NAME_UI);
        uiPageInfo.addDataManager(UIDataManager.class);
        PageInfo interactivePageInfo = new PageInfo(InteractivePage.class, SettingConstants.PAGE_NAME_INTERACTIVE);
        if (Global.isGUIMode()) {
            interactivePageInfo.addDataManager(InteractiveDataManager.class);
        }
        PageInfo hierarchyPageInfo = new PageInfo(HierarchyPage.class, SettingConstants.PAGE_NAME_HIERARCHY);
        hierarchyPageInfo.addDataManager(HierarchyDataManager.class);
        PageInfo memoryPageInfo = new PageInfo(MemoryPage.class, SettingConstants.PAGE_NAME_MEMORY);
        memoryPageInfo.addDataManager(MemoryDataManager.class);
        memoryPageInfo.addDataManager(HeapDataManager.class);
        pagesList = new ArrayList<PageInfo>(Arrays.asList(timelinePageInfo, memoryPageInfo, threadPageInfo, networkPageInfo, filePageInfo, glPageInfo, uiPageInfo, kernelPageInfo, interactivePageInfo, hierarchyPageInfo, summaryPageInfo));
        for (PageInfo page : pagesList) {
            pagesMapByName.put(page.getPageName(), page);
            pagesMapByID.put(page.getPageID(), page);
            pageNamesList.add(page.getPageName());
            if (!page.isDefault()) continue;
            defaultPages.add(page.getPageName());
        }
    }

    private static Constructor<?> getPageCtorByPageName(String pageName) {
        PageInfo pageInfo = pagesMapByName.get(pageName);
        if (pageInfo != null) {
            return pageInfo.getPageCtor();
        }
        return null;
    }

    public static DABaseComposite createPageByName(String pageName, Composite composite) {
        DABaseComposite newPage = null;
        try {
            Constructor<?> pageCtor = PageInfoRegistry.getPageCtorByPageName(pageName);
            if (pageCtor != null) {
                newPage = (DABaseComposite)pageCtor.newInstance(composite, 0);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            Logger.warning((Object)e);
            Logger.warning((Object)("Failed to create object of " + pageName));
        }
        return newPage;
    }

    public static List<String> getOrderedPageNames() {
        return Collections.unmodifiableList(pageNamesList);
    }

    private static PageDataManager getDataManagerInstance(Class<?> mgrClass) {
        PageDataManager mgr = null;
        try {
            Method method = mgrClass.getMethod("getInstance", new Class[0]);
            mgr = (PageDataManager)method.invoke(mgrClass, new Object[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            Logger.warning((Object)("Can't find getInstance() method for: " + mgrClass.getName()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Logger.warning((Object)("Can't invoke getInstance() method for: " + mgrClass.getName()));
            Logger.warning((Object)e);
        }
        return mgr;
    }

    public static Set<PageDataManager> getUnregisteredDataManagers(String pageName, Map<String, PageDataManager> registeredMgrs) {
        HashSet<PageDataManager> managers = new HashSet<PageDataManager>();
        PageInfo pageInfo = pagesMapByName.get(pageName);
        if (pageInfo != null) {
            for (Class<?> mgrClass : pageInfo.getDataManagers()) {
                PageDataManager mgrInstance;
                if (registeredMgrs.containsKey(PageDataManager.getClassName(mgrClass)) || (mgrInstance = PageInfoRegistry.getDataManagerInstance(mgrClass)) == null) continue;
                managers.add(mgrInstance);
            }
        }
        return Collections.unmodifiableSet(managers);
    }

    public static Set<String> getPageNamesByTarget(String targetName) {
        Set<String> selectedPageSet = SettingDataManager.INSTANCE.getSelectedPageList(targetName);
        selectedPageSet.addAll(defaultPages);
        if (Global.isGUIMode() && !InteractiveDataManager.getInstance().getVariableInfoList().isEmpty()) {
            selectedPageSet.add(SettingConstants.PAGE_NAME_INTERACTIVE);
        }
        return selectedPageSet;
    }

    public static List<String> convertPageIDtoPageName(List<String> pageIDs) {
        ArrayList<String> pageNameList = new ArrayList<String>();
        for (String pageID : pageIDs) {
            PageInfo page = pagesMapByID.get(pageID);
            if (page != null) {
                pageNameList.add(page.getPageName());
                continue;
            }
            Logger.error((Object)("Unknown page ID: " + pageID));
        }
        return pageNameList;
    }
}

