/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAWindowingTableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.WindowingTableColumnSizePackListener;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class WebCallTraceTable
extends DAWindowingTableComposite {
    private String[] columnNames = new String[]{TimelinePageLabels.CALL_TRACE_VIEW_TIME, TimelinePageLabels.CALL_TRACE_VIEW_TID, TimelinePageLabels.CALL_TRACE_VIEW_PID, TimelinePageLabels.CALL_TRACE_VIEW_NAME, TimelinePageLabels.CALL_TRACE_VIEW_FILE, TimelinePageLabels.CALL_TRACE_VIEW_LINE_NUMBER};
    private int[] columnSizes = new int[]{65, 45, 45, 300, 300, 100};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true, true};
    private int[] sortTypes = new int[]{1, 1, 1, 2, 2, 1};

    public WebCallTraceTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setSortTypes(this.sortTypes);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.setItemHeightSize(16);
        parent.addControlListener((ControlListener)new WindowingTableColumnSizePackListener(this, this.columnSizes));
        this.setDataType(WebFunctionEntryDBTable.COLUMN.START_TIME.getIndex());
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<List<Object>> queriedData = this.getQueriedObjectData();
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        int size = queriedData.size();
        int i = 0;
        while (i < size) {
            List<Object> rowData = queriedData.get(i);
            ArrayList<String> contentText = new ArrayList<String>();
            long time = (Long)rowData.get(WebFunctionEntryDBTable.COLUMN.START_TIME.getIndex());
            contentText.add(Formatter.toTimeFormat(time));
            Integer tid = (Integer)rowData.get(WebFunctionEntryDBTable.COLUMN.TID.getIndex());
            contentText.add(Integer.toString(tid));
            Integer pid = (Integer)rowData.get(WebFunctionEntryDBTable.COLUMN.PID.getIndex());
            contentText.add(Integer.toString(pid));
            String functionName = (String)rowData.get(WebFunctionEntryDBTable.COLUMN.FUNCTION_NAME.getIndex());
            contentText.add(functionName);
            String functionURL = (String)rowData.get(WebFunctionEntryDBTable.COLUMN.FUNCTION_URL.getIndex());
            int lastIndex = functionURL.lastIndexOf("/");
            String fileName = functionURL.substring(lastIndex + 1);
            contentText.add(fileName);
            Integer functionLineNumber = (Integer)rowData.get(WebFunctionEntryDBTable.COLUMN.FUNCTION_LINE_NUMBER.getIndex());
            contentText.add(Integer.toString(functionLineNumber));
            DATableDataFormat tableData = new DATableDataFormat((Long)rowData.get(WebFunctionEntryDBTable.COLUMN.SEQUENCE_NUMBER.getIndex()));
            tableData.getData().addAll(rowData);
            tableData.setType(1024);
            TableInput tableInput = new TableInput();
            tableInput.setText(contentText);
            tableInput.setData(tableData);
            input.add(tableInput);
            if (RangeDataManager.getInstance().isBeingAnalyzed()) {
                long analysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
                long analysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
                if (time >= analysisStartTime && time <= analysisEndTime) {
                    tableInput.setInRange(true);
                }
            }
            ++i;
        }
        return input;
    }

    @Override
    protected String getDBTableName() {
        return CallTraceDataManager.getInstance().getWebFunctionEntryTable().getTableName();
    }

    @Override
    protected List<String> getDBTableColumnNames() {
        ArrayList<String> columnName = new ArrayList<String>();
        columnName.add("*");
        return columnName;
    }

    @Override
    protected int getItemCountByPid() {
        if (Global.getProject() == null) {
            return 0;
        }
        int itemCount = 0;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid != 0) {
            ProcessInformation process = Global.getProject().getProcessInformation(selectedPid);
            itemCount = process.getFunctionEntryLogCount();
        } else {
            itemCount = Global.getProject().getTotalFunctionEntryCount();
        }
        return itemCount;
    }

    @Override
    protected String getSelectQueryOption() {
        StringBuffer query = new StringBuffer();
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid != 0) {
            query.append("pid =" + selectedPid);
        }
        return query.toString();
    }

    @Override
    protected String getSelectQueryCountOption() {
        StringBuffer query = new StringBuffer();
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid != 0) {
            query.append("pid =" + selectedPid);
        }
        return query.toString();
    }

    @Override
    protected String getTimeColumnName() {
        return WebFunctionEntryDBTable.COLUMN.START_TIME.getName();
    }
}

