/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.uievent;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.DefaultCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.helper.ImageResources;

public class UIEventListDialogTableCellRenderer
extends DefaultCellRenderer {
    private int leftMargin = 4;
    private int rightMargin = 4;
    private int textTopMargin = 1;
    private int insideMargin = 3;
    private int CHECK_INDEX = 3;
    private final int buttonWidth;

    public UIEventListDialogTableCellRenderer() {
        this.buttonWidth = ImageResources.UIEVENT_DIALOG_START_SELECTED_NORMAL.getBounds().width;
    }

    public void paint(GC gc, Object value) {
        int len;
        Image image;
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        boolean drawAsSelected = this.isSelected();
        boolean drawBackground = true;
        if (this.isCellSelected()) {
            drawAsSelected = true;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_START);
            gc.setBackground(ColorResources.TABLE_CONTENTS_SELECTED_START);
        } else if (item.getParent().isEnabled()) {
            Color bg = item.getBackground();
            if (bg != null) {
                gc.setBackground(bg);
            } else {
                drawBackground = false;
            }
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        if (drawBackground && drawAsSelected) {
            gc.fillGradientRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, true);
        } else if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y + 1, this.getBounds().width, this.getBounds().height);
        }
        int x = this.leftMargin;
        if (this.getColumn() == this.CHECK_INDEX) {
            Integer data = (Integer)item.getData("old_hovered_INDEX");
            Image buttonImage = item.getChecked(this.CHECK_INDEX) ? (data != null && data == this.CHECK_INDEX ? ImageResources.UIEVENT_DIALOG_START_SELECTED_HOVER : ImageResources.UIEVENT_DIALOG_START_SELECTED_NORMAL) : (data != null && data == this.CHECK_INDEX ? ImageResources.UIEVENT_DIALOG_START_HOVER : ImageResources.UIEVENT_DIALOG_START_NORMAL);
            gc.drawImage(buttonImage, this.getStartButtonXPostion(), this.getBounds().y + 1);
            buttonImage = item.getChecked(this.CHECK_INDEX - 1) ? (data != null && data == this.CHECK_INDEX - 1 ? ImageResources.UIEVENT_DIALOG_END_SELECTED_HOVER : ImageResources.UIEVENT_DIALOG_END_SELECTED_NORMAL) : (data != null && data == this.CHECK_INDEX - 1 ? ImageResources.UIEVENT_DIALOG_END_HOVER : ImageResources.UIEVENT_DIALOG_END_NORMAL);
            gc.drawImage(buttonImage, this.getEndButtonXPosition(), this.getBounds().y + 1);
        }
        if ((image = item.getImage(this.getColumn())) != null) {
            int y = this.getBounds().y;
            gc.drawImage(image, this.getBounds().x + x, y += (this.getBounds().height - image.getBounds().height) / 2);
            x += image.getBounds().width + this.insideMargin;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        String text = item.getText(this.getColumn());
        if (this.getAlignment() == 131072) {
            len = gc.stringExtent((String)text).x;
            if (len < width) {
                x += width - len;
            }
        } else if (this.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
        } else {
            Color fontColor = item.getForeground();
            if (fontColor != null) {
                gc.setForeground(item.getForeground());
            } else {
                gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
            }
        }
        gc.setFont(FontResources.TABLE_CELL_FONT);
        if (this.getColumn() != this.CHECK_INDEX) {
            gc.drawText(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin, true);
        }
        if (item.getParent().getLinesVisible()) {
            gc.setForeground(ColorResources.TABLE_LINE);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        }
        if (this.isCellFocus()) {
            Rectangle focusRect = new Rectangle(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().width, this.getBounds().height + 1);
            gc.setForeground(ColorResources.RED);
            gc.drawRectangle(focusRect);
            if (this.isFocus()) {
                ++focusRect.x;
                focusRect.width -= 2;
                ++focusRect.y;
                focusRect.height -= 2;
                gc.drawRectangle(focusRect);
            }
        }
    }

    private int getStartButtonXPostion() {
        return this.getBounds().x + this.getBounds().width / 2 - this.buttonWidth - 5;
    }

    private int getEndButtonXPosition() {
        return this.getBounds().x + this.getBounds().width / 2 + 5;
    }

    private int getCheckBoxIndex(Point point) {
        Image buttonImage = point.x < this.getBounds().x + this.getBounds().width / 2 ? ImageResources.UIEVENT_DIALOG_START_NORMAL : ImageResources.UIEVENT_DIALOG_END_NORMAL;
        if (point.x >= this.getStartButtonXPostion() && point.x <= this.getStartButtonXPostion() + buttonImage.getBounds().width) {
            return this.CHECK_INDEX;
        }
        if (point.x >= this.getEndButtonXPosition() && point.x <= this.getEndButtonXPosition() + buttonImage.getBounds().width) {
            return this.CHECK_INDEX - 1;
        }
        return -1;
    }

    public boolean notify(int event, Point point, Object value) {
        if (this.getColumn() == this.CHECK_INDEX) {
            if (event == 5) {
                GridItem item = (GridItem)value;
                int checkBoxIndex = this.getCheckBoxIndex(point);
                Grid parentGrid = item.getParent();
                GridItem oldHoveredItem = (GridItem)parentGrid.getData("old_hovered_item");
                if (oldHoveredItem != null) {
                    oldHoveredItem.setData("old_hovered_INDEX", null);
                }
                if (checkBoxIndex != -1) {
                    parentGrid.setData("old_hovered_item", (Object)item);
                    item.setData("old_hovered_INDEX", (Object)checkBoxIndex);
                }
                parentGrid.redraw();
            } else if (event == 3) {
                GridItem item = (GridItem)value;
                int checkBoxIndex = this.getCheckBoxIndex(point);
                if (checkBoxIndex != -1) {
                    boolean isCheckEvent = !item.getChecked(this.getCheckBoxIndex(point));
                    Grid parentGrid = item.getParent();
                    if (isCheckEvent) {
                        double data = (Double)((DATableDataFormat)item.getData()).getObject();
                        if (checkBoxIndex == this.CHECK_INDEX) {
                            GridItem oldCheckedItem = (GridItem)parentGrid.getData("start_old_checked_item");
                            if (oldCheckedItem != null) {
                                oldCheckedItem.setChecked(this.CHECK_INDEX, false);
                            }
                            parentGrid.setData("start_old_checked_item", (Object)item);
                            parentGrid.setData("start_time", (Object)data);
                        } else {
                            GridItem oldCheckedItem = (GridItem)parentGrid.getData("end_old_checked_item");
                            if (oldCheckedItem != null) {
                                oldCheckedItem.setChecked(this.CHECK_INDEX - 1, false);
                            }
                            parentGrid.setData("end_old_checked_item", (Object)item);
                            parentGrid.setData("end_time", (Object)data);
                        }
                    } else if (checkBoxIndex == this.CHECK_INDEX) {
                        parentGrid.setData("start_time", (Object)-1.0);
                    } else {
                        parentGrid.setData("end_time", (Object)-1.0);
                    }
                    item.setChecked(checkBoxIndex, isCheckEvent);
                    return true;
                }
            }
        }
        return false;
    }
}

