/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.opentrace;

import java.io.File;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.toolbar.opentrace.OpenTraceProgressManager;
import org.tizen.dynamicanalyzer.ui.toolbar.opentrace.SaveFilesTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class OpenTraceDialog
extends DAMessageBox {
    private static boolean opened = false;
    public static int SAVE_FOLDER = 0;
    public static String VERSION_KEY = "version";
    public static int VERSION_INVALID = 0;
    public static int VERSION_VALID = 1;
    public static String CURRENT_KEY = "current";
    public static int CURRENT = 0;
    public static int OTHERS = 1;
    private DATableComposite saveTable = null;
    private Canvas detail = null;
    private Grid selectedTable = null;
    private DACustomButton openButton = null;
    private DACustomButton closeButton = null;
    ScrollBar detailViewHBar = null;
    int detailViewHSelectionIndex = 0;
    private String createTime = "";
    private String device = "";
    private String application = "";
    private long elapsedTime = 0L;
    private String[] columnNames = new String[]{AnalyzerLabels.OPEN_TRACE_DLG_TRACE_FILE_NAME, AnalyzerLabels.OPEN_TRACE_DLG_TRACE_DATE};
    private int[] columnSizes = new int[]{300, 200};
    private boolean[] columnVisibility = new boolean[]{true, true};
    int[] sortTypes = new int[]{3, 3};
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            if (OpenTraceDialog.this.selectedTable != null) {
                GridItem[] selections = OpenTraceDialog.this.selectedTable.getSelection();
                if (selections == null || selections.length == 0) {
                    return;
                }
                GridItem selection = selections[0];
                String openPath = null;
                if ((Integer)selection.getData() != SAVE_FOLDER) {
                    return;
                }
                openPath = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + selection.getText();
                OpenTraceProgressManager.getInstance().setSavePath(openPath);
                OpenTraceProgressManager.getInstance().startOpenTraceThread();
                OpenTraceDialog.this.result = 1;
                OpenTraceDialog.this.shell.dispose();
            }
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            OpenTraceDialog.this.shell.dispose();
        }
    };
    private SelectionListener saveTableSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            OpenTraceDialog.this.selectedTable = OpenTraceDialog.this.saveTable.getTable();
            OpenTraceDialog.this.updateDetails();
            OpenTraceDialog.this.updateOKButtonStatus();
            OpenTraceDialog.this.updateDetailViewHScroll(0);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            Grid grid = (Grid)e.widget;
            GridItem[] items = grid.getSelection();
            if (items.length == 0) {
                return;
            }
            GridItem item = items[0];
            String openPath = null;
            if ((Integer)item.getData() != SAVE_FOLDER) {
                return;
            }
            openPath = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + item.getText();
            if (!OpenTraceDialog.this.updateOKButtonStatus()) {
                return;
            }
            OpenTraceProgressManager.getInstance().setSavePath(openPath);
            OpenTraceProgressManager.getInstance().startOpenTraceThread();
            OpenTraceDialog.this.shell.dispose();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 127) {
                Grid grid = (Grid)e.widget;
                GridItem[] items = grid.getSelection();
                if (items.length == 0) {
                    return;
                }
                int index = grid.getSelectionIndex();
                GridItem item = items[0];
                if ((Integer)item.getData(CURRENT_KEY) == CURRENT) {
                    return;
                }
                String openPath = null;
                if ((Integer)item.getData() != SAVE_FOLDER) {
                    return;
                }
                openPath = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + item.getText();
                if (AnalyzerUtil.deleteFile(new File(openPath))) {
                    grid.remove(index);
                } else {
                    Logger.debug((Object)"delete save file failed...");
                }
                OpenTraceDialog.this.updateDetails();
                OpenTraceDialog.this.updateOKButtonStatus();
                OpenTraceDialog.this.updateDetailViewHScroll(0);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private PaintListener detailPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Canvas canvas = (Canvas)e.widget;
            Rectangle rect = canvas.getClientArea();
            e.gc.setBackground(ColorResources.WHITE);
            e.gc.fillRectangle(rect);
            e.gc.setForeground(ColorResources.OPEN_TRACE_TABLE_OUTLINE_COLOR);
            e.gc.drawRectangle(rect.x, rect.y, rect.width, rect.height - 1);
            if (!OpenTraceDialog.this.application.isEmpty() && !OpenTraceDialog.this.device.isEmpty()) {
                e.gc.setFont(FontResources.TABLE_CELL_FONT);
                String inputText = String.valueOf(AnalyzerLabels.OPEN_TRACE_DLG_DETAILS_APPLICATION) + OpenTraceDialog.this.application;
                Point textSize = e.gc.textExtent(inputText, 8);
                int fontHeight = textSize.y + 3;
                int x = rect.x + 7;
                int y = rect.y + 4;
                e.gc.setForeground(ColorResources.OPEN_TRACE_SAVE_CONTENTS_COLOR);
                e.gc.drawText(OpenTraceDialog.this.getDrawTextByScroll(inputText), x, y);
                inputText = String.valueOf(AnalyzerLabels.OPEN_TRACE_DLG_DETAILS_DEVICE) + OpenTraceDialog.this.device;
                e.gc.drawText(OpenTraceDialog.this.getDrawTextByScroll(inputText), x, y += fontHeight);
                inputText = String.valueOf(AnalyzerLabels.OPEN_TRACE_DLG_DETAILS_CREATE_TIME) + OpenTraceDialog.this.createTime;
                e.gc.drawText(OpenTraceDialog.this.getDrawTextByScroll(inputText), x, y += fontHeight);
                inputText = String.valueOf(AnalyzerLabels.OPEN_TRACE_DLG_DETAILS_RECORDING_TIME) + Formatter.toOpentraceTimeFormat(OpenTraceDialog.this.elapsedTime);
                e.gc.drawText(OpenTraceDialog.this.getDrawTextByScroll(inputText), x, y += fontHeight);
                OpenTraceDialog.this.updateDetailViewHScroll(textSize.x);
            }
        }
    };

    public OpenTraceDialog(Shell parent) {
        super(parent);
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(500, 368);
        this.shell.setText(AnalyzerLabels.OPEN_TRACE_TITLE);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Logger.debug((Object)"shell disposed!");
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        Composite tableComp = new Composite((Composite)this.shell, 0);
        tableComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 292;
        tableComp.setLayoutData((Object)data);
        tableComp.setBackground(ColorResources.DIALOG_BG_UPPER);
        Label saveFile = new Label(tableComp, 0x40000000);
        saveFile.setText(AnalyzerLabels.OPEN_TRACE_DLG_SAVED_FILE);
        saveFile.setBackground(ColorResources.DIALOG_BG_UPPER);
        saveFile.setAlignment(16384);
        saveFile.setForeground(ColorResources.OPEN_TRACE_LABEL_COLOR);
        saveFile.setFont(FontResources.OPEN_TRACE_INNER_TITLE);
        this.saveTable = new SaveFilesTable(tableComp, 2564);
        this.saveTable.setTableName(AnalyzerLabels.OPEN_TRACE_DLG_SAVE_TABLE_NAME);
        this.saveTable.setComparator(new DefaultTableComparator());
        this.saveTable.setSortTypes(this.sortTypes);
        this.saveTable.setColumns(this.columnNames);
        this.saveTable.setColumnSize(this.columnSizes);
        this.saveTable.setColumnVisibility(this.columnVisibility);
        this.saveTable.setItemHeightSize(17);
        this.saveTable.setTableToolTipEnable(false);
        this.saveTable.getTable().addSelectionListener(this.saveTableSelectionListener);
        this.saveTable.getTable().addMouseListener(this.mouseListener);
        this.saveTable.getTable().addKeyListener(this.keyListener);
        Label detailLabel = new Label(tableComp, 0x40000000);
        detailLabel.setText(AnalyzerLabels.OPEN_TRACE_DLG_DETAILS_TITLE);
        detailLabel.setBackground(ColorResources.DIALOG_BG_UPPER);
        detailLabel.setAlignment(16384);
        detailLabel.setForeground(ColorResources.OPEN_TRACE_LABEL_COLOR);
        detailLabel.setFont(FontResources.OPEN_TRACE_INNER_TITLE);
        this.detail = new Canvas(tableComp, 0x100100);
        this.detail.addPaintListener(this.detailPaintListener);
        this.detailViewHBar = this.detail.getHorizontalBar();
        this.detailViewHBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                OpenTraceDialog.this.detailViewHSelectionIndex = OpenTraceDialog.this.detailViewHBar.getSelection();
                OpenTraceDialog.this.detail.redraw();
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 7);
        data.height = 18;
        saveFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)saveFile, 0);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.height = 150;
        this.saveTable.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.saveTable, 10);
        data.left = new FormAttachment(0, 6);
        data.height = 18;
        detailLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)detailLabel, 0);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.height = 80;
        this.detail.setLayoutData((Object)data);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        buttonComp.setLayout((Layout)compLayout);
        buttonComp.setBackground(ColorResources.OPEN_TRACE_BUTTON_COMPOSITE_BG_COLOR);
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)tableComp, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        this.openButton = new DAButton(buttonComp, 0);
        this.openButton.addClickListener(this.okButtonListener);
        this.openButton.setText(WidgetLabels.OPEN);
        this.openButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        FormData okData = new FormData();
        okData.top = new FormAttachment(0, 10);
        okData.left = new FormAttachment(50, -90);
        okData.width = 86;
        okData.height = 24;
        this.openButton.setLayoutData((Object)okData);
        this.closeButton = new DAButton(buttonComp, 0);
        this.closeButton.addClickListener(this.cancelButtonListener);
        this.closeButton.setText(WidgetLabels.CLOSE);
        this.closeButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        FormData cancelData = new FormData();
        cancelData.top = new FormAttachment(0, 10);
        cancelData.left = new FormAttachment(50, 4);
        cancelData.width = 86;
        cancelData.height = 24;
        this.closeButton.setLayoutData((Object)cancelData);
        this.saveTable.updateTable();
        this.updateOKButtonStatus();
        this.updateDetailViewHScroll(0);
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        return true;
    }

    private boolean updateOKButtonStatus() {
        boolean isButtonStatus = false;
        if (this.selectedTable == null) {
            isButtonStatus = false;
        } else {
            GridItem[] items = this.selectedTable.getSelection();
            if (items.length == 0) {
                isButtonStatus = false;
            } else {
                isButtonStatus = true;
                if (items[0].getText(2).equals("N")) {
                    isButtonStatus = false;
                }
            }
        }
        this.openButton.setButtonEnabled(isButtonStatus);
        return isButtonStatus;
    }

    private void updateDetailViewHScroll(int textLenght) {
        int hScrollWidth = textLenght - this.detail.getBounds().width;
        if (this.application.equals("") || hScrollWidth < 0) {
            this.detailViewHBar.setMaximum(10);
        } else {
            if (hScrollWidth < 15) {
                hScrollWidth = 15;
            }
            this.detailViewHBar.setMaximum(hScrollWidth);
        }
        this.detailViewHBar.setMinimum(0);
    }

    private String getDrawTextByScroll(String text) {
        String drawTest = "";
        if (text.length() >= this.detailViewHSelectionIndex) {
            drawTest = (String)text.subSequence(this.detailViewHSelectionIndex, text.length());
        }
        return drawTest;
    }

    private void updateDetails() {
        GridItem[] items = this.selectedTable.getSelection();
        if (items.length == 0) {
            return;
        }
        GridItem item = items[0];
        String path = null;
        if ((Integer)item.getData() != SAVE_FOLDER) {
            return;
        }
        path = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + item.getText(0);
        int validCheck = (Integer)item.getData(VERSION_KEY);
        if (validCheck == VERSION_INVALID || !this.setDetailsInfo(path)) {
            this.createTime = "";
            this.device = "";
            this.application = "";
            this.elapsedTime = 0L;
        }
        this.detail.redraw();
    }

    private boolean setDetailsInfo(String path) {
        Project project = Project.getProjectFromFile(path);
        if (project != null) {
            this.createTime = project.getCreateTime();
            this.device = project.getDevice();
            this.application = project.getAppName();
            this.elapsedTime = project.getTotalStopTime();
            return true;
        }
        return false;
    }
}

