/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replay.data;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.swap.model.data.RecordEventObject;
import org.tizen.dynamicanalyzer.swap.model.data.ReplayData;
import org.tizen.dynamicanalyzer.util.Logger;

public class ReplayDBManager
extends DBTable {
    private static final String TABLENAME = "REPLAY";
    public static final String RID = "RID";
    public static final String SEQ = "SEQUENCE_NUMBER";
    public static final String TIME = "TIME";
    public static final String SEC = "SEC";
    public static final String NANO = "NANO";
    public static final String EVENT_ID = "EVENT_ID";
    public static final String EVENT_TYPE = "EVENT_TYPE";
    public static final String EVENT_CODE = "EVENT_CODE";
    public static final String EVENT_VALUE = "EVENT_VALUE";
    private static final int DB_RID_INDEX = 0;
    private static final int DB_SEQ_INDEX = 1;
    private static final int DB_TIME_INDEX = 2;
    private static final int DB_SEC_INDEX = 3;
    private static final int DB_NANO_INDEX = 4;
    private static final int DB_EVENT_ID_INDEX = 5;
    private static final int DB_EVENT_TYPE_INDEX = 6;
    private static final int DB_EVENT_CODE_INDEX = 7;
    private static final int DB_EVENT_VALUE = 8;
    private static final String SELECT_QUERY = "select RID,SEQUENCE_NUMBER,TIME,SEC,NANO,EVENT_ID,EVENT_TYPE,EVENT_CODE,EVENT_VALUE from REPLAY order by TIME,RID";
    private static final String DELETE_QUERY = "delete from REPLAY";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public ReplayDBManager() {
        this.addColumn(new DBColumn(RID, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(SEQ, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(SEC, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(NANO, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(EVENT_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(EVENT_TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(EVENT_CODE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(EVENT_VALUE, "NOT NULL", "INTEGER"));
    }

    public ReplayData getReplayLogs() {
        List<List<Object>> result = SqlConnectionManager.executeQuery(SELECT_QUERY);
        if (result == null || result.size() == 0 || result.get(0).size() == 0) {
            return null;
        }
        ReplayData output = new ReplayData();
        List<RecordEventObject> eventObjs = output.getRecordEvent();
        for (List<Object> data : result) {
            RecordEventObject reObj = new RecordEventObject();
            reObj.setMsgID((Integer)data.get(0));
            reObj.setSeq((Long)data.get(1));
            reObj.setTime((Long)data.get(2));
            DATime eventTime = new DATime();
            eventTime.setSec((Integer)data.get(3));
            eventTime.setNano((Integer)data.get(4));
            reObj.setEventTime(eventTime);
            reObj.setEventId((Integer)data.get(5));
            reObj.setEventType((Integer)data.get(6));
            reObj.setEventCode((Integer)data.get(7));
            reObj.setEventValue((Integer)data.get(8));
            eventObjs.add(reObj);
        }
        return output;
    }

    public boolean deleteReplayTableItems() {
        SqlConnectionManager.executeUpdate(DELETE_QUERY);
        return true;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setLong(2, (Long)rowData.get(1));
                prep.setLong(3, (Long)rowData.get(2));
                prep.setInt(4, (Integer)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setInt(6, (Integer)rowData.get(5));
                prep.setInt(7, (Integer)rowData.get(6));
                prep.setInt(8, (Integer)rowData.get(7));
                prep.setInt(9, (Integer)rowData.get(8));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

