/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.swap.platform.ui.BinarySettingProcessor;
import org.tizen.dynamicanalyzer.swap.platform.ui.BinarySettingProgressManager;
import org.tizen.dynamicanalyzer.swap.platform.ui.InputRow;
import org.tizen.dynamicanalyzer.swap.platform.ui.LoadSettingDialog;
import org.tizen.dynamicanalyzer.swap.platform.ui.SaveSettingDialog;
import org.tizen.dynamicanalyzer.ui.common.explorer.DeviceExplorerDialog;
import org.tizen.dynamicanalyzer.ui.common.explorer.FileExplorerDialog;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.WarningDialog;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;

public class SettingDialogBinarySettingsPage
extends DAPageComposite {
    public static final String ID = SettingDialogBinarySettingsPage.class.getName();
    public static final int RADIO_CURRENT = 1;
    public static final int RADIO_ADD = 2;
    public static final int RADIO_REMOVE = 3;
    private List<InputRow> inputRowList = null;
    private ScrolledComposite scrolledComposite = null;
    private Composite inputComposite = null;
    private DAButton clearButton = null;
    private DAButton addButton = null;
    private DAButton saveButton = null;
    private DAButton loadButton = null;
    private DAButton debugRootButton = null;
    private Label librariesLabel = null;
    private String rootPath = null;
    private SettingDialogBinarySettingsPage me = null;
    private DACustomButtonClickEventListener addButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            DeviceInfo curDev = Global.getCurrentDeviceInfo();
            if (curDev == null) {
                UIActionHolder.getUIAction().showWarning(SettingDialogBinarySettingsPage.this.getShell(), new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE));
            } else if (!curDev.isRootAvailable()) {
                UIActionHolder.getUIAction().showWarning(SettingDialogBinarySettingsPage.this.getShell(), new DAResult(DAResult.ErrorCode.ERR_BY_SECURITY));
            } else {
                DeviceExplorerDialog dialog = new DeviceExplorerDialog(SettingDialogBinarySettingsPage.this.getShell(), true);
                Object result = dialog.open();
                if (result != null) {
                    BinarySettingProgressManager.getInstance().startProcessStart("Wait for add binaries...");
                    BinarySettingProcessor.runAddThread(result, SettingDialogBinarySettingsPage.this.me);
                }
            }
        }
    };
    private DACustomButtonClickEventListener removeButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            String binaryPath = ((InputRow)button.getParent()).getBinaryName();
            SettingDialogBinarySettingsPage.this.removeInputRow(binaryPath);
            Composite inputComposite = button.getParent().getParent();
            BinarySettingData rmData = BinarySettingManager.getInstance().getBinarySetting(binaryPath);
            if (rmData != null) {
                ArrayList<String> rmBinaries = new ArrayList<String>();
                rmBinaries.add(rmData.getBinaryPath());
                try {
                    DACommunicator.removeInstrumentation(rmBinaries);
                }
                catch (InterruptedException interruptedException) {
                    Logger.warning((Object)"Intterrupted during send remove instrumentation message");
                }
                catch (UnsupportedProtocolException unsupportedProtocolException) {
                    Logger.warning((Object)"Message to remove instrumentation is not supported by communicator");
                }
            }
            BinarySettingManager.getInstance().removeBinarySettingData(binaryPath);
            button.getParent().dispose();
            ((SettingDialogBinarySettingsPage)inputComposite.getParent().getParent()).updateLayout();
        }
    };
    private DACustomButtonClickEventListener loadButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            block10: {
                DeviceInfo curDev = Global.getCurrentDeviceInfo();
                if (curDev == null) {
                    UIActionHolder.getUIAction().showWarning(SettingDialogBinarySettingsPage.this.getShell(), new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE));
                    return;
                }
                if (!curDev.isRootAvailable()) {
                    UIActionHolder.getUIAction().showWarning(SettingDialogBinarySettingsPage.this.getShell(), new DAResult(DAResult.ErrorCode.ERR_BY_SECURITY));
                    return;
                }
                LoadSettingDialog dialog = new LoadSettingDialog(button.getParent().getShell());
                Object result = dialog.open();
                if (result == null) {
                    return;
                }
                SettingDialogBinarySettingsPage.this.cleanRow();
                String path = (String)result;
                File saveFile = new File(path);
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(saveFile));
                    BinarySettingManager.getInstance().openData(br);
                    List<BinarySettingData> binarySettings = BinarySettingManager.getInstance().getBinarySettingList();
                    int i = 0;
                    while (i < binarySettings.size()) {
                        InputRow inputRow = new InputRow(SettingDialogBinarySettingsPage.this.inputComposite, SettingDialogBinarySettingsPage.this.removeButtonListener);
                        inputRow.setBinaryName(binarySettings.get(i).getBinaryPath());
                        inputRow.setDebugText(binarySettings.get(i).getDebugRpmPath());
                        inputRow.setSourceText(binarySettings.get(i).getUserSourceDir());
                        SettingDialogBinarySettingsPage.this.inputRowList.add(inputRow);
                        ++i;
                    }
                    BinarySettingProgressManager.getInstance().startProcessStart("now loading binaries...");
                    BinarySettingProcessor.runLoadingThread(SettingDialogBinarySettingsPage.this.me);
                }
                catch (FileNotFoundException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{br});
                    break block10;
                }
                catch (IOException e) {
                    try {
                        Logger.exception((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CommonUtil.tryClose((Object[])new Object[]{br});
                        throw throwable;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{br});
                    break block10;
                }
                CommonUtil.tryClose((Object[])new Object[]{br});
            }
        }
    };
    private DACustomButtonClickEventListener debugRootButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            FileExplorerDialog dialog = new FileExplorerDialog(SettingDialogBinarySettingsPage.this.getShell());
            dialog.getExplorer().setRoot(CommonUtil.getHomeDirectory());
            Object result = dialog.open();
            if (result != null) {
                List files = (List)result;
                if (!files.isEmpty()) {
                    File file = (File)files.get(0);
                    if (!file.isDirectory()) {
                        file = file.getParentFile();
                    }
                    if (file != null) {
                        SettingDialogBinarySettingsPage.this.rootPath = file.getAbsolutePath();
                    }
                }
                if (SettingDialogBinarySettingsPage.this.rootPath != null) {
                    BinarySettingProgressManager.getInstance().startProcessStart("Wait for update debug path");
                    BinarySettingProcessor.runUpdateDebugRoot(SettingDialogBinarySettingsPage.this.me);
                    BinarySettingManager.getInstance().setDebugRoot(SettingDialogBinarySettingsPage.this.rootPath);
                }
            }
        }
    };
    private DACustomButtonClickEventListener saveButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SaveSettingDialog dialog = new SaveSettingDialog(button.getParent().getShell(), SettingDialogBinarySettingsPage.this.inputRowList);
            dialog.open();
        }
    };
    private DACustomButtonClickEventListener cleanButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            if (button != null) {
                WarningDialog dialog = new WarningDialog(SettingDialogBinarySettingsPage.this.getShell(), 0);
                dialog.setMessage("Clear binary settings?\nIf you click 'Ok', All settings will be deleted");
                boolean result = dialog.open();
                if (!result) {
                    return;
                }
            }
            SettingDialogBinarySettingsPage.this.cleanRow();
        }
    };

    private void cleanRow() {
        List<BinarySettingData> binaries = BinarySettingManager.getInstance().getBinarySettingList();
        if (!binaries.isEmpty()) {
            ArrayList<String> removePaths = new ArrayList<String>();
            for (BinarySettingData data : binaries) {
                removePaths.add(data.getBinaryPath());
            }
            try {
                DACommunicator.removeInstrumentation(removePaths);
            }
            catch (InterruptedException interruptedException) {
                Logger.warning((Object)"Interrupted during send remove instrumentation message");
            }
            catch (UnsupportedProtocolException unsupportedProtocolException) {
                Logger.warning((Object)"Message to remove instrumentation is not supported by communicator");
            }
            int i = 0;
            while (i < this.inputRowList.size()) {
                BinarySettingManager.getInstance().removeBinarySettingData(this.inputRowList.get(i).getBinaryName());
                this.inputRowList.get(i).dispose();
                ++i;
            }
            this.inputRowList.clear();
        }
        this.updateLayout();
    }

    private void clearLayout() {
        int i = 0;
        while (i < this.inputRowList.size()) {
            this.inputRowList.get(i).dispose();
            ++i;
        }
        this.inputRowList.clear();
    }

    public SettingDialogBinarySettingsPage(Composite parent, int style) {
        super(parent, style);
        this.me = this;
        this.setTitle("Binary Settings");
        this.rootPath = PathManager.getRootstrapsPath((String)SettingDataManager.INSTANCE.getPlatform());
        this.inputRowList = new ArrayList<InputRow>();
        String settingPath = PathManager.DA_SETTING_PATH;
        File settingFolder = new File(settingPath);
        if (!(settingFolder.exists() && settingFolder.isDirectory() || settingFolder.mkdirs())) {
            Logger.debug((Object)"setting directory create failed...");
        }
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.DIALOG_BG_UPPER);
        int libCount = BinarySettingManager.getInstance().getBinarySettingList().size();
        this.librariesLabel = new Label((Composite)this, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 15);
        data.left = new FormAttachment(0, 16);
        data.height = 16;
        data.width = 100;
        this.librariesLabel.setLayoutData((Object)data);
        this.librariesLabel.setText("Libraies (" + libCount + ")");
        this.librariesLabel.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.librariesLabel.setFont(FontResources.getDADefaultFont());
        this.scrolledComposite = new ScrolledComposite((Composite)this, 2816);
        data = new FormData();
        data.top = new FormAttachment((Control)this.librariesLabel, 4);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.bottom = new FormAttachment(100, -45);
        this.scrolledComposite.setLayoutData((Object)data);
        this.scrolledComposite.setLayout((Layout)new FormLayout());
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackground(ColorResources.BINARY_SETTINGS_INPUT_BOX_COLOR);
        this.inputComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.inputComposite);
        this.scrolledComposite.setMinSize(this.inputComposite.computeSize(-1, -1));
        this.scrolledComposite.setShowFocusedControl(true);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, -5);
        this.inputComposite.setLayoutData((Object)data);
        this.inputComposite.setLayout((Layout)new FormLayout());
        this.inputComposite.setBackground(ColorResources.BINARY_SETTINGS_INPUT_BOX_COLOR);
        this.loadButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scrolledComposite, 17);
        data.left = new FormAttachment(0, 6);
        data.height = 22;
        data.width = 78;
        this.loadButton.setLayoutData((Object)data);
        this.loadButton.setText("Load");
        this.loadButton.addClickListener(this.loadButtonListener);
        this.saveButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scrolledComposite, 17);
        data.left = new FormAttachment((Control)this.loadButton, 6);
        data.height = 22;
        data.width = 78;
        this.saveButton.setLayoutData((Object)data);
        this.saveButton.setText("Save");
        this.saveButton.addClickListener(this.saveButtonListener);
        this.debugRootButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scrolledComposite, 17);
        data.left = new FormAttachment((Control)this.saveButton, 32);
        data.height = 22;
        data.width = 112;
        this.debugRootButton.setLayoutData((Object)data);
        this.debugRootButton.setText("Set DebugRoot");
        this.debugRootButton.addClickListener(this.debugRootButtonListener);
        this.clearButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scrolledComposite, 17);
        data.right = new FormAttachment(100, -6);
        data.height = 22;
        data.width = 78;
        this.clearButton.setLayoutData((Object)data);
        this.clearButton.setText("Clear");
        this.clearButton.addClickListener(this.cleanButtonListener);
        this.addButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scrolledComposite, 17);
        data.right = new FormAttachment((Control)this.clearButton, -6);
        data.height = 22;
        data.width = 78;
        this.addButton.setLayoutData((Object)data);
        this.addButton.setText("Add");
        this.addButton.addClickListener(this.addButtonListener);
        this.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                SettingDialogBinarySettingsPage.this.initInputRows();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
            }
        });
    }

    public void doApply() {
        for (InputRow inputRow : this.inputRowList) {
            String binary = inputRow.getBinaryName();
            String debug = inputRow.getDebugText();
            String source = inputRow.getSourceText();
            BinarySettingData binData = BinarySettingManager.getInstance().getBinarySetting(binary);
            if (binData != null) {
                binData.setDebugRpmPath(debug);
                binData.setUserSourceDir(source);
                continue;
            }
            Logger.debug((Object)"binary data is null");
        }
        Logger.debug((Object)"update complete!");
    }

    public void doClose() {
    }

    public void initInputRows() {
        List<BinarySettingData> binData = null;
        binData = BinarySettingManager.getInstance().getBinarySettingList();
        this.clearLayout();
        int i = 0;
        while (i < binData.size()) {
            InputRow inputRow = new InputRow(this.inputComposite, this.removeButtonListener);
            inputRow.setBinaryName(binData.get(i).getBinaryPath());
            String debug = binData.get(i).getDebugRpmPath();
            if (debug != null && !debug.isEmpty()) {
                inputRow.setDebugText(debug);
            } else {
                inputRow.setDebugText("");
            }
            String source = binData.get(i).getUserSourceDir();
            if (source != null && !source.isEmpty()) {
                inputRow.setSourceText(source);
            } else {
                source = binData.get(i).getRpmSourceDir();
                if (source != null && !source.isEmpty()) {
                    inputRow.setSourceText(source);
                } else {
                    inputRow.setSourceText("");
                }
            }
            this.inputRowList.add(inputRow);
            ++i;
        }
        this.updateLayout();
    }

    private void removeInputRow(String path) {
        InputRow prev = null;
        InputRow cur = null;
        InputRow next = null;
        int i = 0;
        while (i < this.inputRowList.size()) {
            if (i != 0) {
                prev = cur;
            }
            cur = this.inputRowList.get(i);
            next = i != this.inputRowList.size() - 1 ? this.inputRowList.get(i + 1) : null;
            if (cur.getBinaryName().equals(path)) {
                if (next != null) {
                    FormData nextData = (FormData)next.getLayoutData();
                    nextData.top = prev != null ? new FormAttachment((Control)prev, 2) : new FormAttachment(0, 0);
                }
                this.inputRowList.remove(i);
                break;
            }
            ++i;
        }
    }

    public void updateLayout() {
        int count = BinarySettingManager.getInstance().getBinarySettingList().size();
        this.librariesLabel.setText("Libraries (" + count + ")");
        this.inputComposite.layout();
        this.scrolledComposite.setMinSize(this.inputComposite.computeSize(-1, -1));
        if (count == 0) {
            this.saveButton.setButtonEnabled(false);
            this.clearButton.setButtonEnabled(false);
        } else {
            this.saveButton.setButtonEnabled(true);
            this.clearButton.setButtonEnabled(true);
        }
    }

    public String getDebugRootPath() {
        return this.rootPath;
    }
}

