/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureData;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.widgets.button.checkbox.DACheckBox;
import org.tizen.dynamicanalyzer.widgets.button.checkbox.DACheckboxSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;

public class SettingDialogOptionPage
extends DAPageComposite {
    public static final String ID = SettingDialogOptionPage.class.getName();
    private DACheckBox autoStopCheckBox = null;
    private DACheckBox recordingCheckBox = null;
    private DACheckBox onSceneTransitionCheckBox = null;
    private DACheckBox periodicallyCheckBox = null;
    private DATextBox periodicallyTextBox = null;
    private Label periodicallyTextBoxLabel = null;
    private Label periodicallyInfo = null;
    private boolean isValidInputValue = true;
    private DACheckboxSelectionListener autoStopCheckBoxListener = new DACheckboxSelectionListener(){

        public void handleSelectionEvent(DACheckBox checkbox) {
            SettingDataManager setting = SettingDataManager.INSTANCE;
            if (setting.isOptionsSelectedFeature(Feature.AUTO_STOP)) {
                setting.deleteOptionsSelectedFeature(Feature.AUTO_STOP);
                SettingDialogOptionPage.this.autoStopCheckBox.setChecked(false);
            } else {
                setting.addOptionsSelectedFeature(Feature.AUTO_STOP, 0);
                SettingDialogOptionPage.this.autoStopCheckBox.setChecked(true);
            }
        }
    };
    private DACheckboxSelectionListener recordingCheckBoxListener = new DACheckboxSelectionListener(){

        public void handleSelectionEvent(DACheckBox checkbox) {
            SettingDataManager setting = SettingDataManager.INSTANCE;
            if (setting.isOptionsSelectedFeature(Feature.RECORDING)) {
                setting.deleteOptionsSelectedFeature(Feature.RECORDING);
                SettingDialogOptionPage.this.recordingCheckBox.setChecked(false);
                if (setting.isOptionsSelectedFeature(Feature.AUTO_STOP)) {
                    setting.deleteOptionsSelectedFeature(Feature.AUTO_STOP);
                    SettingDialogOptionPage.this.autoStopCheckBox.setChecked(false);
                }
                SettingDialogOptionPage.this.autoStopCheckBox.setEnabled(false);
            } else {
                setting.addOptionsSelectedFeature(Feature.RECORDING, 0);
                SettingDialogOptionPage.this.recordingCheckBox.setChecked(true);
                SettingDialogOptionPage.this.autoStopCheckBox.setEnabled(true);
            }
        }
    };
    private DACheckboxSelectionListener onSceneTransitionCheckBoxListener = new DACheckboxSelectionListener(){

        public void handleSelectionEvent(DACheckBox checkbox) {
            SettingDataManager setting = SettingDataManager.INSTANCE;
            if (setting.isOptionsSelectedFeature(Feature.SCREENSHOT_ON_SCENE_TRANSITION)) {
                setting.deleteOptionsSelectedFeature(Feature.SCREENSHOT_ON_SCENE_TRANSITION);
                SettingDialogOptionPage.this.onSceneTransitionCheckBox.setChecked(false);
            } else {
                setting.addOptionsSelectedFeature(Feature.SCREENSHOT_ON_SCENE_TRANSITION, 0);
                SettingDialogOptionPage.this.onSceneTransitionCheckBox.setChecked(true);
            }
        }
    };
    private DACheckboxSelectionListener periodicallyCheckBoxListener = new DACheckboxSelectionListener(){

        public void handleSelectionEvent(DACheckBox checkbox) {
            SettingDataManager setting = SettingDataManager.INSTANCE;
            if (setting.isOptionsSelectedFeature(Feature.SCREENSHOT_PERIODICALLY)) {
                setting.deleteOptionsSelectedFeature(Feature.SCREENSHOT_PERIODICALLY);
                SettingDialogOptionPage.this.periodicallyCheckBox.setChecked(false);
                SettingDialogOptionPage.this.periodicallyTextBox.getControl().setEnabled(false);
                SettingDialogOptionPage.this.periodicallyInfo.setText("");
                SettingDialogOptionPage.this.isValidInputValue = true;
            } else {
                int value = setting.getOptionsFeaturInitValue(Feature.SCREENSHOT_PERIODICALLY);
                setting.addOptionsSelectedFeature(Feature.SCREENSHOT_PERIODICALLY, value);
                SettingDialogOptionPage.this.periodicallyCheckBox.setChecked(true);
                SettingDialogOptionPage.this.periodicallyTextBox.getControl().setEnabled(true);
                SettingDialogOptionPage.this.isValidInputValue = SettingDialogOptionPage.this.checkValidInputText(Feature.SCREENSHOT_PERIODICALLY, SettingDialogOptionPage.this.periodicallyTextBox, SettingDialogOptionPage.this.periodicallyInfo);
            }
        }
    };
    private KeyListener periodicallyTextBoxKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            SettingDialogOptionPage.this.isValidInputValue = SettingDialogOptionPage.this.checkValidInputText(Feature.SCREENSHOT_PERIODICALLY, SettingDialogOptionPage.this.periodicallyTextBox, SettingDialogOptionPage.this.periodicallyInfo);
            if (SettingDialogOptionPage.this.isValidInputValue) {
                SettingDataManager.INSTANCE.addOptionsSelectedFeature(Feature.SCREENSHOT_PERIODICALLY, Integer.parseInt(SettingDialogOptionPage.this.periodicallyTextBox.getText()));
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public SettingDialogOptionPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_CONFIGURATION_OPTION);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        Label settingLabel = new Label((Composite)this, 0x40000000);
        settingLabel.setText(ConfigureLabels.SETTING_OPTION_TAB_DESCRIPTION);
        settingLabel.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        settingLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        settingLabel.setFont(FontResources.SETTING_TITLE_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 14);
        data.left = new FormAttachment(0, 8);
        data.height = 18;
        settingLabel.setLayoutData((Object)data);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                Rectangle r = new Rectangle(8, 41, rect.width - 16, 23);
                e.gc.setForeground(ColorResources.SETTING_STROKE);
                e.gc.drawRectangle(r);
                e.gc.setBackground(ColorResources.SETTING_TITLE_BACKGROUND);
                e.gc.fillRectangle(9, 42, rect.width - 18, 21);
                r = new Rectangle(8, 124, rect.width - 16, 23);
                e.gc.drawRectangle(r);
                e.gc.fillRectangle(9, 125, rect.width - 18, 21);
            }
        });
        this.createRcording();
        this.createScreenShot();
        if (!DAState.isStartable()) {
            this.setEnabled(false);
        }
    }

    public void createRcording() {
        Label recordingTitleLabel = new Label((Composite)this, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 45);
        data.left = new FormAttachment(0, 16);
        data.height = 18;
        data.width = 120;
        recordingTitleLabel.setLayoutData((Object)data);
        recordingTitleLabel.setText(ConfigureLabels.SETTING_DIALOG_RECORDING_REPLAY);
        recordingTitleLabel.setBackground(ColorResources.SETTING_TITLE_BACKGROUND);
        recordingTitleLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        recordingTitleLabel.setFont(FontResources.SETTING_TITLE_FONT);
        recordingTitleLabel.setAlignment(16384);
        this.recordingCheckBox = new DACheckBox((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)recordingTitleLabel, 4);
        data.left = new FormAttachment(0, 19);
        data.height = 22;
        data.width = 16;
        this.recordingCheckBox.setLayoutData((Object)data);
        this.recordingCheckBox.setForeground(ColorResources.BLACK);
        this.recordingCheckBox.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.recordingCheckBox.setText(ConfigureLabels.FEATURE_NAME_RECORDING);
        this.recordingCheckBox.addSelectionListener(this.recordingCheckBoxListener);
        this.recordingCheckBox.setChecked(SettingDataManager.INSTANCE.isOptionsSelectedFeature(Feature.RECORDING));
        Label recordingLabel = new Label((Composite)this, 0x40000000);
        recordingLabel.setText(ConfigureLabels.FEATURE_NAME_RECORDING);
        recordingLabel.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        recordingLabel.setForeground(ColorResources.BLACK);
        recordingLabel.setFont(FontResources.CONFIGURATION_TABLE_TITLE_FONT);
        data = new FormData();
        data.top = new FormAttachment((Control)recordingTitleLabel, 7);
        data.left = new FormAttachment(0, 42);
        recordingLabel.setLayoutData((Object)data);
        this.autoStopCheckBox = new DACheckBox((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.recordingCheckBox, 4);
        data.left = new FormAttachment(0, 19);
        data.height = 22;
        data.width = 16;
        this.autoStopCheckBox.setLayoutData((Object)data);
        this.autoStopCheckBox.setForeground(ColorResources.BLACK);
        this.autoStopCheckBox.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.autoStopCheckBox.setText(ConfigureLabels.SETTING_OPTION_AUTO_STOP);
        this.autoStopCheckBox.addSelectionListener(this.autoStopCheckBoxListener);
        this.autoStopCheckBox.setChecked(SettingDataManager.INSTANCE.isOptionsSelectedFeature(Feature.AUTO_STOP));
        Label autoStopLabel = new Label((Composite)this, 0x40000000);
        autoStopLabel.setText(ConfigureLabels.SETTING_OPTION_AUTO_STOP);
        autoStopLabel.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        autoStopLabel.setForeground(ColorResources.BLACK);
        autoStopLabel.setFont(FontResources.CONFIGURATION_TABLE_TITLE_FONT);
        data = new FormData();
        data.top = new FormAttachment((Control)this.recordingCheckBox, 7);
        data.left = new FormAttachment(0, 42);
        autoStopLabel.setLayoutData((Object)data);
        if (!SettingDataManager.INSTANCE.isOptionsSelectedFeature(Feature.RECORDING)) {
            this.autoStopCheckBox.setChecked(false);
            this.autoStopCheckBox.setEnabled(false);
        }
    }

    public void createScreenShot() {
        Label screenshotTitleLabel = new Label((Composite)this, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 128);
        data.left = new FormAttachment(0, 16);
        data.height = 18;
        data.width = 120;
        screenshotTitleLabel.setLayoutData((Object)data);
        screenshotTitleLabel.setText(ConfigureLabels.SETTING_DIALOG_SCREENSHOT);
        screenshotTitleLabel.setBackground(ColorResources.SETTING_TITLE_BACKGROUND);
        screenshotTitleLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        screenshotTitleLabel.setFont(FontResources.SETTING_TITLE_FONT);
        screenshotTitleLabel.setAlignment(16384);
        this.onSceneTransitionCheckBox = new DACheckBox((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)screenshotTitleLabel, 4);
        data.left = new FormAttachment(0, 19);
        data.height = 22;
        data.width = 16;
        this.onSceneTransitionCheckBox.setLayoutData((Object)data);
        this.onSceneTransitionCheckBox.setForeground(ColorResources.BLACK);
        this.onSceneTransitionCheckBox.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.onSceneTransitionCheckBox.setText(ConfigureLabels.FEATURE_DETAIL_VALUE_SCREENSHOT_ON_SCENE_TRANSITION);
        this.onSceneTransitionCheckBox.addSelectionListener(this.onSceneTransitionCheckBoxListener);
        this.onSceneTransitionCheckBox.setChecked(SettingDataManager.INSTANCE.isOptionsSelectedFeature(Feature.SCREENSHOT_ON_SCENE_TRANSITION));
        Label onSceneTransitionLabel = new Label((Composite)this, 0x40000000);
        onSceneTransitionLabel.setText(ConfigureLabels.FEATURE_DETAIL_VALUE_SCREENSHOT_ON_SCENE_TRANSITION);
        onSceneTransitionLabel.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        onSceneTransitionLabel.setForeground(ColorResources.BLACK);
        onSceneTransitionLabel.setFont(FontResources.CONFIGURATION_TABLE_TITLE_FONT);
        data = new FormData();
        data.top = new FormAttachment((Control)screenshotTitleLabel, 7);
        data.left = new FormAttachment(0, 42);
        onSceneTransitionLabel.setLayoutData((Object)data);
        this.periodicallyCheckBox = new DACheckBox((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.onSceneTransitionCheckBox, 0);
        data.left = new FormAttachment(0, 19);
        data.height = 22;
        data.width = 16;
        this.periodicallyCheckBox.setLayoutData((Object)data);
        this.periodicallyCheckBox.setForeground(ColorResources.BLACK);
        this.periodicallyCheckBox.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.periodicallyCheckBox.setText(ConfigureLabels.FEATURE_DETAIL_VALUE_SCREENSHOT_PERIODICALLY);
        this.periodicallyCheckBox.addSelectionListener(this.periodicallyCheckBoxListener);
        boolean isSelectedFeature = SettingDataManager.INSTANCE.isOptionsSelectedFeature(Feature.SCREENSHOT_PERIODICALLY);
        this.periodicallyCheckBox.setChecked(isSelectedFeature);
        Label periodicallyLabel = new Label((Composite)this, 0x40000000);
        periodicallyLabel.setText(ConfigureLabels.FEATURE_DETAIL_VALUE_SCREENSHOT_PERIODICALLY);
        periodicallyLabel.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        periodicallyLabel.setForeground(ColorResources.BLACK);
        periodicallyLabel.setFont(FontResources.CONFIGURATION_TABLE_TITLE_FONT);
        data = new FormData();
        data.top = new FormAttachment((Control)this.onSceneTransitionCheckBox, 3);
        data.left = new FormAttachment(0, 42);
        data.width = 75;
        periodicallyLabel.setLayoutData((Object)data);
        this.periodicallyTextBox = new DATextBox((Composite)this, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)this.onSceneTransitionCheckBox, 3);
        data.left = new FormAttachment((Control)periodicallyLabel, 0);
        data.width = 48;
        data.height = 16;
        this.periodicallyTextBox.setLayoutData(data);
        this.periodicallyTextBox.setForeground(ColorResources.SETTING_COLOR);
        this.periodicallyTextBox.setFont(FontResources.CONFIGURATION_TABLE_TITLE_FONT);
        this.periodicallyTextBox.setText(String.valueOf(SettingDataManager.INSTANCE.getOptionsFeatureValue(Feature.SCREENSHOT_PERIODICALLY)));
        this.periodicallyTextBox.getControl().addKeyListener(this.periodicallyTextBoxKeyListener);
        this.periodicallyTextBox.setTextTooltip(true);
        this.periodicallyTextBox.setTextTooltipMessage(ConfigureLabels.FEATURE_OVERHEAD_RANKING_INPUT_VALUE);
        this.periodicallyTextBox.getControl().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        this.periodicallyTextBoxLabel = new Label((Composite)this, 0x40000000);
        this.periodicallyTextBoxLabel.setText(ConfigureLabels.SECOND);
        data = new FormData();
        data.top = new FormAttachment((Control)this.onSceneTransitionCheckBox, 5);
        data.left = new FormAttachment((Control)this.periodicallyTextBox.getControl(), 4);
        data.width = 70;
        data.height = 16;
        this.periodicallyTextBoxLabel.setLayoutData((Object)data);
        this.periodicallyTextBoxLabel.setForeground(ColorResources.SETTING_COLOR);
        this.periodicallyTextBoxLabel.setFont(FontResources.CONFIGURATION_TABLE_TITLE_FONT);
        this.periodicallyTextBoxLabel.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.periodicallyInfo = new Label((Composite)this, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment((Control)this.onSceneTransitionCheckBox, 5);
        data.left = new FormAttachment((Control)this.periodicallyTextBoxLabel, 0);
        data.width = 250;
        data.height = 16;
        this.periodicallyInfo.setLayoutData((Object)data);
        this.periodicallyInfo.setForeground(ColorResources.SETTING_WARNING_FONT_COLOR);
        this.periodicallyInfo.setFont(FontResources.CONFIGURATION_TABLE_TITLE_FONT);
        this.periodicallyInfo.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        if (isSelectedFeature) {
            this.periodicallyTextBox.getControl().setEnabled(true);
            this.isValidInputValue = this.checkValidInputText(Feature.SCREENSHOT_PERIODICALLY, this.periodicallyTextBox, this.periodicallyInfo);
        } else {
            this.periodicallyTextBox.getControl().setEnabled(false);
            this.periodicallyInfo.setText("");
        }
    }

    private boolean checkValidInputText(Feature feature, DATextBox textBox, Label info) {
        FeatureData featureData = feature.getData();
        String errormsg = featureData.validateInputValue(textBox.getText());
        info.setText(errormsg);
        return errormsg.isEmpty();
    }

    public boolean isValidInputValue() {
        return this.isValidInputValue;
    }

    public void revertInputValue() {
        int value = SettingDataManager.INSTANCE.getOptionsFeaturInitValue(Feature.SCREENSHOT_PERIODICALLY);
        this.periodicallyTextBox.setText(String.valueOf(value));
        this.periodicallyInfo.setText("");
        this.isValidInputValue = true;
        SettingDataManager.INSTANCE.addOptionsSelectedFeature(Feature.SCREENSHOT_PERIODICALLY, Integer.parseInt(this.periodicallyTextBox.getText()));
    }
}

