/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.BinaryOperator;
import org.eclipse.core.runtime.CoreException;

public class OperatorModulo
extends BinaryOperator {
    public OperatorModulo(int start) {
        this(0, false, start);
    }

    protected OperatorModulo(int resultId, boolean isAssignmentOperator, int start) {
        super(resultId, isAssignmentOperator, start);
    }

    @Override
    protected int getIntResult(int leftOperand, int rightOperand) throws CoreException {
        if (rightOperand == 0) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.DivideByZero);
        }
        return leftOperand % rightOperand;
    }

    @Override
    protected long getLongResult(long leftOperand, long rightOperand) throws CoreException {
        if (rightOperand == 0L) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.DivideByZero);
        }
        return leftOperand % rightOperand;
    }

    @Override
    protected BigInteger getBigIntegerResult(BigInteger leftOperand, BigInteger rightOperand, int length) throws CoreException {
        if (rightOperand.equals(BigInteger.ZERO)) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.DivideByZero);
        }
        return leftOperand.mod(rightOperand);
    }

    @Override
    protected float getFloatResult(float leftOperand, float rightOperand) {
        return leftOperand % rightOperand;
    }

    @Override
    protected double getDoubleResult(double leftOperand, double rightOperand) {
        return leftOperand % rightOperand;
    }

    @Override
    protected boolean getBooleanResult(boolean leftOperand, boolean rightOperand) {
        return false;
    }
}

