/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.io.IOException;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ISectionMapper;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionInfo;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSection;

public class ExecutableSection
implements IExecutableSection {
    private final String name;
    private final ISectionMapper executableSectionMapper;
    private final SectionInfo section;
    private IStreamBuffer buffer;
    private boolean deadSection;

    public ExecutableSection(ISectionMapper executableSectionMapper, String name, SectionInfo section) {
        this.executableSectionMapper = executableSectionMapper;
        this.name = name;
        this.section = section;
        this.deadSection = false;
    }

    public String toString() {
        return String.valueOf(this.name) + " @ " + this.section + (this.deadSection ? " <<BROKEN>>" : "");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStreamBuffer getBuffer() {
        if (this.buffer == null && !this.deadSection) {
            try {
                this.buffer = this.executableSectionMapper.getSectionBuffer(this.section);
            }
            catch (IOException e) {
                this.deadSection = true;
                EDCDebugger.getMessageLogger().logError("Failed to read section " + this.name, e);
            }
        }
        return this.buffer;
    }

    @Override
    public void dispose() {
        this.executableSectionMapper.releaseSectionBuffer(this.section);
        this.buffer = null;
    }
}

