/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.util.IKindBasedInfo;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntriesNamesContainer {
    private KindBasedStore<Set<String>> fRemovedEntryNamesStore = new KindBasedStore();

    public EntriesNamesContainer() {
    }

    public EntriesNamesContainer(EntriesNamesContainer base) {
        IKindBasedInfo<Set<String>>[] infos = base.fRemovedEntryNamesStore.getContents();
        int i = 0;
        while (i < infos.length) {
            Set<String> set = infos[i].getInfo();
            if (set != null) {
                this.fRemovedEntryNamesStore.put(infos[i].getKind(), new HashSet<String>(set));
            }
            ++i;
        }
    }

    private Set<String> getRemovedNamesSet(int kind, boolean create) {
        Set<String> set = this.fRemovedEntryNamesStore.get(kind);
        if (set == null && create) {
            set = new HashSet<String>();
            this.fRemovedEntryNamesStore.put(kind, set);
        }
        return set;
    }

    public void clear() {
        this.fRemovedEntryNamesStore.clear();
    }

    public void clear(int kind) {
        this.fRemovedEntryNamesStore.put(kind, null);
    }

    public boolean contains(int kind, String name) {
        Set<String> set = this.getRemovedNamesSet(kind, false);
        if (set != null) {
            return set.contains(name);
        }
        return false;
    }

    public boolean add(int kind, String name) {
        return this.getRemovedNamesSet(kind, true).add(name);
    }

    public boolean remove(int kind, String name) {
        Set<String> set = this.getRemovedNamesSet(kind, false);
        if (set != null) {
            return set.remove(name);
        }
        return false;
    }

    public void set(int kind, String[] names) {
        if (names == null || names.length == 0) {
            this.clear(kind);
        } else {
            Set<String> set = this.getRemovedNamesSet(kind, true);
            set.clear();
            EntriesNamesContainer.add(set, names);
        }
    }

    private static void add(Set<String> set, String[] names) {
        int i = 0;
        while (i < names.length) {
            set.add(names[i]);
            ++i;
        }
    }

    public void add(int kind, String[] names) {
        if (names == null || names.length == 0) {
            return;
        }
        Set<String> set = this.getRemovedNamesSet(kind, true);
        EntriesNamesContainer.add(set, names);
    }
}

