/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.communicator.AckMessage;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.communicator.ProtocolSerializer;
import org.tizen.dynamicanalyzer.communicator.SubCommunicator;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.protocol.p30.Communicator30;
import org.tizen.dynamicanalyzer.protocol.p30_uihv.Communicator30_UIHV;
import org.tizen.dynamicanalyzer.protocol.p40.Communicator40;
import org.tizen.dynamicanalyzer.protocol.p41.Communicator41;
import org.tizen.dynamicanalyzer.util.ByteUtil;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class BaseCommunicator {
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int ACK_HEADER_SIZE = 8;
    private static final int PORT_WAIT_TIME = 10000;
    private static final int PORT_WAIT_INTERVAL = 50;
    private DeviceInfo device = null;
    private String protocolVersion = null;
    private SubCommunicator subCommunicator = null;
    private int localPort = -1;
    private int remotePort = -1;
    private Socket controlSocket = null;

    public BaseCommunicator(DeviceInfo device) {
        this.device = device;
    }

    public DeviceInfo getDevice() {
        return this.device;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public Socket getControlSock() {
        return this.controlSocket;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public SubCommunicator getSubCommunicator() {
        return this.subCommunicator;
    }

    /*
     * Exception decompiling
     */
    public DAResult connect() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DAResult disconnect() {
        if (this.subCommunicator != null) {
            this.subCommunicator.disconnect();
        }
        if (this.controlSocket != null) {
            try {
                this.controlSocket.close();
            }
            catch (IOException iOException) {
                Logger.warning((Object)"Failed to close control socket");
            }
        }
        DebugLog.closeControlChannelWriter();
        return new DAResult(DAResult.ErrorCode.SUCCESS);
    }

    private DAResult getRemotePort() {
        DAResult result = new DAResult(DAResult.ErrorCode.SUCCESS);
        final ArrayList portLines = new ArrayList();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 10000L) {
            try {
                portLines.clear();
                CommunicatorUtils.execShellCommand(this.device.getIDevice(), "cat /tmp/port.da", (IShellOutputReceiver)new MultiLineReceiver(){

                    public void processNewLines(String[] lines) {
                        if (lines.length > 0) {
                            portLines.add(lines[0]);
                        }
                    }
                });
                if (!portLines.isEmpty()) {
                    String line = (String)portLines.get(0);
                    try {
                        this.remotePort = Integer.parseInt(line);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logger.debug((boolean)false, (Object)"=");
                    }
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                Logger.debug();
                Logger.debug((Object)"Interrupt occurred while getting port number");
                break;
            }
        }
        Logger.debug();
        if (this.remotePort < 0) {
            Logger.error((Object)"!!failed to get port number of da manager!!");
            result = new DAResult(DAResult.ErrorCode.ERR_REMOTE_PORT_GET_FAILED);
        } else {
            Logger.debug((Object)("!!port number is obtained successfully!! : " + this.remotePort));
        }
        return result;
    }

    private DAResult createControlSocket() {
        DAResult result = new DAResult(DAResult.ErrorCode.SUCCESS);
        Socket sock = null;
        try {
            sock = new Socket("127.0.0.1", this.localPort);
            sock.setSoTimeout(20000);
            sock.setReuseAddress(true);
            sock.setTcpNoDelay(true);
        }
        catch (UnknownHostException e) {
            result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            result.setDetailMessage(e.getMessage());
            Logger.exception((Throwable)e);
        }
        catch (SocketException e) {
            result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            result.setDetailMessage(e.getMessage());
            Logger.exception((Throwable)e);
        }
        catch (IOException e) {
            result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            result.setDetailMessage(e.getMessage());
            Logger.exception((Throwable)e);
        }
        if (result.isSuccess()) {
            this.controlSocket = sock;
        } else {
            CommonUtil.tryClose((Object[])new Object[]{sock});
        }
        return result;
    }

    private String checkVersion() {
        String version = this.checkVersionByMessage();
        if (version == null || version.isEmpty()) {
            version = this.checkVersionByCommand();
        }
        return version;
    }

    private String checkVersionByMessage() {
        byte[] pbyte;
        String version = null;
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(1);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.handleControlMessage(msg);
        if (result != null && result.isSuccess() && result.isCorrectID(4097) && result.getPayloadLength() > 4 && (pbyte = result.getPayload()) != null) {
            ProtocolParser parser = new ProtocolParser(pbyte);
            parser.getInt();
            version = parser.getString();
            if (version.equals(Protocol.VERSION_30.toString())) {
                version = Protocol.VERSION_30_UIHV.toString();
            }
        }
        return version;
    }

    private String checkVersionByCommand() {
        final ArrayList checkVersionResult = new ArrayList();
        CommunicatorUtils.execShellCommand(this.device.getIDevice(), "/usr/bin/profile_command getversion", (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                if (appLines.length > 0) {
                    checkVersionResult.add(appLines[0]);
                }
            }
        });
        if (!checkVersionResult.isEmpty() && Protocol.getVersion((String)checkVersionResult.get(0)) == Protocol.VERSION_30) {
            return Protocol.VERSION_30.toString();
        }
        return null;
    }

    private DAResult makeSubCommunicator() {
        DAResult result = new DAResult(DAResult.ErrorCode.SUCCESS);
        Protocol version = Protocol.getVersion(this.protocolVersion);
        switch (version) {
            case VERSION_30: 
            case VERSION_30A: {
                this.subCommunicator = new Communicator30(this);
                break;
            }
            case VERSION_30_UIHV: {
                this.subCommunicator = new Communicator30_UIHV(this);
                break;
            }
            case VERSION_40: {
                this.subCommunicator = new Communicator40(this);
                break;
            }
            case VERSION_41: 
            case VERSION_42: {
                this.subCommunicator = new Communicator41(this);
                break;
            }
            default: {
                result = new DAResult(DAResult.ErrorCode.ERR_INVALID_VERSION);
            }
        }
        return result;
    }

    public AckMessage handleControlMessage(byte[] message) {
        return this.handleControlMessage(message, 20000);
    }

    public AckMessage handleControlMessage(byte[] message, IProgress progress) {
        return this.handleControlMessage(message, 20000, true, progress);
    }

    public AckMessage handleControlMessage(byte[] message, int timeout) {
        return this.handleControlMessage(message, 20000, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AckMessage handleControlMessage(byte[] message, int timeout, boolean waitAck, IProgress progress) {
        AckMessage retack;
        block15: {
            retack = null;
            try {
                if (this.controlSocket != null && !this.controlSocket.isClosed()) {
                    this.debugPrintMessage(message);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Socket socket = this.controlSocket;
                    synchronized (socket) {
                        OutputStream out = this.controlSocket.getOutputStream();
                        out.write(message);
                        out.flush();
                        if (progress != null) {
                            progress.run();
                        }
                        if (!waitAck) {
                            return AckMessage.NOACK;
                        }
                        int oldtimeout = this.controlSocket.getSoTimeout();
                        this.controlSocket.setSoTimeout(timeout);
                        InputStream in = this.controlSocket.getInputStream();
                        int readsize = -1;
                        byte[] cbuf = new byte[1024];
                        readsize = in.read(cbuf, 0, 8);
                        if (readsize == 8) {
                            baos.write(cbuf, 0, readsize);
                            int payloadsize = ByteUtil.toInt((byte[])cbuf, (int)4);
                            do {
                                readsize = in.read(cbuf, 0, 1024);
                                baos.write(cbuf, 0, readsize);
                            } while ((payloadsize -= readsize) > 0);
                        } else {
                            Logger.error((Object)"Wrong ack message format");
                        }
                        this.controlSocket.setSoTimeout(oldtimeout);
                    }
                    int readsize = baos.size();
                    byte[] sbuf = baos.toByteArray();
                    this.debugPrintMessage(sbuf);
                    if (readsize > 0) {
                        retack = new AckMessage();
                        retack.parseAck(sbuf);
                    } else {
                        Logger.error((Object)"Wrong ACK message format");
                    }
                    break block15;
                }
                Logger.warning((Object)"Control socket connection is closed");
            }
            catch (SocketTimeoutException e) {
                Logger.exception((Throwable)e);
            }
            catch (SocketException e) {
                Logger.exception((Throwable)e);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
        return retack;
    }

    private void debugPrintMessage(byte[] msg) {
        try {
            if (msg == null) {
                return;
            }
            int msgid = ByteUtil.toInt((byte[])msg);
            if (msgid < 4096) {
                DebugLog.printControl0("send : ", new Object[0]);
            } else {
                DebugLog.printControl1("recv : ", new Object[0]);
            }
            int k = 0;
            while (k < msg.length) {
                DebugLog.printControl0("%02x ", msg[k]);
                ++k;
            }
            DebugLog.printControl0("\n", new Object[0]);
        }
        catch (Exception exception) {
            Logger.error((Object)("msg is invalid - " + Arrays.toString(msg)));
        }
    }
}

