/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.dynamicanalyzer.communicator.BaseCommunicator;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.DeviceStatusInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.ui.info.screenshot.EmulatorScreenshot;
import org.tizen.sdblib.IDevice;

public class DeviceInfo {
    private IDevice device = null;
    private BaseCommunicator communicator = null;
    private String selectedPackage = null;
    private boolean configSuccess = false;
    private Map<String, PackageInfo> pkgInfoHash = new HashMap<String, PackageInfo>();
    private DeviceStatusInfo statusInfo = null;
    private String profileName = null;
    private boolean availabilityOfRoot = false;
    private boolean availableMemps = false;
    public EmulatorScreenshot emulatorScreenshot = null;

    public DeviceInfo(IDevice device) {
        this.device = device;
        this.communicator = new BaseCommunicator(this);
        this.statusInfo = new DeviceStatusInfo();
        this.availableMemps = false;
    }

    public void setSelectedPackageLabel(String label) {
        this.selectedPackage = label;
    }

    public String getSelectedPackageLabel() {
        return this.selectedPackage;
    }

    public IDevice getIDevice() {
        return this.device;
    }

    public boolean isSameDevice(DeviceInfo target) {
        return this.device.getSerialNumber().equals(target.getIDevice().getSerialNumber());
    }

    public DeviceStatusInfo getDeviceStatusInfo() {
        return this.statusInfo;
    }

    public BaseCommunicator getCommunicator() {
        return this.communicator;
    }

    public Map<String, PackageInfo> getPackageInfoHash() {
        return this.pkgInfoHash;
    }

    public PackageInfo getSelectedPackage(String pkgId) {
        return this.pkgInfoHash.get(pkgId);
    }

    public String getPlatformName() {
        if (this.profileName == null) {
            ProfileInfo profile = ProfileInfo.getProfileInfo((IDevice)this.device);
            if (profile != null) {
                this.profileName = profile.getProfile();
            }
            if (this.profileName == null) {
                this.profileName = "";
            }
        }
        return this.profileName;
    }

    public boolean isEmulator() {
        return this.device != null && this.device.getSerialNumber().contains("emulator");
    }

    public boolean isConfigSuccess() {
        return this.configSuccess;
    }

    public void setConfigSuccess(boolean success) {
        this.configSuccess = success;
    }

    public boolean isRootAvailable() {
        return this.availabilityOfRoot;
    }

    public void setAvailabilityOfRoot(boolean availability) {
        this.availabilityOfRoot = availability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePackageList(Map<String, PackageInfo> newPackages) {
        PackageInfo oldpkg;
        Map<String, PackageInfo> map = this.pkgInfoHash;
        synchronized (map) {
            Iterator<Map.Entry<String, PackageInfo>> iter = this.pkgInfoHash.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, PackageInfo> entry = iter.next();
                String pkgid = entry.getKey();
                oldpkg = entry.getValue();
                PackageInfo newpkg = newPackages.get(pkgid);
                if (newpkg == null) {
                    iter.remove();
                    continue;
                }
                if (oldpkg.getInstallTime() == newpkg.getInstallTime()) continue;
                entry.setValue(newpkg);
            }
        }
        for (Map.Entry<String, PackageInfo> entry : newPackages.entrySet()) {
            String pkgid = entry.getKey();
            PackageInfo newpkg = entry.getValue();
            oldpkg = this.pkgInfoHash.get(pkgid);
            if (oldpkg != null) continue;
            Map<String, PackageInfo> map2 = this.pkgInfoHash;
            synchronized (map2) {
                this.pkgInfoHash.put(pkgid, newpkg);
            }
        }
    }

    public PackageInfo getPkgInfoByLabel(String appLabel) {
        for (Map.Entry<String, PackageInfo> entry : this.pkgInfoHash.entrySet()) {
            AppInfo app = entry.getValue().getMainApp();
            String label = app.getLabel();
            if (!appLabel.equals(label)) continue;
            return entry.getValue();
        }
        return null;
    }

    public PackageInfo getPkgInfoByPkgID(String pkgid) {
        return this.pkgInfoHash.get(pkgid);
    }

    public PackageInfo getPkgInfoByAppID(String appid) {
        for (Map.Entry<String, PackageInfo> entry : this.pkgInfoHash.entrySet()) {
            AppInfo app = entry.getValue().getMainApp();
            String appID = app.getAppID();
            if (!appID.equals(appid)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setMempAvailable(boolean enable) {
        this.availableMemps = enable;
    }

    public boolean getMempAvailable() {
        return this.availableMemps;
    }
}

