/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.handlers;

import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.ReplayData;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.toolbar.replay.data.ReplayDataManager;
import org.tizen.dynamicanalyzer.widgets.timer.IAlarm;

public class ReplayManager {
    private static boolean isReplay = false;
    private static DATime startTime = null;
    private static long stopTime = -1L;
    private static ReplayData replayData = null;

    public static boolean init() {
        isReplay = true;
        stopTime = Global.getProject().getReplayStopTime();
        startTime = Global.getProject().getProfilingStartTime();
        replayData = ReplayDataManager.getInstance().getReplayDBManager().getReplayLogs();
        return true;
    }

    public static void setStopAlarm() {
        if (isReplay && SettingDataManager.INSTANCE.isOptionsSelectedPrefereces(FlatPreferences.AUTO_STOP)) {
            Toolbar.INSTANCE.setTimerAlarm(stopTime, new IAlarm(){

                public void action() {
                    CommandAction.stopTrace(new DAResult(DAResult.ErrorCode.SUCCESS), false);
                    ReplayManager.reset();
                }
            });
        }
    }

    public static void resetStopAlarm() {
        if (Global.isGUIMode()) {
            Toolbar.INSTANCE.removeTimerAlarm();
        }
        ReplayManager.reset();
    }

    public static DATime getStartTime() {
        return startTime;
    }

    public static ReplayData getReplayData() {
        return replayData;
    }

    public static boolean isReplayMode() {
        return isReplay;
    }

    public static void reset() {
        isReplay = false;
    }
}

