/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureData;
import org.tizen.dynamicanalyzer.setting.FeatureValueData;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingConstants;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.setting.Template;
import org.tizen.dynamicanalyzer.setting.TemplateData;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;

public enum SettingDataManager {
    INSTANCE;

    private boolean parsingSuccess = true;
    private double version = 0.0;
    private int logLevel = 0;
    private List<Feature> defaultFeatureList = new ArrayList<Feature>();
    private List<Long> totalOverheadRange = new ArrayList<Long>();
    private String initTarget = null;
    private List<FlatPreferences> initOptionsSelectedPreferenceList = new ArrayList<FlatPreferences>();
    private String selectedTarget = null;
    private List<FlatPreferences> optionsSelectedPreferenceList = new ArrayList<FlatPreferences>();
    private Map<String, TargetData> targetListMap = new LinkedHashMap<String, TargetData>();
    private boolean isPlatformDA = false;
    private boolean isNewSetting = false;

    private SettingDataManager() {
        if (SettingConstants.SettingFilePath == null) {
            SettingConstants.SettingFilePath = String.valueOf(PathManager.DA_CONFIG_FOLDER_PATH) + File.separator;
        }
        this.readFlatFeatureFile();
        this.readFeatureFile();
        this.readTemplateFile();
        this.readSettingFile();
    }

    public boolean isParsingSuccess() {
        return this.parsingSuccess;
    }

    private void readFlatFeatureFile() {
        block8: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "flatfeature");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    String[] list = content.split("\\|", -1);
                    if (list == null) continue;
                    int index = Integer.parseInt(list[0]);
                    FlatFeature feature = FlatFeature.getFlatFeature(index);
                    if (feature == null) {
                        Logger.error((Object)("unknown feature : " + list[0] + ", " + list[1]));
                        continue;
                    }
                    feature.setOverheadRanking(list[9]);
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block8;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block8;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void readFeatureFile() {
        block9: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "feature");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    int parentIndex;
                    String[] list = content.split("\\|", -1);
                    if (list == null) continue;
                    int index = Integer.parseInt(list[0]);
                    Feature feature = Feature.getFeature(index);
                    if (feature == null) {
                        Logger.error((Object)("unknown feature : " + list[0] + ", " + list[1]));
                        continue;
                    }
                    FeatureData featureData = feature.getData();
                    featureData.setFeatureType(Integer.parseInt(list[2]));
                    if (list[3] != null && !list[3].isEmpty() && Feature.getFeature(parentIndex = Integer.parseInt(list[3])) != null) {
                        featureData.setParentIndex(parentIndex);
                    }
                    featureData.makePageList(list[4]);
                    featureData.makeChartList(list[5]);
                    featureData.setMinValue(list[6]);
                    featureData.setMaxValue(list[7]);
                    featureData.setDefaultValue(list[8]);
                    featureData.setOverheadRanking(list[9]);
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void readTemplateFile() {
        block9: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "template");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    String[] list = content.split("\\|", -1);
                    if (list == null) continue;
                    int index = Integer.parseInt(list[0]);
                    Template template = Template.getTemplate(index);
                    if (template == null) {
                        Logger.error((Object)("unknown template : " + list[0] + ", " + list[1]));
                        continue;
                    }
                    TemplateData templateDate = template.getData();
                    int i = 2;
                    while (i < list.length) {
                        templateDate.makeFeatureList(list[i]);
                        ++i;
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block9;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void readSettingFile() {
        block26: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "setting");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    String[] valueList;
                    int i;
                    String[] list = content.split("\\|");
                    if (list[0].equals("Version")) {
                        this.version = Double.parseDouble(list[1]);
                        continue;
                    }
                    if (list[0].equals("Log Level")) {
                        this.logLevel = Integer.parseInt(list[1]);
                        continue;
                    }
                    if (list[0].equals("Debug Print")) {
                        DebugLog.enableDebugPrint(list[1].equals("Y"));
                        continue;
                    }
                    if (list[0].equals("Available Target List")) {
                        i = 1;
                        while (i < list.length) {
                            if (this.targetListMap.get(list[i]) == null) {
                                this.targetListMap.put(list[i], new TargetData(list[i]));
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Selected Target")) {
                        this.selectedTarget = list[1];
                        this.initTarget = new String(list[1]);
                        continue;
                    }
                    if (list[0].equals("Default Feature List")) {
                        i = 1;
                        while (i < list.length) {
                            this.defaultFeatureList.add(Feature.getFeature(Integer.parseInt(list[i])));
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Total Overhead Range")) {
                        i = 1;
                        while (i < list.length) {
                            this.totalOverheadRange.add(Long.parseLong(list[i]));
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Options Selected Feature List")) continue;
                    if (list[0].equals("Selected Preferences")) {
                        i = 1;
                        while (i < list.length) {
                            valueList = list[i].split(":");
                            FlatPreferences selected = FlatPreferences.getFlatPreferences(Integer.parseInt(valueList[0]));
                            if (selected != null) {
                                if (valueList.length > 1) {
                                    selected.setValue(Integer.parseInt(valueList[1]));
                                }
                                this.optionsSelectedPreferenceList.add(selected);
                                this.initOptionsSelectedPreferenceList.add(selected);
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (list[0].equals("Platform Dynamic Analyzer")) {
                        i = 1;
                        while (i < list.length) {
                            valueList = list[i].split(":");
                            if (valueList.length > 0 && valueList[0].toLowerCase().equals("y")) {
                                this.isPlatformDA = true;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (this.targetListMap.get(list[0]) != null) {
                        this.getTarget(list[0]).makeDetailInformation(list);
                        continue;
                    }
                    Logger.warning((Object)("not available target : " + list[0]));
                }
            }
            catch (FileNotFoundException e) {
                this.parsingSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block26;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block26;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void writeSettingFile() {
        block7: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "setting");
            FileWriter fileWriter = null;
            BufferedWriter buffWriter = null;
            PrintWriter printWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(csv);
                    buffWriter = new BufferedWriter(fileWriter);
                    printWriter = new PrintWriter(buffWriter);
                    printWriter.println("Version|" + this.version);
                    printWriter.println("Log Level|" + this.logLevel);
                    printWriter.println("Debug Print|" + (DebugLog.isEnabled() ? "Y" : "N"));
                    if (this.isPlatformDA) {
                        printWriter.println("Platform Dynamic Analyzer|Y");
                    }
                    printWriter.println(this.writeTargetData());
                    printWriter.println("Selected Target|" + this.selectedTarget);
                    printWriter.println(this.writeDefaultFeatureList("Default Feature List"));
                    printWriter.println(this.writeCollection(this.totalOverheadRange, "Total Overhead Range"));
                    printWriter.println("Selected Preferences|" + this.writeOptionsSelectedPreferencesListData());
                    for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
                        TargetData target = entry.getValue();
                        target.writeSelectedData(printWriter);
                    }
                    printWriter.checkError();
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
                    break block7;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
        }
    }

    private String writeTargetData() {
        Set<String> targetNameList = this.targetListMap.keySet();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Available Target List");
        Iterator<String> iter = targetNameList.iterator();
        while (iter.hasNext()) {
            buffer.append("|" + iter.next());
        }
        return buffer.toString();
    }

    private String writeDefaultFeatureList(String key) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(key) + "|");
        int i = 0;
        while (i < this.defaultFeatureList.size()) {
            if (i < this.defaultFeatureList.size() - 1) {
                buffer.append(String.valueOf(this.defaultFeatureList.get(i).getIndex()) + "|");
            } else {
                buffer.append(this.defaultFeatureList.get(i).getIndex());
            }
            ++i;
        }
        return buffer.toString();
    }

    private <T> String writeCollection(Collection<T> collection, String key) {
        StringBuffer subBuffer = new StringBuffer();
        for (T element : collection) {
            if (subBuffer.length() > 0) {
                subBuffer.append("|");
            }
            subBuffer.append(element.toString());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(key);
        buffer.append("|");
        buffer.append(subBuffer);
        return buffer.toString();
    }

    private String writeOptionsSelectedPreferencesListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.optionsSelectedPreferenceList.size()) {
            FlatPreferences feature = this.optionsSelectedPreferenceList.get(i);
            buffer.append(feature.getIndex());
            if (feature.getValue() >= 0) {
                buffer.append(String.valueOf(":" + feature.getValue()));
            }
            if (i < this.optionsSelectedPreferenceList.size() - 1) {
                buffer.append("|");
            }
            ++i;
        }
        return buffer.toString();
    }

    @Deprecated
    public int getSelectedOverheadLevel(String targetName) {
        return 0;
    }

    @Deprecated
    public Set<String> getOptionsSelectedFeatureChartSet() {
        return new HashSet<String>();
    }

    public Set<String> getSelectedChartSet(String targetName) {
        TargetData target = this.getTarget(targetName);
        if (target != null) {
            HashSet<String> selectedChartSet = new HashSet<String>();
            List<FlatFeature> featureSet = target.getSelectedFlatFeatures();
            for (FlatFeature feature : featureSet) {
                if (feature.getChart() == null) continue;
                selectedChartSet.add(feature.getChart());
            }
            return selectedChartSet;
        }
        Logger.warning((Object)("Does not exist targetName : " + targetName));
        return null;
    }

    public String getSelectedTarget() {
        return this.selectedTarget;
    }

    public void setSelectedTarget(String selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public Map<String, TargetData> getTargetListMap() {
        return Collections.unmodifiableMap(this.targetListMap);
    }

    public TargetData getTarget(String targetName) {
        if (targetName == null) {
            return this.targetListMap.get(this.selectedTarget);
        }
        return this.targetListMap.get(targetName);
    }

    public TargetData getConnectedTargetOrNull() {
        TargetData tData;
        String profileName;
        DeviceInfo currentDevice = Global.getCurrentDeviceInfo();
        if (currentDevice != null && (profileName = currentDevice.getPlatformName()) != null && !profileName.isEmpty() && (tData = this.targetListMap.get(profileName)) != null) {
            return tData;
        }
        return null;
    }

    public boolean checkConnectedTargetType() {
        TargetData connected = this.getConnectedTargetOrNull();
        if (connected == null) {
            return true;
        }
        return connected.getTargetName().equals(this.getSelectedTarget());
    }

    public TargetData getConnectedTargetOrSelected() {
        TargetData tData = this.getConnectedTargetOrNull();
        if (tData != null) {
            return tData;
        }
        return this.targetListMap.get(this.selectedTarget);
    }

    @Deprecated
    public List<Feature> getDefaultFeatureList() {
        return Collections.unmodifiableList(this.defaultFeatureList);
    }

    @Deprecated
    public List<FeatureValueData> getOptionsSelectedFeatureList() {
        return new ArrayList<FeatureValueData>();
    }

    public List<FlatPreferences> getOptionsSelectedPreferencesList() {
        return Collections.unmodifiableList(this.optionsSelectedPreferenceList);
    }

    @Deprecated
    public void addOptionsSelectedFeature(Feature feature, int featureValue) {
    }

    public void addOptionsSelectedPreference(FlatPreferences feature, int featureValue) {
        int index = this.getFlatPreferences(this.optionsSelectedPreferenceList, feature);
        if (index == -1) {
            FlatPreferences featureData = FlatPreferences.getFlatPreferences(feature.getIndex());
            featureData.setValue(featureValue);
            this.optionsSelectedPreferenceList.add(featureData);
        } else {
            this.optionsSelectedPreferenceList.get(index).setValue(featureValue);
        }
    }

    @Deprecated
    public void deleteOptionsSelectedFeature(Feature feature) {
    }

    public void deleteOptionsSelectedPreference(FlatPreferences feature) {
        int i = 0;
        while (i < this.optionsSelectedPreferenceList.size()) {
            if (this.optionsSelectedPreferenceList.get(i) == feature) {
                this.optionsSelectedPreferenceList.remove(i);
                break;
            }
            ++i;
        }
    }

    @Deprecated
    public boolean isOptionsSelectedFeature(Feature feature) {
        return false;
    }

    public boolean isOptionsSelectedPrefereces(FlatPreferences feature) {
        int index = this.getFlatPreferences(this.optionsSelectedPreferenceList, feature);
        return index != -1;
    }

    public boolean isFlatFeatureSelected(FlatFeature feature) {
        return this.getSelectedFlatFeatureSet().contains((Object)feature);
    }

    @Deprecated
    public int getOptionsFeatureValue(Feature feature) {
        return -1;
    }

    public int getOptionsPreferencesValue(FlatPreferences feature) {
        int value = 0;
        int index = this.getFlatPreferences(this.optionsSelectedPreferenceList, feature);
        value = index != -1 ? this.optionsSelectedPreferenceList.get(index).getValue() : FlatPreferences.getFlatPreferences(feature.getIndex()).getDefaultValue();
        return value;
    }

    @Deprecated
    public int getOptionsFeaturInitValue(Feature feature) {
        return -1;
    }

    private int getFlatPreferences(List<FlatPreferences> featureList, FlatPreferences feature) {
        if (featureList == null || feature == null) {
            return -1;
        }
        int i = 0;
        while (i < featureList.size()) {
            if (featureList.get(i).getIndex() == feature.getIndex()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<Long> getTotalOverheadRange() {
        return Collections.unmodifiableList(this.totalOverheadRange);
    }

    public int getTotalOverheadRangeCount() {
        return this.totalOverheadRange.size() + 1;
    }

    public Set<String> getSelectedPageList(String targetName) {
        HashSet<String> selectedPageList = new HashSet<String>();
        TargetData target = this.getTarget(targetName);
        if (target != null) {
            List<FlatFeature> features = target.getSelectedFlatFeatures();
            for (FlatFeature feature : features) {
                if (feature.getPage() == null) continue;
                selectedPageList.add(feature.getPage());
            }
        } else {
            Logger.debug((Object)("Does not exist targetName : " + targetName));
        }
        return selectedPageList;
    }

    public boolean changedFeatures() {
        if (!this.initTarget.equals(this.selectedTarget)) {
            return true;
        }
        if (this.optionsSelectedPreferenceList.size() != this.initOptionsSelectedPreferenceList.size()) {
            return true;
        }
        int i = 0;
        while (i < this.optionsSelectedPreferenceList.size()) {
            FlatPreferences preference = this.optionsSelectedPreferenceList.get(i);
            int initPreferenceIndex = this.getFlatPreferences(this.initOptionsSelectedPreferenceList, preference);
            if (initPreferenceIndex < 0) {
                return true;
            }
            if (preference.getValue() != this.initOptionsSelectedPreferenceList.get(initPreferenceIndex).getValue()) {
                return true;
            }
            ++i;
        }
        for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
            TargetData target = entry.getValue();
            if (!target.changedFlatFeatures()) continue;
            return true;
        }
        return false;
    }

    public void applySettingData() {
        this.writeSettingFile();
        this.updateSettingData();
        this.setNewSetting(true);
    }

    private void updateSettingData() {
        this.initTarget = this.selectedTarget;
        for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
            TargetData target = entry.getValue();
            target.applySettingData();
        }
    }

    public void revertSettingData() {
        this.selectedTarget = this.initTarget;
        for (Map.Entry<String, TargetData> entry : this.targetListMap.entrySet()) {
            TargetData target = entry.getValue();
            target.revertSettingData();
        }
        this.setNewSetting(false);
    }

    public void writeAvailableChartList(String targetName, List<String> availableChartList) {
        TargetData target = this.getTarget(targetName);
        if (target != null) {
            target.setAvailableChartList(availableChartList);
        } else {
            Logger.debug((Object)("Does not exist targetName : " + targetName));
        }
        this.writeSettingFile();
    }

    @Deprecated
    public Set<Feature> getSelectedFeatureSet() {
        return new HashSet<Feature>();
    }

    public Set<FlatPreferences> getSelectedPreferenceSet() {
        List<FlatFeature> featureSet = this.getConnectedTargetOrSelected().getSelectedFlatFeatures();
        HashSet<FlatPreferences> selectedFeatures = new HashSet<FlatPreferences>();
        selectedFeatures.addAll(this.optionsSelectedPreferenceList);
        if (!this.isOptionsSelectedPrefereces(FlatPreferences.FUNCTION_PROFILING)) {
            selectedFeatures.add(FlatPreferences.FUNCTION_PROFILING);
        }
        if (!this.isOptionsSelectedPrefereces(FlatPreferences.APP_STARTUP)) {
            selectedFeatures.add(FlatPreferences.APP_STARTUP);
        }
        if (!this.isOptionsSelectedPrefereces(FlatPreferences.SYSTEM_ALL_PROCESSES)) {
            selectedFeatures.add(FlatPreferences.SYSTEM_ALL_PROCESSES);
        }
        if (!featureSet.contains((Object)FlatFeature.PROCESS_MEMORY) && !this.isOptionsSelectedPrefereces(FlatPreferences.PROCESS_MEMORY)) {
            selectedFeatures.add(FlatPreferences.PROCESS_MEMORY);
        }
        if (!this.isOptionsSelectedPrefereces(FlatPreferences.FUNCTION_SAMPLING_RATE)) {
            selectedFeatures.add(FlatPreferences.FUNCTION_SAMPLING_RATE);
        }
        return selectedFeatures;
    }

    public Set<FlatFeature> getSelectedFlatFeatureSet() {
        TargetData target = this.getTarget(null);
        HashSet<FlatFeature> buf = new HashSet<FlatFeature>();
        buf.addAll(target.getSelectedFlatFeatures());
        return buf;
    }

    public boolean isPlatformDA() {
        return this.isPlatformDA;
    }

    @Deprecated
    public String getPlatform() {
        return null;
    }

    public boolean isNewSetting() {
        return this.isNewSetting;
    }

    public void setNewSetting(boolean isNewSetting) {
        this.isNewSetting = isNewSetting;
    }

    public void enableScreenshotFeature(boolean enable) {
        BaseView baseView;
        TargetData target = this.getConnectedTargetOrSelected();
        Set<String> targetChartList = this.getSelectedChartSet(target.getTargetName());
        if (!targetChartList.contains(TimelineChartLabels.SCREENSHOT_CHART_TITLE) && (baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID)).getTopComposite() instanceof TimelinePage) {
            TimelinePage timelinePage = (TimelinePage)baseView.getTopComposite();
            timelinePage.getTimelineChartView().showScreenshotChart(enable);
            if (enable) {
                target.addSelectedFlatFeature(FlatFeature.SCREENSHOT.getName());
            } else {
                target.removeSelectedFlatFeature(FlatFeature.SCREENSHOT.getName());
            }
        }
    }
}

