/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common;

import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chart.DAScreenshotChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAUIEventChartPlot;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class TimelineChartMouseTrackAdapter
extends MouseTrackAdapter {
    private DATimeline timeline;

    public TimelineChartMouseTrackAdapter(DATimeline timeline) {
        this.timeline = timeline;
    }

    public void mouseEnter(MouseEvent e) {
        double newYPosRatio;
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotTooltip tooltip = plot.getTooltip();
        if (tooltip == null) {
            return;
        }
        double oldYPosRatio = tooltip.getYPosRatio();
        if (Double.compare(oldYPosRatio, newYPosRatio = (double)e.y / (double)((Canvas)e.widget).getSize().y) != 0) {
            tooltip.setYPosRatio(newYPosRatio);
        }
        tooltip.setStartVal(this.getTooltipStartX(plot, chart.getSeriesList(), e.x, newYPosRatio));
        tooltip.setTooltip(true);
    }

    public void mouseExit(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotTooltip tooltip = plot.getTooltip();
        if (tooltip == null) {
            return;
        }
        tooltip.setTooltip(false);
        if (plot instanceof DAScreenshotChartPlot) {
            ((DAScreenshotChartPlot)plot).setHighlightedImageIndex(-1);
            chart.redraw();
        } else if (plot instanceof DAUIEventChartPlot) {
            ((DAUIEventChartPlot)plot).setHighlightedEventIndexX(-1);
        }
        this.timeline.setDrawDetailTime(false);
        this.timeline.redraw();
    }

    private double getTooltipStartX(DAChartPlot plot, List<DAChartSeries> seriesList, int x, double yPosRatio) {
        double ret = -1.0;
        int i = 0;
        while (i < seriesList.size()) {
            DAChartSeries series;
            int index;
            if (plot instanceof DAUIEventChartPlot && ((i = (int)((double)seriesList.size() * yPosRatio)) < 0 || i > 4)) {
                Logger.debug((Object)(String.valueOf(yPosRatio) + " " + i));
            }
            if (-1 == (index = (series = seriesList.get(i)).getPrevIndexByXvalue(plot.getXFromXPixel(x)))) {
                if (plot instanceof DAUIEventChartPlot) {
                    break;
                }
            } else {
                double startVal = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getX();
                if (ret < startVal) {
                    ret = startVal;
                }
                if (plot instanceof DAUIEventChartPlot) break;
            }
            ++i;
        }
        return ret;
    }
}

