/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.ui.common.PopupRangeAnalysisMenuItemOnChartListener;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public abstract class GLChart {
    protected DAChart chart;
    protected int chartType;
    protected int chartStyle = 0;
    protected int probeType;
    protected String chartName;
    protected Image chartIcon;
    protected DAPopupMenu popupMenu;

    public abstract void parseLogPackage(LogPackage var1);

    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard, boolean enablePopupMenu) {
        DAChartBoardItem item = new DAChartBoardItem(chartBoard, this.chartName, this.chartIcon, this.chartStyle);
        this.chart = item.getChart();
        this.setChartStyle();
        if (enablePopupMenu) {
            this.popupMenu = new DAPopupMenu((Composite)this.chart);
            this.initPopupMenu(chartBoard, this.popupMenu);
        }
        return item;
    }

    protected void initPopupMenu(DAChartBoard chartBoard, DAPopupMenu popupMenu) {
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupRangeAnalysisMenuItemOnChartListener(analysisItem, chartBoard, this.chart));
    }

    public void clear() {
        List seriesList = this.chart.getSeriesList();
        for (DAChartSeries series : seriesList) {
            series.clear();
        }
    }

    public List<DAChartSeries> getBaseDASeriesList() {
        return this.chart.getSeriesList();
    }

    protected void setChartStyle() {
        DAChartPlot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.SEMI_AUTO);
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
    }

    public void update() {
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.redraw();
        }
    }

    public int getChartType() {
        return this.chartType;
    }

    public String getChartName() {
        return this.chartName;
    }

    public Image getChartIcon() {
        return this.chartIcon;
    }

    public int getProbeType() {
        return this.probeType;
    }

    public DAPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

