/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.state;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.opengl.table.state.GLStatisticsTable;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedPopupMenu;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLStatisticsTableView
extends DAAdvancedViewComposite {
    public static final int API_NAME_TABLE_INDEX = 0;
    public static final int TABLE_RATE_TABLE_INDEX = 1;
    public static final int COUNT_TABLE_INDEX = 2;
    public static final int API_TYPE_TABLE_INDEX = 3;
    GLStatisticsTable tableComp = null;
    private int[] columnSizes = new int[]{150, 80, 80, 200};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true};
    private int[] columnAlignment = new int[]{16384, 0x1000000, 0x1000000, 0x1000000};
    private String[] columnNames = new String[]{GLPageLabels.GL_STATISTICS_VIEW_API_NAME, GLPageLabels.GL_STATISTICS_VIEW_TIME_RATE, GLPageLabels.GL_STATISTICS_VIEW_COUNT, GLPageLabels.GL_STATISTICS_VIEW_API_TYPE};
    int[] sortTypes = new int[]{2, 1, 1, 2};

    public GLStatisticsTableView(Composite parent, int style) {
        super(parent, style, false, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(GLPageLabels.GL_STATISTICS_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new GLStatisticsTable(contents, 0, 68354);
        this.tableComp.setTableName(GLPageLabels.GL_STATISTICS_TITLE);
        this.tableComp.setComparator(new DefaultTableComparator());
        this.tableComp.setSortTypes(this.sortTypes);
        this.tableComp.setColumnAlignment(this.columnAlignment);
        this.tableComp.setColumns(this.columnNames);
        this.tableComp.setColumnSize(this.columnSizes);
        this.tableComp.setColumnVisibility(this.columnVisibility);
        this.tableComp.setTableToolTipEnable(false);
        contents.addControlListener((ControlListener)new TableColumnSizePackListener(this.tableComp, this.columnSizes));
        this.setTable(this.tableComp);
        this.disableAdvancedMenuItem(DAAdvancedPopupMenu.ADVANCED_MENU_ITEM.FILTER.index);
    }

    public void updateView() {
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        if (this.tableComp == null) {
            return;
        }
        this.tableComp.updateTable();
    }

    public void updateView(DAViewData vdata) {
        if (!(vdata instanceof GLSelectionData)) {
            return;
        }
        String id = ((GLSelectionData)vdata).getViewID();
        if (!id.endsWith(this.ID)) {
            this.tableComp.removeSelection();
        }
        this.tableComp.updateTable();
    }

    public void clear() {
        this.tableComp.clear();
    }

    public Control getControl() {
        return this.tableComp;
    }
}

