/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.leaks;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FreeDataDBTable
extends DBTable {
    private static final String TABLENAME = "FREE_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FreeDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.MESSAGE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FREE_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.setIndexColumn(COLUMN.PID.index);
        this.setIndexColumn(COLUMN.FREE_TIME.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(2, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(3, (Integer)rowData.get(COLUMN.MESSAGE_ID.index));
                prep.setLong(4, (Long)rowData.get(COLUMN.FREE_TIME.index));
                prep.setLong(5, (Long)rowData.get(COLUMN.ALLOCATED_ADDRESS.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        MESSAGE_ID(2, "MESSAGE_ID"),
        FREE_TIME(3, "FREE_TIME"),
        ALLOCATED_ADDRESS(4, "ALLOCATED_ADDRESS");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

