/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.leaks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.listeners.SummaryMouseDoubleClickListener;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.swap.model.data.LogDataFactory;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.range.RangePage;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.summary.leaks.CurrentLeakData;
import org.tizen.dynamicanalyzer.ui.summary.leaks.MemoryAllocationDataDBTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class LeakTable
extends DATreeComposite {
    private boolean isRange = false;

    public LeakTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setContextMenu(1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = LeakTable.this.table.getSelection();
                DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
                long time = (Long)dataFormat.getData().get(4);
                String id = SummaryPage.leakViewID;
                if (LeakTable.this.isRange) {
                    id = RangePage.leakViewID;
                }
                DASelectionData selData = new DASelectionData(id, time, 0L, items, (Control)LeakTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new SummaryMouseDoubleClickListener(SummaryPage.leakViewID));
    }

    public void setRangeTable(boolean isRange) {
        this.isRange = isRange;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        Map<Integer, CurrentLeakData> leaks = null;
        List<List<Object>> leakDataList = null;
        List<FilterProperty> filterList = this.getFilterList();
        if (this.isRange) {
            leakDataList = SummaryDataManager.getInstance().getLeakDataMaker().getLeakDataForRange();
        } else {
            leaks = AnalyzerManager.getNewLeakDetector().getLeakHash();
            if (leaks == null || leaks.isEmpty()) {
                return output;
            }
            ArrayList<Long> leakSeqNumList = new ArrayList<Long>();
            for (Integer key : leaks.keySet()) {
                leakSeqNumList.add(leaks.get(key).getSequenceNumber());
            }
            if (!filterList.isEmpty()) {
                List<String> whereQueryList = this.convertFilterProperty2Query(filterList);
                leakDataList = SummaryDataManager.getInstance().getLeakDataMaker().getLeakDataWithSeq(leakSeqNumList, whereQueryList);
            } else {
                leakDataList = SummaryDataManager.getInstance().getLeakDataMaker().getLeakDataWithSeq(leakSeqNumList, null);
            }
        }
        if (leakDataList == null) {
            return output;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        int size = leakDataList.size();
        int i = 0;
        while (i < size) {
            TreeInput leakInput;
            List<Object> iLeakData = leakDataList.get(i);
            if ((this.isRange || selectedPid == 0 || selectedPid == (Integer)iLeakData.get(MemoryAllocationDataDBTable.COLUMN.PID.index)) && (leakInput = this.makeTreeInputForLeakData(iLeakData, i, filterList)) != null) {
                output.add(leakInput);
            }
            ++i;
        }
        return output;
    }

    private TreeInput makeTreeInputForLeakData(List<Object> leakData, int index, List<FilterProperty> filterList) {
        TreeInput output = null;
        if (leakData == null) {
            Logger.error((Object)"very strange case !!");
            return null;
        }
        Long seq = (Long)leakData.get(MemoryAllocationDataDBTable.COLUMN.SEQUENCE_NUMBER.index);
        int apiId = (Integer)leakData.get(MemoryAllocationDataDBTable.COLUMN.API_ID.index);
        String apiName = Global.getFunctionName(apiId);
        int pid = (Integer)leakData.get(MemoryAllocationDataDBTable.COLUMN.PID.index);
        String pidString = Integer.toString(pid);
        int id = (Integer)leakData.get(MemoryAllocationDataDBTable.COLUMN.MESSAGE_ID.index);
        String type = LogDataFactory.getLogFormatName(id);
        long time = (Long)leakData.get(MemoryAllocationDataDBTable.COLUMN.ALLOCATED_TIME.index);
        String timeFormat = null;
        try {
            timeFormat = Formatter.toTimeFormat(time);
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            timeFormat = Long.toString(time);
        }
        String args = (String)leakData.get(MemoryAllocationDataDBTable.COLUMN.ARGUMENT.index);
        String retValue = (String)leakData.get(MemoryAllocationDataDBTable.COLUMN.RETURN_VALUE.index);
        String libName = (String)leakData.get(MemoryAllocationDataDBTable.COLUMN.CALLER_LIBRARY_NAME.index);
        if (libName == null || libName.isEmpty()) {
            libName = "unknown";
        }
        int i = 0;
        while (i < filterList.size()) {
            switch (filterList.get(i).getColumnIndex()) {
                case 1: {
                    if (apiName.toLowerCase().contains(filterList.get(i).getKeyWord().toLowerCase())) break;
                    return output;
                }
                case 2: {
                    if (!this.isRange || pidString.contains(filterList.get(i).getKeyWord())) break;
                    return output;
                }
                case 3: {
                    if (type.toLowerCase().contains(filterList.get(i).getKeyWord().toLowerCase())) break;
                    return output;
                }
                case 4: {
                    if (timeFormat.toLowerCase().contains(filterList.get(i).getKeyWord().toLowerCase())) break;
                    return output;
                }
                case 5: {
                    if (!this.isRange || args.toLowerCase().contains(filterList.get(i).getKeyWord().toLowerCase())) break;
                    return output;
                }
                case 6: {
                    if (!this.isRange || retValue.toLowerCase().contains(filterList.get(i).getKeyWord().toLowerCase())) break;
                    return output;
                }
                case 7: {
                    if (!this.isRange || libName.toLowerCase().contains(filterList.get(i).getKeyWord().toLowerCase())) break;
                    return output;
                }
            }
            ++i;
        }
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        text.add(Long.toString(seq));
        data.add(seq);
        text.add(apiName);
        data.add(apiName);
        text.add(pidString);
        data.add(pid);
        text.add(type);
        data.add(type);
        text.add(timeFormat);
        data.add(time);
        text.add(args);
        data.add(args);
        text.add(retValue);
        data.add(retValue);
        text.add(libName);
        data.add(libName);
        data.add((Long)leakData.get(MemoryAllocationDataDBTable.COLUMN.ALLOCATED_ADDRESS.index));
        long callerPcAddr = (Long)leakData.get(MemoryAllocationDataDBTable.COLUMN.CALLER_PC_ADDRESS.index);
        data.add(callerPcAddr);
        ProbeCommonData probeData = new ProbeCommonData();
        probeData.setSeq(seq);
        probeData.setApiName(apiName);
        probeData.setMsgID(id);
        probeData.setPid(pid);
        probeData.setTime(time);
        probeData.setArgs(args);
        probeData.setReturn(retValue);
        probeData.setCallerAddress(callerPcAddr);
        probeData.setLibName(libName);
        DATableDataFormat tableData = new DATableDataFormat(index);
        tableData.setType(4);
        tableData.getData().addAll(data);
        tableData.setObject(apiName);
        tableData.setLogData(probeData);
        output = new TreeInput();
        output.setText(text);
        output.setData(tableData);
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            long leakTime = time;
            long startTime = RangeDataManager.getInstance().getAnalysisStartTime();
            long endTime = RangeDataManager.getInstance().getAnalysisEndTime();
            if (leakTime >= startTime && leakTime <= endTime) {
                output.setInRange(true);
            }
        }
        return output;
    }

    private List<FilterProperty> getFilterList() {
        List<FilterProperty> filterList = this.getFilterPropertyList();
        if (!filterList.isEmpty()) {
            ArrayList<FilterProperty> filterListRep = new ArrayList<FilterProperty>();
            filterListRep.addAll(filterList);
            return filterListRep;
        }
        return filterList;
    }

    @Override
    protected List<String> convertFilterProperty2Query(List<FilterProperty> filterList) {
        ArrayList<String> queries = new ArrayList<String>();
        Iterator<FilterProperty> iter = filterList.iterator();
        while (iter.hasNext()) {
            FilterProperty prop = iter.next();
            String queryPrefix = this.getFilteredColumnName(prop.getColumnIndex());
            if (queryPrefix == null) continue;
            queries.add(this.makeFilterWhereClause(queryPrefix, prop.getKeyWord()));
            iter.remove();
        }
        return queries;
    }

    @Override
    protected String getFilteredColumnName(int index) {
        String columnName = null;
        switch (index) {
            case 2: {
                columnName = MemoryAllocationDataDBTable.COLUMN.PID.name;
                break;
            }
            case 5: {
                columnName = this.addLowerOperation(MemoryAllocationDataDBTable.COLUMN.ARGUMENT.name);
                break;
            }
            case 6: {
                columnName = this.addLowerOperation(MemoryAllocationDataDBTable.COLUMN.RETURN_VALUE.name);
                break;
            }
            case 7: {
                columnName = this.addLowerOperation(MemoryAllocationDataDBTable.COLUMN.CALLER_LIBRARY_NAME.name);
                break;
            }
        }
        return columnName;
    }
}

