/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.SummaryLabels;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.range.RangePage;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfilingData;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.ui.widgets.table.TreeDataComparator;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class WebProfilingTable
extends DATreeComposite {
    private String[] columnNames = new String[]{SummaryLabels.FUNCTION_USER_PROFILING_VIEW_FUNCTION_NAME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_EXCLUSIVE_ELAPSED_TIME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_INCLUSIVE_ELAPSED_TIME, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_CALL_COUNT, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_FILE, SummaryLabels.FUNCTION_USER_PROFILING_VIEW_LINE_NUMBER};
    private int[] columnSizes = new int[]{260, 100, 100, 80, 350, 80};
    private int[] columnAlignment = new int[]{16384, 131072, 131072, 131072, 16384, 16384};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true, true};
    private int[] sortTypes = new int[]{1, 1, 1, 1, 2, 1};
    private boolean isRange = false;

    public WebProfilingTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setComparator(new TreeDataComparator());
        this.comparator.setType(1);
        this.comparator.setColumn(0);
        this.comparator.setDirection(false);
        this.setTree(true);
        this.setSortTypes(this.sortTypes);
        this.setColumnAlignment(this.columnAlignment);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.setTableToolTipEnable(false);
        this.setTableName(SummaryLabels.FUNCTION_USER_PROFILING_VIEW_TITLE);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, this.columnSizes));
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = WebProfilingTable.this.table.getSelection();
                String id = SummaryPage.profilingViewID;
                if (WebProfilingTable.this.isRange) {
                    id = RangePage.profilingViewID;
                }
                DASelectionData selData = new DASelectionData(id, 0L, 0L, items, (Control)WebProfilingTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] items = WebProfilingTable.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                GridItem item = items[0];
                if (item.isExpanded()) {
                    WebProfilingTable.this.setExpand(item, false);
                } else {
                    WebProfilingTable.this.setExpand(item, true);
                }
                WebProfilingTable.this.updateTree();
            }
        });
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        List<Integer> pids = this.getPidsOfProfileDataMakerMap();
        int i = 0;
        while (i < pids.size()) {
            WebProfileDataMaker profiler;
            WebProfilingData application;
            int pid = pids.get(i);
            if ((selectedPid == 0 || selectedPid == pid) && (application = (profiler = this.getProfileDataMakerByPid(pid)).getAppBin()) != null) {
                TreeInput applicationInput = this.makeInput(application, pid);
                List<WebProfilingData> children = profiler.getChildList(application.getChildrenWebProfilingDataID());
                this.makeChildTree(children, applicationInput, application.getFunctionName(), pid);
                output.add(applicationInput);
            }
            ++i;
        }
        return output;
    }

    private TreeInput makeInput(WebProfilingData input, int pid) {
        DATableDataFormat tableData = new DATableDataFormat(input.getProfilingDataID());
        if (input.getFunctionName().equals(FunctionUsageProfiler.APPLICATION)) {
            tableData.setObject(String.valueOf(input.getFunctionName()) + " " + "(" + "PID : " + pid + ")");
        } else {
            tableData.setObject(input.getFunctionName());
        }
        ArrayList<String> contentText = new ArrayList<String>();
        ArrayList<Object> contentData = new ArrayList<Object>();
        contentText.add(input.getFunctionName());
        contentData.add(new Integer(pid));
        if (0L == input.getExElapsedTime()) {
            contentText.add("-");
        } else {
            contentText.add(Formatter.toTimeFormat4(input.getExElapsedTime()));
        }
        contentData.add(new Long(input.getExElapsedTime()));
        if (0L == input.getInElapsedTime()) {
            contentText.add("-");
        } else {
            contentText.add(Formatter.toTimeFormat4(input.getInElapsedTime()));
        }
        contentData.add(new Long(input.getInElapsedTime()));
        if (input.getCallCount() == 0) {
            contentText.add("-");
        } else {
            contentText.add(Integer.toString(input.getCallCount()));
        }
        contentData.add(new Integer(input.getCallCount()));
        String file = input.getFunctionURL();
        if (file == null || file.isEmpty()) {
            contentText.add("-");
        } else {
            contentText.add(file);
        }
        contentData.add(file);
        if (input.getFunctionLineNumber() == 0) {
            contentText.add("-");
        } else {
            contentText.add(Integer.toString(input.getFunctionLineNumber()));
        }
        contentData.add(new Integer(input.getFunctionLineNumber()));
        TreeInput output = new TreeInput();
        output.setText(contentText);
        tableData.getData().addAll(contentData);
        output.setData(tableData);
        if (input.getParentWebProfilingData() != null) {
            output.setParent(input.getParentWebProfilingData().getFunctionName());
        }
        return output;
    }

    public void makeChildTree(List<WebProfilingData> children, TreeInput parent, String parentName, int pid) {
        WebProfileDataMaker profiler = this.getProfileDataMakerByPid(pid);
        int i = 0;
        while (i < children.size()) {
            WebProfilingData data = children.get(i);
            TreeInput input = this.makeInput(data, pid);
            List<WebProfilingData> list = profiler.getChildList(data.getChildrenWebProfilingDataID());
            this.makeChildTree(list, input, data.getFunctionName(), pid);
            parent.getChildren().add(input);
            input.setParent(parentName);
            ++i;
        }
    }

    private List<Integer> getPidsOfProfileDataMakerMap() {
        if (this.isRange) {
            return RangeDataManager.getInstance().getPidsOfWebProfileDataMakerMap();
        }
        return FunctionUsageProfiler.getInstance().getPidsOfWebProfileDataMakerMap();
    }

    private WebProfileDataMaker getProfileDataMakerByPid(int pid) {
        if (this.isRange) {
            return RangeDataManager.getInstance().getWebProfileDataMakerByPid(pid);
        }
        return FunctionUsageProfiler.getInstance().getWebProfileDataMakerByPid(pid);
    }

    public void setRangeTable(boolean isRange) {
        this.isRange = isRange;
    }
}

