/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class SaveAsDialog
extends DAMessageBox {
    private final int WIDTH = 446;
    private final int HEIGHT = 167;
    private DATextBox textBox = null;
    private String saveFileName = null;
    private DAButton okButton = null;
    private DAButton cancelButton = null;
    private Label info = null;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SaveAsDialog.this.saveFileName = SaveAsDialog.this.textBox.getText();
            if (SaveAsDialog.this.saveFileName.length() > 255) {
                SaveAsDialog.this.saveFileName = SaveAsDialog.this.saveFileName.substring(0, 255);
            }
            SaveAsDialog.this.setResult(1);
            SaveAsDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SaveAsDialog.this.shell.dispose();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            SaveAsDialog.this.checkFileNameValidation();
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public SaveAsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean run() {
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 446) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 167) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(446, 167);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(446, 167);
        this.shell.setText(AnalyzerLabels.SAVE_TRACE_TITLE);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        Label label = new Label((Composite)this.shell, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 12);
        data.height = 15;
        data.width = 150;
        label.setLayoutData((Object)data);
        label.setForeground(ColorResources.BLACK);
        label.setText(AnalyzerLabels.SAVE_TRACE_DLG_SAVE_FILE_NAME);
        label.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.textBox = new DATextBox((Composite)this.shell, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)label, 10);
        data.left = new FormAttachment(0, 9);
        data.height = 20;
        data.width = 410;
        this.textBox.setLayoutData((Object)data);
        this.textBox.setBackground(ColorResources.VIEW_BG_COLOR);
        this.textBox.getControl().addKeyListener(this.keyListener);
        this.info = new Label((Composite)this.shell, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment((Control)this.textBox.getControl(), 5);
        data.left = new FormAttachment(0, 9);
        data.height = 20;
        data.width = 410;
        this.info.setLayoutData((Object)data);
        this.info.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.info.setForeground(ColorResources.RED);
        this.info.setFont(FontResources.COMBO);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setLayout((Layout)new FormLayout());
        buttonComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        FormData compData = new FormData();
        compData.top = new FormAttachment(100, -50);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        this.okButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, -90);
        data.height = 24;
        data.width = 86;
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addClickListener(this.okButtonListener);
        this.cancelButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(50, 4);
        data.height = 24;
        data.width = 86;
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.saveFileName = this.getDefaultSaveFileName();
        if (this.saveFileName == null) {
            Logger.debug((Object)"save file name is null");
            return false;
        }
        this.textBox.setText(this.saveFileName);
        String textString = this.textBox.getText();
        this.textBox.getControl().setSelection(0, textString.length());
        this.checkFileNameValidation();
        return true;
    }

    public String getSaveFileName() {
        return this.saveFileName;
    }

    private String getDefaultSaveFileName() {
        Project project = Global.getProject();
        String sourcePath = project.getSavePath();
        String[] splitSourcePath = null;
        if (CommonUtil.isWin()) {
            splitSourcePath = sourcePath.split("\\\\");
        } else if (CommonUtil.isMac()) {
            splitSourcePath = sourcePath.split("\\/");
        } else if (CommonUtil.isLinux()) {
            splitSourcePath = sourcePath.split("\\/");
        } else {
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.OS_WARNING);
            return null;
        }
        if (splitSourcePath == null) {
            return null;
        }
        String saveFileName = splitSourcePath[splitSourcePath.length - 1];
        if (saveFileName == null || saveFileName.isEmpty()) {
            return null;
        }
        return saveFileName;
    }

    private void checkFileNameValidation() {
        String filename = this.textBox.getText();
        String errorMessage = null;
        errorMessage = filename == null || filename.contains("\\") || filename.contains("/") || filename.contains(":") || filename.contains("*") || filename.contains("\\?") || filename.contains("\"") || filename.contains("<") || filename.contains(">") || filename.contains("|") ? UserErrorWarningLabels.WARNING_FILENAME_INVALID_CHAR : (filename.isEmpty() ? UserErrorWarningLabels.WARNING_FILENAME_EMPTY : (filename.length() > 255 ? UserErrorWarningLabels.WARNING_FILENAME_TOO_LONG : null));
        if (errorMessage == null) {
            this.info.setText("");
            this.okButton.setButtonEnabled(true);
        } else {
            this.info.setText(errorMessage);
            this.okButton.setButtonEnabled(false);
        }
    }
}

