/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replay.data;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.RecordEventObject;
import org.tizen.dynamicanalyzer.swap.model.data.ReplayData;
import org.tizen.dynamicanalyzer.ui.toolbar.replay.data.ReplayDBManager;

public class ReplayDataManager
extends PageDataManager {
    private static ReplayDataManager instance = new ReplayDataManager();
    private ReplayDBManager replayDBManager = new ReplayDBManager();
    private int rid = 0;

    private ReplayDataManager() {
    }

    public static ReplayDataManager getInstance() {
        return instance;
    }

    public void clear() {
        this.rid = 0;
    }

    public ReplayDBManager getReplayDBManager() {
        return this.replayDBManager;
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs logs = pack.getLogs(7);
        if (logs != null && logs.getRawLogs().size() != 0) {
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            List<LogData> inputs = logs.getLogs();
            int dataRowSize = inputs.size();
            int i = 0;
            while (i < dataRowSize) {
                ReplayData replayData = (ReplayData)inputs.get(i);
                List<RecordEventObject> events = replayData.getRecordEvent();
                int ii = 0;
                while (ii < events.size()) {
                    RecordEventObject reo = events.get(ii);
                    ArrayList<Number> insertObject = new ArrayList<Number>();
                    insertObject.add(this.rid++);
                    insertObject.add(reo.getSeq());
                    insertObject.add(reo.getTime());
                    insertObject.add(reo.getEventTime().getSec());
                    insertObject.add(reo.getEventTime().getNano());
                    insertObject.add(reo.getEventId());
                    insertObject.add(reo.getEventType());
                    insertObject.add(reo.getEventCode());
                    insertObject.add(reo.getEventValue());
                    insertData.add(insertObject);
                    ++ii;
                }
                ++i;
            }
            this.replayDBManager.insertData(insertData);
        }
    }
}

