/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.project.ImageInfo;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.ReplayEditScreenshotTableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;

public class ReplayEditScreenshotTable
extends DATableComposite {
    private int savedX = 0;
    private int savedY = 0;

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        Set<Map.Entry<Long, ImageInfo>> images = Global.getImageInfoSet();
        ArrayList<String> text = new ArrayList<String>();
        text.add("noImage.jpg");
        text.add(Integer.toString(this.savedX));
        text.add(Integer.toString(this.savedY));
        TableInput tableInput = new TableInput();
        tableInput.setText(text);
        input.add(tableInput);
        if (images != null && !images.isEmpty()) {
            Iterator<Map.Entry<Long, ImageInfo>> iter = images.iterator();
            while (iter.hasNext()) {
                text = new ArrayList();
                ImageInfo image = iter.next().getValue();
                String path = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + image.getFileName();
                text.add(path);
                text.add(Integer.toString(this.savedX));
                text.add(Integer.toString(this.savedY));
                tableInput = new TableInput();
                tableInput.setText(text);
                input.add(tableInput);
            }
        }
        return input;
    }

    @Override
    public void updateTable() {
        this.table.removeAll();
        List<TableInput> input = this.makeTableInput();
        if (input == null) {
            return;
        }
        int size = input.size();
        int i = 0;
        while (i < size) {
            List<String> text = input.get(i).getText();
            GridItem gridItem = new GridItem(this.table, 0);
            int j = 0;
            while (j < text.size()) {
                gridItem.setText(j, text.get(j));
                ++j;
            }
            ++i;
        }
        this.table.update();
    }

    public ReplayEditScreenshotTable(Composite parent, int style, int x, int y) {
        super(parent, style);
        this.savedX = x;
        this.savedY = y;
    }

    @Override
    public void setColumns(String[] columnNames) {
        int size = columnNames.length;
        int i = 0;
        while (i < size) {
            GridColumn column = new GridColumn(this.table, 0);
            column.setText(columnNames[i]);
            column.setCellRenderer((GridCellRenderer)new ReplayEditScreenshotTableCellRenderer());
            column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
            column.pack();
            ++i;
        }
    }
}

