/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.DefaultCellRenderer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;

public class ReplayEditScreenshotTableCellRenderer
extends DefaultCellRenderer {
    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        this.paintBackground(gc, item);
        this.paintImage(gc, item);
        this.paintTableBoardLine(gc, item);
        this.paintSavedPoint(gc, item);
    }

    private void paintBackground(GC gc, GridItem item) {
        boolean drawBackground = true;
        if (item.getChecked() && this.getColumn() == 0) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_START);
            gc.setBackground(ColorResources.TABLE_CONTENTS_SELECTED_START);
        } else if (item.getParent().isEnabled()) {
            Color bg = item.getBackground();
            if (bg != null) {
                gc.setBackground(bg);
            } else {
                drawBackground = false;
            }
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        if (drawBackground && item.getChecked() && this.getColumn() == 0) {
            gc.fillGradientRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, true);
        } else if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y + 1, this.getBounds().width, this.getBounds().height);
        }
    }

    private void paintImage(GC gc, GridItem item) {
        String path = item.getText(0);
        Image img = null;
        if (path.equals("noImage.jpg")) {
            img = ImageResources.NO_IMAGE;
        } else {
            try {
                img = new Image((Device)Display.getDefault(), path);
            }
            catch (IllegalArgumentException e) {
                Logger.exception((Throwable)e);
                img = ImageResources.NO_IMAGE;
            }
            catch (SWTError err) {
                Logger.exception((Throwable)err);
                img = ImageResources.NO_IMAGE;
            }
            catch (SWTException sWTException) {
                Logger.debug((Object)("Wait for receiving image : " + path));
                img = ImageResources.NO_IMAGE;
            }
            if (img.isDisposed()) {
                Logger.debug((Object)"before set image : disposed");
            }
        }
        Rectangle bounds = img.getBounds();
        int width = 270;
        int height = 450;
        gc.drawImage(img, 0, 0, bounds.width, bounds.height, 0, 0, width, height);
    }

    private void paintTableBoardLine(GC gc, GridItem item) {
        if (!item.getParent().getLinesVisible()) {
            return;
        }
        gc.setForeground(ColorResources.TABLE_LINE);
        gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
    }

    private void paintSavedPoint(GC gc, GridItem item) {
        int savedX = Integer.parseInt(item.getText(1));
        int savedY = Integer.parseInt(item.getText(2));
        gc.setForeground(ColorResources.RED);
        gc.setLineWidth(1);
        gc.drawLine(0, savedY, this.getBounds().width, savedY);
        gc.drawLine(savedX, 0, savedX, this.getBounds().height);
        gc.setLineWidth(1);
    }
}

