/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.nl.ReplayEditLabels;
import org.tizen.dynamicanalyzer.ui.toolbar.replay.data.ReplayDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.RepalyEditSaveDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data.ReplayEditDataType;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;

public class ReplayEditSaveDataMaker
extends ReplayEditDataType {
    private static final long tmpSeqForEventLogFormatSize = 0L;
    private static final int EVENT_TYPE_TOUCH_DOUSE_UP_VALUE = -1;
    private int insertDBRid = 0;
    private int insertkeySequence = 1;
    private static ReplayEditSaveDataMaker instance = null;
    private List<List<String>> tableItemsList = null;

    public static ReplayEditSaveDataMaker getInstance() {
        if (instance == null) {
            instance = new ReplayEditSaveDataMaker();
        }
        return instance;
    }

    public void clean() {
        this.tableItemsList = null;
    }

    public void saveData() {
        Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
        RepalyEditSaveDialog dialog = new RepalyEditSaveDialog(shell);
        Object result = dialog.open();
        if (result == null) {
            return;
        }
        this.insertDB();
    }

    public void insertDB() {
        ReplayDataManager.getInstance().getReplayDBManager().deleteReplayTableItems();
        this.insertDBData();
    }

    private void cleanInsertData() {
        this.insertDBRid = 0;
        this.insertkeySequence = 1;
    }

    private void insertDBData() {
        this.cleanInsertData();
        int size = this.getTableItemsList().size();
        boolean isStartDragItem = false;
        int i = 0;
        while (i < size) {
            List<String> item = this.getTableItemsList().get(i);
            List<Object> dataList = new ArrayList();
            if (item.get(3).equals(ReplayEditLabels.CONTEXT_KEY) && !isStartDragItem) {
                dataList = this.makeDBKeyData(item);
            } else if (this.isTouchTableItem(item, isStartDragItem)) {
                dataList = this.makeDBTouchData(item);
            } else if (this.isDragStartTableItem(item, isStartDragItem)) {
                isStartDragItem = true;
                dataList = this.makeDBDragStartData(item);
            } else if (this.isDragTableItem(item, isStartDragItem)) {
                dataList = this.makeDBDragData(item);
            } else if (this.isDragEndTableItem(item, isStartDragItem)) {
                isStartDragItem = false;
                dataList = this.makeDBDragEndData(item);
            }
            if (dataList.size() > 0) {
                ReplayDataManager.getInstance().getReplayDBManager().insertData(dataList);
                dataList.clear();
            }
            ++i;
        }
    }

    private boolean isTouchTableItem(List<String> item, boolean isStartDragItem) {
        return item.get(3).equals(ReplayEditLabels.CONTEXT_TOUCH) && item.get(2).toString().length() != 0 && !isStartDragItem;
    }

    private boolean isDragStartTableItem(List<String> item, boolean isStartDragItem) {
        return item.get(3).equals(ReplayEditLabels.CONTEXT_TOUCH) && item.get(2).toString().length() == 0 && !isStartDragItem;
    }

    private boolean isDragTableItem(List<String> item, boolean isStartDragItem) {
        return item.get(3).equals(ReplayEditLabels.CONTEXT_TOUCH) && item.get(2).toString().length() == 0 && isStartDragItem;
    }

    private boolean isDragEndTableItem(List<String> item, boolean isStartDragItem) {
        return item.get(3).equals(ReplayEditLabels.CONTEXT_TOUCH) && isStartDragItem;
    }

    public String getDBTime(String time) {
        String strTime = time;
        if (strTime.equals("")) {
            return "";
        }
        if (strTime.contains(ReplayEditLabels.CONTEXT_VALUE_S)) {
            strTime = time.replace(ReplayEditLabels.CONTEXT_VALUE_S, "");
        }
        if (strTime.contains(".")) {
            strTime = strTime.replace(".", "");
        }
        strTime = String.valueOf(strTime) + 10000;
        return strTime;
    }

    private int getDBPoint(String point) {
        String strPoint = point;
        if (strPoint.contains(ReplayEditLabels.CONTEXT_VALUE_X)) {
            strPoint = strPoint.replace(ReplayEditLabels.CONTEXT_VALUE_X, "");
        }
        if (strPoint.contains(ReplayEditLabels.CONTEXT_VALUE_Y)) {
            strPoint = strPoint.replace(ReplayEditLabels.CONTEXT_VALUE_Y, "");
        }
        return Integer.parseInt(strPoint.trim());
    }

    public long getTimeValue(long sec, long nano) {
        DATime startTime = Global.getProject().getProfilingStartTime();
        long startSec = startTime.getSec();
        long startNano = startTime.getNano();
        long resultSec = sec - startSec;
        long resultNano = nano - startNano;
        long time = resultSec * 1000L * 1000L + resultNano / 1000L;
        return time;
    }

    private DATime getDATimeValue(long time) {
        DATime startTime = Global.getProject().getProfilingStartTime();
        long startSec = startTime.getSec();
        long startNano = startTime.getNano();
        long delaySec = time / 1000000L;
        long delayNano = time % 1000000L;
        long eventTimeSec = startSec + delaySec;
        long eventTimeNano = delayNano * 1000L + startNano;
        if (eventTimeNano > 1000000000L) {
            ++eventTimeSec;
            eventTimeNano = (time - ++delaySec * 1000L * 1000L) * 1000L + startNano;
        }
        DATime resultTime = new DATime();
        resultTime.setSec((int)eventTimeSec);
        resultTime.setNano((int)eventTimeNano);
        return resultTime;
    }

    private int getKeyValue(List<String> item) {
        String keyValue = item.get(4);
        int nKey = 0;
        if (keyValue.equals(ReplayEditLabels.CONTEXT_KEY_MENU)) {
            nKey = 169;
        } else if (keyValue.equals(ReplayEditLabels.CONTEXT_KEY_HOME)) {
            nKey = 139;
        } else if (keyValue.equals(ReplayEditLabels.CONTEXT_KEY_BACK)) {
            nKey = 158;
        } else if (keyValue.equals(ReplayEditLabels.CONTEXT_KEY_POWER)) {
            nKey = 116;
        } else if (keyValue.equals(ReplayEditLabels.CONTEXT_KEY_VOLUME_UP)) {
            nKey = 115;
        } else if (keyValue.equals(ReplayEditLabels.CONTEXT_KEY_VOLUME_DOWN)) {
            nKey = 114;
        }
        return nKey;
    }

    private List<List<Object>> makeDBKeyData(List<String> item) {
        String itemMouseDownTime = this.getDBTime(item.get(1));
        String itemMouseUpTime = this.getDBTime(item.get(2));
        if (itemMouseUpTime.equals("")) {
            itemMouseUpTime = itemMouseDownTime;
        }
        int itemValue1 = this.getKeyValue(item);
        DATime mouseDownTime = this.getDATimeValue(Long.parseLong(itemMouseDownTime));
        DATime mouseUpTime = this.getDATimeValue(Long.parseLong(itemMouseUpTime));
        int mouseDownTimeSec = mouseDownTime.getSec();
        int mouseDownTimeNano = mouseDownTime.getNano();
        int mouseUpTimeSec = mouseUpTime.getSec();
        int mouseUpTimeNano = mouseUpTime.getNano();
        ArrayList<List<Object>> dbKeyDataList = new ArrayList<List<Object>>();
        int i = 0;
        while (i < 4) {
            ArrayList<Number> keyData = new ArrayList<Number>();
            if (i == 0) {
                keyData.add(mouseDownTimeSec + this.insertDBRid++);
                keyData.add(0L);
                keyData.add(Long.parseLong(itemMouseDownTime));
                keyData.add(mouseDownTimeSec);
                keyData.add(mouseDownTimeNano);
                keyData.add(1);
                keyData.add(1);
                keyData.add(itemValue1);
                keyData.add(1);
            } else if (i == 1) {
                keyData.add(mouseDownTimeSec + this.insertDBRid++);
                keyData.add(0L);
                keyData.add(Long.parseLong(itemMouseDownTime));
                keyData.add(mouseDownTimeSec);
                keyData.add(mouseDownTimeNano);
                keyData.add(1);
                keyData.add(0);
                keyData.add(0);
                keyData.add(0);
            } else if (i == 2) {
                keyData.add(mouseUpTimeSec + this.insertDBRid++);
                keyData.add(0L);
                keyData.add(Long.parseLong(itemMouseDownTime));
                keyData.add(mouseUpTimeSec);
                keyData.add(mouseUpTimeNano);
                keyData.add(1);
                keyData.add(1);
                keyData.add(itemValue1);
                keyData.add(0);
            } else if (i == 3) {
                keyData.add(mouseUpTimeSec + this.insertDBRid++);
                keyData.add(0L);
                keyData.add(Long.parseLong(itemMouseDownTime));
                keyData.add(mouseUpTimeSec);
                keyData.add(mouseUpTimeNano);
                keyData.add(1);
                keyData.add(0);
                keyData.add(0);
                keyData.add(0);
            }
            dbKeyDataList.add(keyData);
            ++i;
        }
        return dbKeyDataList;
    }

    private List<List<Object>> makeDBTouchData(List<String> item) {
        List<Object> touchYList;
        ArrayList<List<Object>> dbKeyDataList = new ArrayList<List<Object>>();
        dbKeyDataList.add(this.getTouchFirstLog(item));
        List<Object> touchXList = this.getTouchXValueLog(item);
        if (touchXList != null) {
            dbKeyDataList.add(touchXList);
        }
        if ((touchYList = this.getTouchYValueLog(item)) != null) {
            dbKeyDataList.add(touchYList);
        }
        dbKeyDataList.add(this.getMouseDownEmptyLog(item));
        dbKeyDataList.add(this.getTouchMouseUPLog(item));
        dbKeyDataList.add(this.getMouseUpEmptyLog(item));
        return dbKeyDataList;
    }

    private List<List<Object>> makeDBDragStartData(List<String> item) {
        List<Object> touchYList;
        ArrayList<List<Object>> dbKeyDataList = new ArrayList<List<Object>>();
        dbKeyDataList.add(this.getTouchFirstLog(item));
        List<Object> touchXList = this.getTouchXValueLog(item);
        if (touchXList != null) {
            dbKeyDataList.add(touchXList);
        }
        if ((touchYList = this.getTouchYValueLog(item)) != null) {
            dbKeyDataList.add(touchYList);
        }
        dbKeyDataList.add(this.getMouseDownEmptyLog(item));
        return dbKeyDataList;
    }

    private List<List<Object>> makeDBDragData(List<String> item) {
        List<Object> touchYList;
        ArrayList<List<Object>> dbKeyDataList = new ArrayList<List<Object>>();
        List<Object> touchXList = this.getTouchXValueLog(item);
        if (touchXList != null) {
            dbKeyDataList.add(touchXList);
        }
        if ((touchYList = this.getTouchYValueLog(item)) != null) {
            dbKeyDataList.add(touchYList);
        }
        dbKeyDataList.add(this.getMouseDownEmptyLog(item));
        return dbKeyDataList;
    }

    private List<List<Object>> makeDBDragEndData(List<String> item) {
        List<Object> touchYList;
        ArrayList<List<Object>> dbKeyDataList = new ArrayList<List<Object>>();
        List<Object> touchXList = this.getTouchXValueLog(item);
        if (touchXList != null) {
            dbKeyDataList.add(touchXList);
        }
        if ((touchYList = this.getTouchYValueLog(item)) != null) {
            dbKeyDataList.add(touchYList);
        }
        dbKeyDataList.add(this.getMouseDownEmptyLog(item));
        dbKeyDataList.add(this.getTouchMouseUPLog(item));
        dbKeyDataList.add(this.getMouseUpEmptyLog(item));
        return dbKeyDataList;
    }

    private List<Object> getTouchFirstLog(List<String> item) {
        String itemMouseDownTime = this.getDBTime(item.get(1));
        DATime mouseDownTime = this.getDATimeValue(Long.parseLong(itemMouseDownTime));
        ArrayList<Object> keyData = new ArrayList<Object>();
        keyData.add(mouseDownTime.getSec() + this.insertDBRid++);
        keyData.add(0L);
        keyData.add(Long.parseLong(itemMouseDownTime));
        keyData.add(mouseDownTime.getSec());
        keyData.add(mouseDownTime.getNano());
        keyData.add(0);
        keyData.add(3);
        keyData.add(57);
        keyData.add(this.insertkeySequence++);
        return keyData;
    }

    private List<Object> getTouchXValueLog(List<String> item) {
        String itemMouseDownTime = this.getDBTime(item.get(1));
        DATime mouseDownTime = this.getDATimeValue(Long.parseLong(itemMouseDownTime));
        String itemValue1 = item.get(4).trim();
        if (itemValue1.length() == 0) {
            return null;
        }
        ArrayList<Object> keyData = new ArrayList<Object>();
        keyData.add(mouseDownTime.getSec() + this.insertDBRid++);
        keyData.add(0L);
        keyData.add(Long.parseLong(itemMouseDownTime));
        keyData.add(mouseDownTime.getSec());
        keyData.add(mouseDownTime.getNano());
        keyData.add(0);
        keyData.add(3);
        keyData.add(53);
        keyData.add(this.getDBPoint(itemValue1));
        return keyData;
    }

    private List<Object> getTouchYValueLog(List<String> item) {
        String itemMouseDownTime = this.getDBTime(item.get(1));
        DATime mouseDownTime = this.getDATimeValue(Long.parseLong(itemMouseDownTime));
        String itemValue2 = item.get(5).trim();
        if (itemValue2.length() == 0) {
            return null;
        }
        ArrayList<Object> keyData = new ArrayList<Object>();
        keyData.add(mouseDownTime.getSec() + this.insertDBRid++);
        keyData.add(0L);
        keyData.add(Long.parseLong(itemMouseDownTime));
        keyData.add(mouseDownTime.getSec());
        keyData.add(mouseDownTime.getNano());
        keyData.add(0);
        keyData.add(3);
        keyData.add(54);
        keyData.add(this.getDBPoint(itemValue2));
        return keyData;
    }

    private List<Object> getMouseDownEmptyLog(List<String> item) {
        String itemMouseDownTime = this.getDBTime(item.get(1));
        DATime mouseDownTime = this.getDATimeValue(Long.parseLong(itemMouseDownTime));
        ArrayList<Object> keyData = new ArrayList<Object>();
        keyData.add(mouseDownTime.getSec() + this.insertDBRid++);
        keyData.add(0L);
        keyData.add(Long.parseLong(itemMouseDownTime));
        keyData.add(mouseDownTime.getSec());
        keyData.add(mouseDownTime.getNano());
        keyData.add(0);
        keyData.add(0);
        keyData.add(0);
        keyData.add(0);
        return keyData;
    }

    private List<Object> getMouseUpEmptyLog(List<String> item) {
        String itemMouseUpTime = this.getDBTime(item.get(2));
        DATime mouseUpTime = this.getDATimeValue(Long.parseLong(itemMouseUpTime));
        ArrayList<Object> keyData = new ArrayList<Object>();
        keyData.add(mouseUpTime.getSec() + this.insertDBRid++);
        keyData.add(0L);
        keyData.add(Long.parseLong(itemMouseUpTime));
        keyData.add(mouseUpTime.getSec());
        keyData.add(mouseUpTime.getNano());
        keyData.add(0);
        keyData.add(0);
        keyData.add(0);
        keyData.add(0);
        return keyData;
    }

    private List<Object> getTouchMouseUPLog(List<String> item) {
        String itemMouseDownTime = this.getDBTime(item.get(1));
        String itemMouseUpTime = this.getDBTime(item.get(2));
        DATime mouseUpTime = this.getDATimeValue(Long.parseLong(itemMouseUpTime));
        ArrayList<Object> keyData = new ArrayList<Object>();
        keyData.add(mouseUpTime.getSec() + this.insertDBRid++);
        keyData.add(0L);
        keyData.add(Long.parseLong(itemMouseDownTime));
        keyData.add(mouseUpTime.getSec());
        keyData.add(mouseUpTime.getNano());
        keyData.add(0);
        keyData.add(3);
        keyData.add(57);
        keyData.add(-1);
        return keyData;
    }

    private List<List<String>> getTableItemsList() {
        if (this.tableItemsList == null) {
            this.tableItemsList = new ArrayList<List<String>>();
        }
        return this.tableItemsList;
    }

    public void setTableItemsList(DATableComposite replayComp) {
        if (this.tableItemsList == null) {
            this.tableItemsList = new ArrayList<List<String>>();
        }
        int i = 0;
        while (i < replayComp.getTable().getItemCount()) {
            ArrayList<String> text = new ArrayList<String>();
            int size = replayComp.getTable().getColumns().length;
            int j = 0;
            while (j < size + 1) {
                text.add(replayComp.getTable().getItem(i).getText(j));
                ++j;
            }
            this.tableItemsList.add(text);
            ++i;
        }
    }
}

