/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.SettingDialogManager;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableToggleRenderer;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class FeatureDialogFeaturesTreeTableToggleRenderer
extends DATableToggleRenderer {
    private static final int intevalSize = 15;
    private Grid table = null;
    private Composite detailSystemComposit = null;
    private Label systemTitle = null;
    private DATextBox systemTextBox = null;
    private Label systemTextBoxLabel = null;
    private Label systemInfo = null;
    private GridEditor systemEditor = null;
    private Composite detailSamplingComposit = null;
    private Label samplingTitle = null;
    private DATextBox samplingTextBox = null;
    private Label samplingTextBoxLabel = null;
    private Label samplingInfo = null;
    private GridEditor samplingEditor = null;
    private KeyListener systemKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            boolean valid = FeatureDialogFeaturesTreeTableToggleRenderer.this.checkValidInputText(ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE, FeatureDialogFeaturesTreeTableToggleRenderer.this.systemTextBox, FeatureDialogFeaturesTreeTableToggleRenderer.this.systemInfo);
            GridItem item = FeatureDialogFeaturesTreeTableToggleRenderer.this.getGridItem(ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE);
            if (item != null) {
                FeatureDialogFeaturesTreeTableToggleRenderer.this.setOptionText(item, ConfigureLabels.SAMPLING, FeatureDialogFeaturesTreeTableToggleRenderer.this.systemTextBox.getText());
                FeatureDialogFeaturesTreeTableToggleRenderer.this.updateInputText(item, valid);
                SettingDialogManager.INSTANCE.updateFeatureButtonStatus(FeatureDialogFeaturesTreeTableToggleRenderer.this.table);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private KeyListener samplingKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            boolean valid = FeatureDialogFeaturesTreeTableToggleRenderer.this.checkValidInputText(ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE, FeatureDialogFeaturesTreeTableToggleRenderer.this.samplingTextBox, FeatureDialogFeaturesTreeTableToggleRenderer.this.samplingInfo);
            GridItem item = FeatureDialogFeaturesTreeTableToggleRenderer.this.getGridItem(ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE);
            if (item != null) {
                FeatureDialogFeaturesTreeTableToggleRenderer.this.setOptionText(item, ConfigureLabels.SAMPLING, FeatureDialogFeaturesTreeTableToggleRenderer.this.samplingTextBox.getText());
                FeatureDialogFeaturesTreeTableToggleRenderer.this.updateInputText(item, valid);
                SettingDialogManager.INSTANCE.updateFeatureButtonStatus(FeatureDialogFeaturesTreeTableToggleRenderer.this.table);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public FeatureDialogFeaturesTreeTableToggleRenderer(Grid table) {
        this.setSize(11, 9);
        this.table = table;
        this.initSystemDetailWidget();
        this.initSamplingDetailWidget();
    }

    @Override
    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)value;
        Font font = item.getFont(0);
        if (font == null) {
            gc.setFont(FontResources.TABLE_CELL_FONT);
        } else {
            gc.setFont(font);
        }
        if (item.hasChildren()) {
            Image treeFoldImg = null;
            treeFoldImg = item.isExpanded() ? ImageResources.TREE_OPEN : ImageResources.TREE_FOLD;
            int foldImgOffset = (this.getBounds().width - ImageResources.TREE_OPEN.getBounds().width) / 2;
            int x = this.getBounds().x + foldImgOffset;
            gc.drawImage(treeFoldImg, 5, this.getBounds().y);
            Image checkImg = null;
            checkImg = item.getText(1).contains(", item_all_checked ") || item.getText(1).contains(", item_part_checked ") ? ImageResources.CHECKBOX_SELECTED : ImageResources.CHECKBOX_UNSELECTED;
            Rectangle checkImgRect = ImageResources.CHECKBOX_SELECTED.getBounds();
            gc.drawImage(checkImg, x += 15, this.getBounds().y - 3);
            gc.drawText(item.getText(), x += checkImgRect.width + 15, this.getBounds().y - 2, true);
        } else {
            Rectangle r = ImageResources.TREE_OPEN.getBounds();
            int offset = (this.getBounds().width - r.width) / 2;
            int x = this.getBounds().x + offset;
            if (this.isDetailFeature(item)) {
                this.updateDetails(item);
            } else {
                Image checkImg = null;
                checkImg = item.getText(1).contains(", item_all_checked ") ? ImageResources.CHECKBOX_SELECTED : (item.getText(1).contains(", item_part_checked ") ? ImageResources.CHECKBOX_SELECTED_PART : ImageResources.CHECKBOX_UNSELECTED);
                Rectangle checkImgRect = ImageResources.CHECKBOX_SELECTED.getBounds();
                gc.drawImage(checkImg, x += 15, this.getBounds().y - 3);
                gc.drawText(item.getText(), x += checkImgRect.width + 15, this.getBounds().y - 2, true);
            }
        }
    }

    private boolean isDetailFeature(GridItem item) {
        FeatureData feature = Feature.getFeature(item.getText()).getData();
        return 2 == feature.getFeatureType();
    }

    private void updateDetails(GridItem item) {
        if (ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE.equals(item.getText())) {
            this.updateSystemDetails(item);
        } else if (ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE.equals(item.getText())) {
            this.updateSamplingDetails(item);
        }
    }

    private void initSystemDetailWidget() {
        this.detailSystemComposit = new Composite((Composite)this.table, 0);
        this.detailSystemComposit.setLayout((Layout)new FormLayout());
        this.detailSystemComposit.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
        this.systemTitle = new Label(this.detailSystemComposit, 0x40000000);
        this.systemTitle.setText(ConfigureLabels.SAMPLING);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 0);
        data.width = 90;
        data.height = 16;
        this.systemTitle.setLayoutData((Object)data);
        this.systemTitle.setForeground(ColorResources.SETTING_COLOR);
        this.systemTitle.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.systemTitle.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
        this.systemTextBox = new DATextBox(this.detailSystemComposit, 4);
        data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment((Control)this.systemTitle, 5);
        data.width = 50;
        data.height = 13;
        this.systemTextBox.setLayoutData((Object)data);
        this.systemTextBox.setForeground(ColorResources.SETTING_COLOR);
        this.systemTextBox.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.systemTextBox.getControl().addKeyListener(this.systemKeyListener);
        this.systemTextBox.setTextTooltip(true);
        this.systemTextBox.setTextTooltipMessage(ConfigureLabels.FEATURE_OVERHEAD_RANKING_INPUT_VALUE);
        this.systemTextBox.getControl().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        this.systemTextBoxLabel = new Label(this.detailSystemComposit, 0x40000000);
        this.systemTextBoxLabel.setText(ConfigureLabels.MS);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.systemTextBox.getControl(), 5);
        data.width = 30;
        data.height = 16;
        this.systemTextBoxLabel.setLayoutData((Object)data);
        this.systemTextBoxLabel.setForeground(ColorResources.SETTING_COLOR);
        this.systemTextBoxLabel.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.systemTextBoxLabel.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
        this.systemInfo = new Label(this.detailSystemComposit, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.systemTextBoxLabel, 5);
        data.width = 250;
        data.height = 16;
        this.systemInfo.setLayoutData((Object)data);
        this.systemInfo.setForeground(ColorResources.SETTING_WARNING_FONT_COLOR);
        this.systemInfo.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.systemInfo.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
    }

    private void initSamplingDetailWidget() {
        this.detailSamplingComposit = new Composite((Composite)this.table, 0);
        this.detailSamplingComposit.setLayout((Layout)new FormLayout());
        this.detailSamplingComposit.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
        this.samplingTitle = new Label(this.detailSamplingComposit, 0x40000000);
        this.samplingTitle.setText(ConfigureLabels.SAMPLING);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 0);
        data.width = 90;
        data.height = 16;
        this.samplingTitle.setLayoutData((Object)data);
        this.samplingTitle.setForeground(ColorResources.SETTING_COLOR);
        this.samplingTitle.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.samplingTitle.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
        this.samplingTextBox = new DATextBox(this.detailSamplingComposit, 4);
        data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment((Control)this.samplingTitle, 5);
        data.width = 50;
        data.height = 13;
        this.samplingTextBox.setLayoutData((Object)data);
        this.samplingTextBox.setForeground(ColorResources.SETTING_COLOR);
        this.samplingTextBox.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.samplingTextBox.getControl().addKeyListener(this.samplingKeyListener);
        this.samplingTextBox.setTextTooltip(true);
        this.samplingTextBox.setTextTooltipMessage(ConfigureLabels.FEATURE_OVERHEAD_RANKING_INPUT_VALUE);
        this.samplingTextBox.getControl().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        this.samplingTextBoxLabel = new Label(this.detailSamplingComposit, 0x40000000);
        this.samplingTextBoxLabel.setText(ConfigureLabels.MS);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.samplingTextBox.getControl(), 5);
        data.width = 30;
        data.height = 16;
        this.samplingTextBoxLabel.setLayoutData((Object)data);
        this.samplingTextBoxLabel.setForeground(ColorResources.SETTING_COLOR);
        this.samplingTextBoxLabel.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.samplingTextBoxLabel.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
        this.samplingInfo = new Label(this.detailSamplingComposit, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.samplingTextBoxLabel, 5);
        data.width = 250;
        data.height = 16;
        this.samplingInfo.setLayoutData((Object)data);
        this.samplingInfo.setForeground(ColorResources.SETTING_WARNING_FONT_COLOR);
        this.samplingInfo.setFont(FontResources.SETTING_DESCRIPTION_FONT);
        this.samplingInfo.setBackground(ColorResources.SETTING_TABLE_CONTENTS_CHILD);
    }

    private void updateSystemDetails(GridItem item) {
        String text = this.getOptionText(item, ConfigureLabels.SAMPLING);
        if (text != null && !text.equals(this.systemTextBox.getText())) {
            this.systemTextBox.setText(text);
        }
        if (this.isTableSelectedFeature(item.getParentItem().getText())) {
            this.systemTextBox.getControl().setEnabled(true);
            this.checkValidInputText(ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE, this.systemTextBox, this.systemInfo);
        } else {
            this.systemTextBox.getControl().setEnabled(false);
            this.systemInfo.setText("");
        }
        if (!DAState.isStartable()) {
            this.systemTextBox.getControl().setEnabled(false);
        }
        this.systemEditor = new GridEditor(this.table);
        this.systemEditor.horizontalAlignment = 16384;
        this.systemEditor.grabHorizontal = true;
        this.systemEditor.setEditor((Control)this.detailSystemComposit, item, 0);
        this.detailSystemComposit.layout(true);
    }

    private void updateSamplingDetails(GridItem item) {
        String text = this.getOptionText(item, ConfigureLabels.SAMPLING);
        if (text != null && !text.equals(this.samplingTextBox.getText())) {
            this.samplingTextBox.setText(text);
        }
        if (this.isTableSelectedFeature(item.getParentItem().getText())) {
            this.samplingTextBox.getControl().setEnabled(true);
            this.checkValidInputText(ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE, this.samplingTextBox, this.samplingInfo);
        } else {
            this.samplingTextBox.getControl().setEnabled(false);
            this.samplingInfo.setText("");
        }
        if (!DAState.isStartable()) {
            this.samplingTextBox.getControl().setEnabled(false);
        }
        this.samplingEditor = new GridEditor(this.table);
        this.samplingEditor.horizontalAlignment = 16384;
        this.samplingEditor.grabHorizontal = true;
        this.samplingEditor.setEditor((Control)this.detailSamplingComposit, item, 0);
        this.detailSamplingComposit.layout(true);
    }

    private boolean isTableSelectedFeature(String featureName) {
        GridItem[] list = this.table.getItems();
        int i = 0;
        while (i < list.length) {
            if (featureName.equals(list[i].getText(0))) {
                String optionText = list[i].getText(1);
                return optionText.contains(", item_all_checked ") || optionText.contains(", item_part_checked ");
            }
            ++i;
        }
        return false;
    }

    private GridItem getGridItem(String featureName) {
        GridItem[] list = this.table.getItems();
        int i = 0;
        while (i < list.length) {
            if (featureName.equals(list[i].getText(0))) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    private boolean checkValidInputText(String featuresName, DATextBox textBox, Label info) {
        FeatureData feature = Feature.getFeature(featuresName).getData();
        String errormsg = feature.validateInputValue(textBox.getText());
        info.setText(errormsg);
        return errormsg.isEmpty();
    }

    private String getOptionText(GridItem item, String optionName) {
        String[] optionList;
        String value = null;
        if (item.getText(1).contains(optionName) && (optionList = item.getText(1).split(optionName)).length > 1) {
            if (optionList[1].contains(",")) {
                String[] optionList2 = optionList[1].split(",");
                value = optionList2[0];
            } else {
                value = optionList[1];
            }
        }
        return value;
    }

    private void setOptionText(GridItem item, String optionName, String value) {
        String[] optionList;
        StringBuffer buffer = new StringBuffer();
        String optionText = item.getText(1);
        if (optionText.contains(optionName) && (optionList = item.getText(1).split(optionName)).length > 1) {
            buffer.append(String.valueOf(optionList[0]) + optionName + value);
            if (optionList[1].contains(",")) {
                String[] optionList2 = optionList[1].split(",");
                int i = 1;
                while (i < optionList2.length) {
                    buffer.append("," + optionList2[i]);
                    ++i;
                }
            }
        }
        item.setText(1, buffer.toString());
    }

    private void updateInputText(GridItem item, boolean valid) {
        String optionText = item.getText(1);
        if (optionText.contains(", feature_invalid_value ")) {
            optionText = item.getText(1).replace(", feature_invalid_value ", "");
        }
        if (!valid) {
            optionText = String.valueOf(optionText) + ", feature_invalid_value ";
        }
        item.setText(1, optionText);
    }

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        return new Point(11, 9);
    }
}

