/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.nl.PreferencesDialogLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomExtendButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class PreferencesDialog
extends DAMessageBox {
    private static boolean opened = false;
    private static boolean screenshotFeatureEnabled = false;
    private ScrolledComposite scrolledComp = null;
    private Composite buttonContentsComp = null;
    private final int DIALOG_HEIGT = 500;
    private final int DIALOG_WIDTH = 450;
    private static final int LABLE_LEFT_MARGIN = 35;
    private static final int LABLE_WIDTH = 150;
    private static final int LABLE_INTERVAL = 21;
    private static final int CONTROL_HEIGHT = 24;
    private static final int CONTROL_WIDTH = 76;
    private static final int GRID_SPACING = 5;
    private DACustomToggleButton sourceviewtoggle = null;
    private DACustomToggleButton periodicallyToggle = null;
    private DACustomToggleButton onSceneTransitionToggle = null;
    private DACustomCombo systemRateCombo = null;
    private DACustomCombo functionRateCombo = null;
    private DACustomCombo screenshotRateCombo = null;
    private Button okButton;

    public PreferencesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 450) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 500) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(450, 500);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(PreferencesDialogLabels.TITLE);
        this.shell.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        Composite marginTop = new Composite((Composite)this.shell, 0);
        this.scrolledComp = new ScrolledComposite((Composite)this.shell, 512);
        Composite marginMiddle = new Composite((Composite)this.shell, 0);
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        marginTop.setLayout((Layout)new FormLayout());
        FormData marginCompData = new FormData();
        marginCompData.top = new FormAttachment(0, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(0, 1);
        marginTop.setLayoutData((Object)marginCompData);
        marginTop.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        this.scrolledComp.setLayout((Layout)new FormLayout());
        FormData scrollCompData = new FormData();
        scrollCompData.top = new FormAttachment((Control)marginTop, 0);
        scrollCompData.left = new FormAttachment(0, 0);
        scrollCompData.right = new FormAttachment(100, 0);
        scrollCompData.bottom = new FormAttachment(100, -61);
        this.scrolledComp.setLayoutData((Object)scrollCompData);
        this.scrolledComp.setExpandVertical(true);
        this.scrolledComp.setExpandHorizontal(true);
        this.scrolledComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.scrolledComp.getVerticalBar().setIncrement(12);
        this.scrolledComp.setFocus();
        marginMiddle.setLayout((Layout)new FormLayout());
        marginCompData = new FormData();
        marginCompData.top = new FormAttachment((Control)this.scrolledComp, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(100, -60);
        marginMiddle.setLayoutData((Object)marginCompData);
        marginMiddle.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        this.buttonContentsComp.setLayout((Layout)new FormLayout());
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)marginMiddle, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.buttonContentsComp.setLayoutData((Object)compData);
        this.buttonContentsComp.setBackground(ColorResources.WHITE);
        screenshotFeatureEnabled = SettingDataManager.INSTANCE.getSelectedFlatFeatureSet().contains((Object)FlatFeature.SCREENSHOT);
        this.drawPreferenceCom();
        this.initComboBoxes();
        this.drawButtonCom();
        this.setSelectedOptions();
        if (DAState.isRunning()) {
            this.disableConfiguration();
        }
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        this.shell.open();
        return true;
    }

    private void drawPreferenceCom() {
        RowLayout parentLayout = new RowLayout(512);
        parentLayout.spacing = 10;
        parentLayout.marginWidth = 10;
        parentLayout.marginHeight = 10;
        GridLayout childLayout = new GridLayout();
        childLayout.numColumns = 4;
        childLayout.verticalSpacing = 10;
        childLayout.horizontalSpacing = 5;
        int generalviewHeight = 114;
        int screenshotViewHeight = 69;
        Composite baseCom = new Composite((Composite)this.scrolledComp, 0);
        baseCom.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        baseCom.setLayout((Layout)parentLayout);
        Composite generalBaseView = new Composite(baseCom, 0);
        generalBaseView.setLayoutData((Object)new RowData());
        generalBaseView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        generalBaseView.setLayout((Layout)parentLayout);
        DACustomExtendButton generalExtend = this.createFoldingButton(generalBaseView, PreferencesDialogLabels.GENERAL);
        Composite generalView = new Composite(generalBaseView, 0);
        generalView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        generalView.setLayout((Layout)childLayout);
        generalView.setLayoutData((Object)new RowData(-1, generalviewHeight));
        generalExtend.addClickListener(this.createExpandListener(generalView));
        this.createLabel(generalView, PreferencesDialogLabels.SOURCE_VIEW, 2);
        this.sourceviewtoggle = this.createToggleButton(generalView);
        this.createLabel(generalView, PreferencesDialogLabels.SYSTEM_SAMPLIING_RATE, 2);
        this.systemRateCombo = this.makeDACustomCombo(generalView, "ms");
        this.createLabel(generalView, PreferencesDialogLabels.FUNCION_SAMPLIING_RATE, 2);
        this.functionRateCombo = this.makeDACustomCombo(generalView, "ms");
        Composite screenshotBaseView = new Composite(baseCom, 0);
        screenshotBaseView.setLayoutData((Object)new RowData());
        screenshotBaseView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        screenshotBaseView.setLayout((Layout)parentLayout);
        DACustomExtendButton screenshotExtend = this.createFoldingButton(screenshotBaseView, PreferencesDialogLabels.SCREENSHOT);
        Composite screenshotView = new Composite(screenshotBaseView, 0);
        screenshotView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        screenshotView.setLayoutData((Object)new RowData(-1, screenshotViewHeight));
        screenshotView.setLayout((Layout)childLayout);
        screenshotExtend.addClickListener(this.createExpandListener(screenshotView));
        this.createLabel(screenshotView, PreferencesDialogLabels.PERIODICALLY, 1);
        this.periodicallyToggle = this.createToggleButton(screenshotView);
        this.screenshotRateCombo = this.makeDACustomCombo(screenshotView, "s");
        this.screenshotRateCombo.setEnabled(false);
        this.periodicallyToggle.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                PreferencesDialog.this.screenshotRateCombo.setEnabled(PreferencesDialog.this.periodicallyToggle.isToggled());
            }
        });
        this.createLabel(screenshotView, PreferencesDialogLabels.ON_SCENE_TRANSITION, 2);
        this.onSceneTransitionToggle = this.createToggleButton(screenshotView);
        this.scrolledComp.setContent((Control)baseCom);
        this.scrolledComp.setMinSize(baseCom.computeSize(-1, -1));
    }

    private DACustomButtonClickEventListener createExpandListener(final Composite view) {
        return new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                RowData data = (RowData)view.getLayoutData();
                data.exclude = !data.exclude;
                view.setVisible(!data.exclude);
                Composite baseComp = view.getParent().getParent();
                PreferencesDialog.this.scrolledComp.layout(true, true);
                PreferencesDialog.this.scrolledComp.setMinSize(baseComp.computeSize(-1, -1));
            }
        };
    }

    private void drawButtonCom() {
        this.okButton = new Button(this.buttonContentsComp, 0);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment(100, -15);
        buttonData.width = 100;
        buttonData.height = 30;
        this.okButton.setLayoutData((Object)buttonData);
        this.okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.applyPreferenceData();
                if (DAState.isStartable()) {
                    CommonAction.configure();
                }
                SettingDataManager.INSTANCE.applySettingData();
                PreferencesDialog.this.shell.dispose();
            }
        });
        Button cancelButton = new Button(this.buttonContentsComp, 0);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment((Control)this.okButton, -8);
        buttonData.width = 100;
        buttonData.height = 30;
        cancelButton.setLayoutData((Object)buttonData);
        cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        cancelButton.setText(WidgetLabels.CANCEL);
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.shell.dispose();
            }
        });
        Button resetToDefaultButton = new Button(this.buttonContentsComp, 0);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment((Control)cancelButton, -8);
        buttonData.width = 115;
        buttonData.height = 30;
        resetToDefaultButton.setLayoutData((Object)buttonData);
        resetToDefaultButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        resetToDefaultButton.setText(PreferencesDialogLabels.RESET_TO_DEFAULT);
        resetToDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.resetToDefault();
                PreferencesDialog.this.scrolledComp.setFocus();
            }
        });
    }

    private void setSelectedOptions() {
        int value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.SOURCE_VIEW);
        if (value == 1) {
            this.sourceviewtoggle.setToggled(true);
            MenuBar.getInstance().setSourceView(true);
        } else {
            this.sourceviewtoggle.setToggled(false);
            MenuBar.getInstance().setSourceView(false);
        }
        value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.SYSTEM_SAMPLING_RATE);
        this.systemRateCombo.setText(String.valueOf(value));
        value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.FUNCTION_SAMPLING_RATE);
        this.functionRateCombo.setText(String.valueOf(value));
        if (screenshotFeatureEnabled) {
            value = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.SCREENSHOT_PERIODICALLY);
            boolean enabled = value != 0;
            this.periodicallyToggle.setToggled(enabled);
            this.periodicallyToggle.setButtonEnabled(true);
            this.screenshotRateCombo.setEnabled(enabled);
            if (enabled) {
                this.screenshotRateCombo.setText(String.valueOf(value));
            }
            enabled = SettingDataManager.INSTANCE.isOptionsSelectedPrefereces(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION);
            this.onSceneTransitionToggle.setToggled(enabled);
            this.onSceneTransitionToggle.setButtonEnabled(true);
        } else {
            this.periodicallyToggle.setToggled(false);
            this.periodicallyToggle.setButtonEnabled(false);
            this.screenshotRateCombo.setEnabled(false);
            this.onSceneTransitionToggle.setToggled(false);
            this.onSceneTransitionToggle.setButtonEnabled(false);
        }
    }

    private void resetToDefault() {
        int value = FlatPreferences.SOURCE_VIEW.getDefaultValue();
        if (value == 1) {
            this.sourceviewtoggle.setToggled(true);
        } else {
            this.sourceviewtoggle.setToggled(false);
        }
        value = FlatPreferences.SYSTEM_SAMPLING_RATE.getDefaultValue();
        this.systemRateCombo.setText(String.valueOf(value));
        value = FlatPreferences.FUNCTION_SAMPLING_RATE.getDefaultValue();
        this.functionRateCombo.setText(String.valueOf(value));
        if (screenshotFeatureEnabled) {
            value = FlatPreferences.SCREENSHOT_PERIODICALLY.getDefaultValue();
            boolean periodically = value != 0;
            this.periodicallyToggle.setToggled(periodically);
            this.screenshotRateCombo.setEnabled(periodically);
            if (periodically) {
                this.screenshotRateCombo.setText(String.valueOf(value));
            }
            this.onSceneTransitionToggle.setToggled((value = FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION.getDefaultValue()) != 0);
        }
    }

    private DACustomExtendButton createFoldingButton(Composite parent, String text) {
        DACustomExtendButton foldingbutton = new DACustomExtendButton(parent, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_UP_NORL, ImageResources.DROP_ARROW_UP_NORL);
        foldingbutton.setButtonImagePoint(new Point(0, 5));
        foldingbutton.setText(text);
        foldingbutton.setFontPoint(new Point(19, 0));
        foldingbutton.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        foldingbutton.setButtonFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        RowData rowData = new RowData(200, 24);
        foldingbutton.setLayoutData((Object)rowData);
        return foldingbutton;
    }

    private DACustomToggleButton createToggleButton(Composite parent) {
        DACustomToggleButton toggle = new DACustomToggleButton(parent, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF_DIM, ImageResources.TOGGLE_ON, ImageResources.TOGGLE_ON, ImageResources.TOGGLE_ON_DIM, ImageResources.TOGGLE_ON);
        Point imagePoint = new Point(0, 0);
        toggle.setButtonImagePoint(imagePoint);
        GridData gridData = new GridData(16384, 1024, false, false);
        gridData.widthHint = 76;
        gridData.heightHint = 24;
        toggle.setLayoutData((Object)gridData);
        return toggle;
    }

    private Label createLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        label.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        label.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        label.setText(text);
        GridData gridData = new GridData(16384, 0x1000000, true, false, horizontalSpan, 1);
        gridData.horizontalIndent = 35;
        gridData.minimumWidth = 150 + 81 * (horizontalSpan - 1);
        gridData.minimumHeight = 24;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void applyPreferenceData() {
        int rate;
        boolean sourceViewEnabled = this.sourceviewtoggle.isToggled();
        MenuBar.getInstance().setSourceView(sourceViewEnabled);
        SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SOURCE_VIEW, sourceViewEnabled ? 1 : 0);
        String ratestring = this.systemRateCombo.getText();
        try {
            rate = Integer.parseInt(ratestring);
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SYSTEM_SAMPLING_RATE, rate);
        }
        catch (Exception exception) {
            return;
        }
        ratestring = this.functionRateCombo.getText();
        try {
            rate = Integer.parseInt(ratestring);
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.FUNCTION_SAMPLING_RATE, rate);
        }
        catch (Exception exception) {
            return;
        }
        rate = 0;
        if (this.periodicallyToggle.isToggled()) {
            ratestring = this.screenshotRateCombo.getText();
            try {
                rate = Integer.parseInt(ratestring);
            }
            catch (Exception exception) {
                return;
            }
        }
        SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SCREENSHOT_PERIODICALLY, rate);
        if (this.onSceneTransitionToggle.isToggled()) {
            SettingDataManager.INSTANCE.addOptionsSelectedPreference(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION, 1);
        } else {
            SettingDataManager.INSTANCE.deleteOptionsSelectedPreference(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION);
        }
    }

    private DACustomCombo makeDACustomCombo(Composite parent, String unit) {
        DACustomCombo combo = new DACustomCombo(parent, 0);
        combo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        combo.setOutlineColors(ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130);
        combo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        combo.setComboImagePoint(new Point(61, 9));
        combo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        combo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        combo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        combo.setFontPoint(new Point(5, 5));
        combo.setEnabled(true);
        combo.setComboFont(FontResources.COMBO);
        combo.setItemFont(FontResources.DROPDOWN);
        combo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.widthHint = 76;
        data.heightHint = 24;
        combo.setLayoutData((Object)data);
        Label unitlabel = new Label(parent, 16384);
        data = new GridData(16384, 0x1000000, false, false);
        data.minimumWidth = 20;
        data.minimumHeight = 24;
        unitlabel.setLayoutData((Object)data);
        unitlabel.setText(unit);
        unitlabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        unitlabel.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        return combo;
    }

    private void initComboBoxes() {
        if (this.systemRateCombo != null) {
            this.systemRateCombo.initCombo();
            this.systemRateCombo.add("100");
            this.systemRateCombo.add("200");
            this.systemRateCombo.add("500");
            this.systemRateCombo.add("1000");
            this.systemRateCombo.select(3);
            this.systemRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
        if (this.functionRateCombo != null) {
            this.functionRateCombo.initCombo();
            this.functionRateCombo.add("10");
            this.functionRateCombo.add("50");
            this.functionRateCombo.add("100");
            this.functionRateCombo.add("200");
            this.functionRateCombo.select(0);
            this.functionRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
        if (this.screenshotRateCombo != null) {
            this.screenshotRateCombo.initCombo();
            this.screenshotRateCombo.add("1");
            this.screenshotRateCombo.add("2");
            this.screenshotRateCombo.add("5");
            this.screenshotRateCombo.add("10");
            this.screenshotRateCombo.select(0);
            this.screenshotRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
    }

    private void disableConfiguration() {
        this.systemRateCombo.setEnabled(false);
        this.functionRateCombo.setEnabled(false);
        this.periodicallyToggle.setButtonEnabled(false);
        this.screenshotRateCombo.setEnabled(false);
        this.onSceneTransitionToggle.setButtonEnabled(false);
    }
}

