/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureValueData;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FeatureDialog;

public enum SettingDialogManager {
    INSTANCE;

    private FeatureDialog featureDlg = null;

    public FeatureDialog getFeatureDlg() {
        return this.featureDlg;
    }

    public void setFeatureDlg(FeatureDialog featureDlg) {
        this.featureDlg = featureDlg;
    }

    public void updateFeatureButtonStatus(Grid table) {
        if (this.validInputText(table) && this.changedFeaturesFromTableItemsList(table)) {
            this.featureDlg.enableButteon();
        } else {
            this.featureDlg.diableButteon();
        }
    }

    public void setFeaturesValueFromTableItemsList(Grid table) {
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        ArrayList<FeatureValueData> list = new ArrayList<FeatureValueData>();
        FeatureValueData featureValue = null;
        int i = 0;
        while (i < table.getItemCount()) {
            String featureName = table.getItem(i).getText(0);
            String optionText = table.getItem(i).getText(1);
            Feature feature = Feature.getFeature(featureName);
            if (optionText.contains(", item_all_checked ") || optionText.contains(", item_part_checked ")) {
                featureValue = feature.getData().getFeatureType() == 2 ? this.addDetailFeature(table.getItem(i)) : new FeatureValueData(feature);
                list.add(featureValue);
            }
            ++i;
        }
        target.setSelectedFeatureList(list);
    }

    public boolean changedFeaturesFromTableItemsList(Grid table) {
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        int count = 0;
        int i = 0;
        while (i < table.getItemCount()) {
            String featureName = table.getItem(i).getText(0);
            String optionText = table.getItem(i).getText(1);
            Feature feature = Feature.getFeature(featureName);
            if (optionText.contains(", item_all_checked ") || optionText.contains(", item_part_checked ")) {
                ++count;
                if (feature.getData().getFeatureType() == 2 ? this.changedDetailFeature(table.getItem(i), target) : !target.isSelectedFeature(feature)) {
                    return true;
                }
            }
            ++i;
        }
        return target.getSelectedFeatureList().size() != count;
    }

    public boolean validInputText(Grid table) {
        int i = 0;
        while (i < table.getItemCount()) {
            String optionText = table.getItem(i).getText(1);
            if ((optionText.contains(", item_all_checked ") || optionText.contains(", item_part_checked ")) && optionText.contains(", feature_invalid_value ")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private FeatureValueData addDetailFeature(GridItem item) {
        FeatureValueData featureValue = null;
        String featureName = item.getText(0);
        Feature feature = Feature.getFeature(featureName);
        if (ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE.equals(featureName) || ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE.equals(featureName)) {
            int tableValue = Integer.parseInt(this.getOptionText(item, ConfigureLabels.SAMPLING));
            featureValue = new FeatureValueData(feature);
            featureValue.setValue(tableValue);
        }
        return featureValue;
    }

    private boolean changedDetailFeature(GridItem item, TargetData target) {
        int tableValue;
        int value;
        String featureName = item.getText(0);
        return (ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE.equals(featureName) || ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE.equals(featureName)) && (value = target.getSelectedFeatureValue(Feature.getFeature(featureName))) != (tableValue = Integer.parseInt(this.getOptionText(item, ConfigureLabels.SAMPLING)));
    }

    private String getOptionText(GridItem item, String optionName) {
        String[] optionList;
        String value = null;
        if (item.getText(1).contains(optionName) && (optionList = item.getText(1).split(optionName)).length > 1) {
            if (optionList[1].contains(",")) {
                String[] optionList2 = optionList[1].split(",");
                value = optionList2[0];
            } else {
                value = optionList[1];
            }
        }
        return value;
    }
}

