/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.internal.CheckBoxRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.SortArrowRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;

public class DATableHeaderRenderer
extends DefaultColumnHeaderRenderer {
    int leftMargin = 6;
    int rightMargin = 6;
    int topMargin = 3;
    int arrowMargin = 6;
    int insideMargin = 3;
    int alignment;
    boolean check = false;
    boolean checked = false;
    Color bgColor = ColorResources.TABLE_HEADER_BG;
    Color fontColor = ColorResources.TABLE_HEADER_FONT_COLOR;
    private SortArrowRenderer arrowRenderer = new SortArrowRenderer();
    protected CheckBoxRenderer checkRenderer = null;

    public DATableHeaderRenderer() {
        this.alignment = 0x1000000;
    }

    public DATableHeaderRenderer(int style) {
        this.alignment = (style & 0x4000) == 16384 ? 16384 : ((style & 0x20000) == 131072 ? 131072 : 0x1000000);
        if ((style & 0x20) == 32) {
            this.check = true;
            this.checkRenderer = new CheckBoxRenderer();
        }
    }

    public void setDisplay(Display display) {
        super.setDisplay(display);
        this.arrowRenderer.setDisplay(display);
        if (this.checkRenderer != null) {
            this.checkRenderer.setDisplay(display);
        }
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void paint(GC gc, Object value) {
        this.paint(gc, (GridColumn)value);
    }

    public void setSelected() {
        if (this.check) {
            this.checked = !this.checked;
        }
    }

    public boolean getChecked() {
        return this.checked;
    }

    public void paint(GC gc, GridColumn column) {
        boolean flat = column.getParent().getCellSelectionEnabled() && !column.getMoveable();
        boolean drawSelected = this.isMouseDown() && this.isHover();
        gc.setBackground(this.bgColor);
        if (flat && this.isSelected()) {
            gc.setBackground(column.getParent().getCellHeaderSelectionBackground());
        }
        Rectangle r = this.getBounds();
        gc.fillRectangle(r.x, r.y, r.width, r.height);
        gc.setForeground(ColorResources.TABLE_LINE);
        gc.drawLine(r.x - 1, r.y, r.x - 1, r.y + r.height);
        gc.drawLine(r.x - 1, r.y + r.height, r.x + r.width, r.y + r.height);
        int pushedDrawingOffset = 0;
        if (drawSelected) {
            pushedDrawingOffset = 1;
        }
        int x = this.leftMargin;
        if (this.check) {
            this.checkRenderer.setChecked(this.checked);
            this.checkRenderer.setHover(this.getHoverDetail().equals("check"));
            this.checkRenderer.setBounds(this.getBounds().x + x, (this.getBounds().height - this.checkRenderer.getBounds().height) / 2 + this.getBounds().y, this.checkRenderer.getBounds().width, this.checkRenderer.getBounds().height);
            this.checkRenderer.paint(gc, null);
            x += this.checkRenderer.getBounds().width + this.insideMargin;
        }
        if (column.getImage() != null) {
            gc.drawImage(column.getImage(), this.getBounds().x + x + pushedDrawingOffset, this.getBounds().y + this.topMargin + pushedDrawingOffset);
            x += column.getImage().getBounds().width + this.insideMargin;
        }
        int width = this.getBounds().width - x;
        width = column.getSort() == 0 ? (width -= this.rightMargin) : (width -= this.arrowMargin + this.arrowRenderer.getSize().x + this.arrowMargin);
        gc.setForeground(this.fontColor);
        gc.setFont(FontResources.TABLE_HEADER_FONT);
        String inputText = TextUtils.getShortString((GC)gc, (String)column.getText(), (int)width);
        Point textSize = gc.textExtent(inputText, 8);
        int textX = this.alignment == 0x1000000 ? r.x + (r.width - textSize.x) / 2 : (this.alignment == 16384 ? r.x + x : r.x + r.width - textSize.x - this.rightMargin);
        int y = this.getBounds().y + (this.getBounds().height - textSize.y) / 2;
        gc.drawString(inputText, textX + pushedDrawingOffset, y + pushedDrawingOffset, true);
        if (column.getSort() != 0) {
            this.arrowRenderer.setSelected(column.getSort() == 128);
            if (drawSelected) {
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width + 1, this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2 + 1);
            } else {
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width, this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2);
            }
            this.arrowRenderer.paint(gc, null);
        }
    }
}

