/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rds;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public class RdsDeltaDetector {
    private static final Logger logger = LoggerFactory.getLogger(RdsDeltaDetector.class);
    ElementTree[] oldTrees;
    IDevice device;
    IProject project;
    String remotePath;
    String strResInfoFile = "";
    public static final String STR_TREE_FILE = ".sdk_delta.info";
    public static final String STR_TREE_DIRECTORY = "/info/";
    private static final String EMPTY_STRING = "";
    private static final String RDS_SEPARATOR = "/";
    private static final String TEMP_RESOURCE = ".temp";
    private static final int TREE_BUFFER_SIZE = 65536;
    List<String> deltaFilterDataList;
    private List<IProject> projects = new ArrayList<IProject>();
    private Map<String, ElementTree> projectTreeMap = new HashMap<String, ElementTree>();

    public RdsDeltaDetector(IDevice device, IProject project, String remotePath) {
        this.device = device;
        this.project = project;
        this.remotePath = remotePath;
        List<IProject> referencedProjects = ProjectUtil.getReferencedProjects(project);
        int size = referencedProjects.size();
        this.projects.add(project);
        if (size > 0) {
            this.projects.addAll(1, referencedProjects);
            this.oldTrees = new ElementTree[size + 1];
        } else {
            this.oldTrees = new ElementTree[1];
        }
    }

    /*
     * Exception decompiling
     */
    public boolean readOldTree() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasOldTree() {
        return this.oldTrees != null && this.oldTrees[0] != null;
    }

    private String downloadOldTree() {
        if (this.remotePath == null) {
            return null;
        }
        String deltaFileOnRemote = String.valueOf(this.remotePath) + STR_TREE_DIRECTORY + STR_TREE_FILE;
        String strLocalFile = this.project.getLocation().toString();
        SyncService service = null;
        try {
            try {
                service = this.device.getSyncService();
                SyncResult result = service.pull(this.device.getFileEntry(deltaFileOnRemote), strLocalFile);
                if (!result.isOk()) {
                    throw new Exception(result.getMessage());
                }
            }
            catch (Exception exception) {
                IOUtil.tryClose(service);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(service);
            throw throwable;
        }
        IOUtil.tryClose(service);
        return String.valueOf(strLocalFile) + RDS_SEPARATOR + STR_TREE_FILE;
    }

    public List<DeltaResourceInfo> getDelta() {
        String projectPath = EMPTY_STRING;
        if (this.oldTrees == null || this.oldTrees[0] == null) {
            return null;
        }
        ArrayList<DeltaResourceInfo> deltaInfoList = new ArrayList<DeltaResourceInfo>();
        int i = 0;
        while (i < this.oldTrees.length) {
            IProject currentProject = this.projects.get(i);
            String projectName = currentProject.getName();
            IPath subTreePath = currentProject.getFullPath();
            projectPath = currentProject.getLocation().toString();
            ElementTree tree = ((Workspace)currentProject.getWorkspace()).getElementTree().getSubtree(subTreePath);
            ResourceDelta result = ResourceDeltaFactory.computeDelta((Workspace)((Workspace)currentProject.getWorkspace()), (ElementTree)this.oldTrees[i], (ElementTree)tree, (IPath)currentProject.getFullPath(), (long)-1L);
            this.getDelta(deltaInfoList, (IResourceDelta)result, projectPath, projectName);
            ++i;
        }
        return deltaInfoList;
    }

    public List<DeltaResourceInfo> getDelta(IProject project) {
        String projectPath = project.getLocation().toString();
        IPath subTreePath = project.getFullPath();
        ElementTree tree = ((Workspace)project.getWorkspace()).getElementTree().getSubtree(subTreePath);
        ElementTree oldTree = this.projectTreeMap.get(project.getName());
        ResourceDelta result = ResourceDeltaFactory.computeDelta((Workspace)((Workspace)project.getWorkspace()), (ElementTree)oldTree, (ElementTree)tree, (IPath)project.getFullPath(), (long)-1L);
        return this.getDelta(new ArrayList<DeltaResourceInfo>(), (IResourceDelta)result, projectPath, project.getName());
    }

    private DeltaResourceInfo addDeltaInfo(List<DeltaResourceInfo> deltaInfoList, String nodeName, String deltaFullPath, String deltaType, int resourceType, String projectName, IResource res) {
        DeltaResourceInfo resourceInfo = new DeltaResourceInfo(nodeName, deltaFullPath, null, deltaType, resourceType, projectName, res);
        deltaInfoList.add(resourceInfo);
        return resourceInfo;
    }

    public String makeDeltaFile() {
        String strLocalFile;
        block12: {
            Workspace workspace = (Workspace)this.project.getWorkspace();
            ElementTreeWriter treeWriter = new ElementTreeWriter((IElementInfoFlattener)workspace.getSaveManager());
            strLocalFile = String.valueOf(this.project.getLocation().toString()) + RDS_SEPARATOR + STR_TREE_FILE;
            DataOutputStream output = null;
            try {
                try {
                    output = new DataOutputStream((OutputStream)new SafeFileOutputStream(strLocalFile, String.valueOf(strLocalFile) + TEMP_RESOURCE));
                    for (IProject currentProject : this.projects) {
                        ElementTree currentTree = workspace.getElementTree().getSubtree(currentProject.getFullPath());
                        IPath currentSubTreePath = currentProject.getFullPath();
                        treeWriter.writeTree(currentTree, currentSubTreePath, -1, (DataOutput)output);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IOUtil.tryClose(output);
                    try {
                        this.project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e2) {
                        logger.error("Failed to refresh project resources", (Throwable)e2);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(output);
                try {
                    this.project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    logger.error("Failed to refresh project resources", (Throwable)e);
                }
                throw throwable;
            }
            IOUtil.tryClose(output);
            try {
                this.project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                logger.error("Failed to refresh project resources", (Throwable)e);
            }
        }
        return strLocalFile;
    }

    public List<DeltaResourceInfo> getDelta(List<DeltaResourceInfo> deltaInfoList, IResourceDelta deltaNode, String strPath, String projectName) {
        String resourceName = EMPTY_STRING;
        int resourceType = 0;
        DeltaResourceInfo resourceInfo = null;
        IResource resource = null;
        String resourcePath = EMPTY_STRING;
        IResourceDelta[] iResourceDeltaArray = deltaNode.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            resource = resourceDelta.getResource();
            resourceName = resource.getName();
            resourceType = resource.getType();
            resourcePath = String.valueOf(strPath) + RDS_SEPARATOR + resourceName;
            switch (resourceDelta.getKind()) {
                case 1: 
                case 8: {
                    this.addDeltaInfo(deltaInfoList, resourceName, resourcePath, "add", resourceType, projectName, resource);
                    this.getDelta(deltaInfoList, resourceDelta, resourcePath, projectName);
                    break;
                }
                case 4: {
                    if (2 == resourceType) {
                        this.getDelta(deltaInfoList, resourceDelta, resourcePath, projectName);
                        break;
                    }
                    if (1 != resourceType) break;
                    this.addDeltaInfo(deltaInfoList, resourceName, resourcePath, "modify", resourceType, projectName, resource);
                    break;
                }
                case 2: 
                case 16: {
                    resourceInfo = this.addDeltaInfo(deltaInfoList, resourceName, resourcePath, "delete", resourceType, projectName, resource);
                    if (2 != resourceType) break;
                    this.getDelta(resourceInfo.getChildren(), resourceDelta, resourcePath, projectName);
                    break;
                }
            }
            ++n2;
        }
        return deltaInfoList;
    }

    public List<IProject> getProjects() {
        return this.projects;
    }

    public Map<String, ElementTree> getProjectTreeMap() {
        return this.projectTreeMap;
    }
}

