/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.internal.core.index.IWritableIndex;

public class YieldableIndexLock {
    private final IWritableIndex index;
    private final int readlockCount;
    private final boolean flushIndex;
    private long lastLockTime;
    private long cumulativeLockTime;

    public YieldableIndexLock(IWritableIndex index, int readlockCount, boolean flushIndex) {
        this.index = index;
        this.readlockCount = readlockCount;
        this.flushIndex = flushIndex;
    }

    public void acquire() throws InterruptedException {
        this.index.acquireWriteLock(this.readlockCount);
        this.lastLockTime = System.currentTimeMillis();
    }

    public void release() {
        if (this.lastLockTime != 0L) {
            this.index.releaseWriteLock(this.readlockCount, this.flushIndex);
            this.cumulativeLockTime += System.currentTimeMillis() - this.lastLockTime;
            this.lastLockTime = 0L;
        }
    }

    public void yield() throws InterruptedException {
        if (this.index.hasWaitingReaders()) {
            this.index.releaseWriteLock(this.readlockCount, false);
            this.cumulativeLockTime += System.currentTimeMillis() - this.lastLockTime;
            this.lastLockTime = 0L;
            this.acquire();
        }
    }

    public long getCumulativeLockTime() {
        return this.cumulativeLockTime;
    }
}

