/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.commands;

import java.util.Map;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.commands.Command;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IDevice;

public final class AppsCommand
extends Command {
    public AppsCommand() {
        super("apps", 1, "show list of applications of specified target", "<ip:port|serial>");
    }

    private void printApps(Map<String, PackageInfo> packages) {
        String APP_NAME_HEADER = "<Application Name>";
        String APP_PACKAGE_HEADER = "<Package Name>";
        int maxPackageId = "<Package Name>".length();
        for (Map.Entry<String, PackageInfo> entry : packages.entrySet()) {
            int len = entry.getValue().getPackageId().length();
            if (len <= maxPackageId) continue;
            maxPackageId = len;
        }
        String format = String.format("  %%-%ds : %%s%n", maxPackageId);
        System.out.println("List of installed applications:");
        System.out.format(format, "<Package Name>", "<Application Name>");
        for (Map.Entry<String, PackageInfo> entry : packages.entrySet()) {
            for (AppInfo info : entry.getValue().getAppInfos()) {
                System.out.format(format, info.getPackageID(), info.getLabel());
            }
        }
    }

    @Override
    public ExitCode processCommand(String[] args) {
        IDevice dev;
        if (args[0] == null) {
            Logger.warning((Object)"Empty target name");
            return ExitCode.EX_ARGUMENTS_ERROR;
        }
        IDevice iDevice = dev = CliInternals.isIp(args[0]) ? CliInternals.getDeviceByIp(args[0]) : CliInternals.getDeviceBySerial(args[0]);
        if (dev == null) {
            Logger.warning((String)"Target %s is not found", (Object[])new Object[]{args[0]});
            return ExitCode.EX_OPERATION_FAILED;
        }
        Map<String, PackageInfo> packages = CliInternals.getPackageList(dev);
        if (packages != null) {
            this.printApps(packages);
        }
        return ExitCode.EX_SUCCESS;
    }
}

