/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionSequence
extends Sequence {
    public static final String GROUP_TOP_LEVEL = "GROUP_TOP_LEVEL";
    private Sequence.Step[] fReflectionSteps;

    public ReflectionSequence(DsfExecutor executor) {
        super(executor);
    }

    public ReflectionSequence(DsfExecutor executor, RequestMonitor rm) {
        super(executor, rm);
    }

    public ReflectionSequence(DsfExecutor executor, IProgressMonitor pm, String taskName, String rollbackTaskName) {
        super(executor, pm, taskName, rollbackTaskName);
    }

    public ReflectionSequence(DsfExecutor executor, RequestMonitorWithProgress rm, String taskName, String rollbackTaskName) {
        super(executor, rm, taskName, rollbackTaskName);
    }

    protected abstract String[] getExecutionOrder(String var1);

    @Override
    public Sequence.Step[] getSteps() {
        if (this.fReflectionSteps == null) {
            Map<String, Method> executeMethods = this.getAnnotatedMethods(Execute.class);
            Map<String, Method> rollBackMethods = this.getAnnotatedMethods(RollBack.class);
            List<Sequence.Step> steps = this.getGroupSteps(GROUP_TOP_LEVEL, executeMethods, rollBackMethods);
            this.fReflectionSteps = steps.toArray(new ReflectionStep[steps.size()]);
        }
        return this.fReflectionSteps;
    }

    private List<Sequence.Step> getGroupSteps(String groupId, Map<String, Method> executeMethods, Map<String, Method> rollBackMethods) {
        ArrayList<Sequence.Step> steps = new ArrayList<Sequence.Step>(executeMethods.size());
        String[] order = this.getExecutionOrder(groupId);
        if (order == null) {
            throw new RuntimeException("Unknown group in sequence: " + groupId);
        }
        String[] stringArray = order;
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Method executeMethod = executeMethods.get(name);
            if (executeMethod == null) {
                steps.addAll(this.getGroupSteps(name, executeMethods, rollBackMethods));
            } else {
                steps.add(new ReflectionStep(executeMethod, rollBackMethods.get(executeMethod.getName())));
            }
            ++n2;
        }
        return steps;
    }

    private Map<String, Method> getAnnotatedMethods(Class<? extends Annotation> annotationType) {
        HashMap<String, Method> retVal = new HashMap<String, Method>();
        try {
            Method[] methods;
            Method[] methodArray = methods = this.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(annotationType)) {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) {
                        throw new IllegalArgumentException("Method " + method.getDeclaringClass().getSimpleName() + "#" + method.getName() + " must have a single parameter");
                    }
                    if (annotationType.equals(Execute.class)) {
                        retVal.put(method.getName(), method);
                    } else {
                        retVal.put(method.getAnnotation(RollBack.class).value(), method);
                    }
                }
                ++n2;
            }
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("No permission to access ReflectionSequence method");
        }
        return retVal;
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Execute {
    }

    private class ReflectionStep
    extends Sequence.Step {
        private final Method fExecuteMethod;
        private final Method fRollbackMethod;

        private ReflectionStep(Method executeMethod, Method rollbackMethod) {
            assert (executeMethod != null);
            this.fExecuteMethod = executeMethod;
            this.fRollbackMethod = rollbackMethod;
        }

        public void execute(RequestMonitor rm) {
            try {
                this.fExecuteMethod.invoke((Object)ReflectionSequence.this, rm);
            }
            catch (Exception e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Error executing step execute method: " + this.fExecuteMethod.getName(), (Throwable)e));
                rm.done();
            }
        }

        public void rollBack(RequestMonitor rm) {
            if (this.fRollbackMethod == null) {
                super.rollBack(rm);
            } else {
                try {
                    this.fRollbackMethod.invoke((Object)ReflectionSequence.this, rm);
                }
                catch (Exception e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Error executing step rollback method: " + this.fRollbackMethod.getName(), (Throwable)e));
                    rm.done();
                }
            }
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface RollBack {
        public String value();
    }
}

