/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.handlers;

import java.io.File;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.control.StartTraceManager;
import org.tizen.dynamicanalyzer.control.StopTraceManager;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.ZipUtils;

public class CommandAction {
    public static boolean save(String saveFileName) {
        Project project = Global.getProject();
        String sourcePath = project.getSavePath();
        String targetPath = String.valueOf(PathManager.DA_SAVE_PATH) + File.separator + saveFileName;
        project.save();
        DataManagerRegistry.saveData();
        SqlConnectionManager.closeConnection();
        File sourceFolder = new File(sourcePath);
        if (!sourceFolder.isDirectory() && !sourceFolder.mkdirs()) {
            Logger.debug((Object)"source directory create failed...");
            return false;
        }
        File targetFolder = new File(targetPath);
        if (!targetFolder.isDirectory() && !targetFolder.mkdirs()) {
            Logger.debug((Object)"target directory create failed...");
            return false;
        }
        AnalyzerUtil.copyDirectory(sourceFolder, targetFolder);
        project.setSavePath(targetPath);
        boolean success = AnalyzerUtil.deleteFile(new File(sourcePath));
        if (success) {
            Logger.debug((Object)"save complete!!");
        } else {
            Logger.debug((Object)"save fail...");
        }
        SqlConnectionManager.establishConnection(String.valueOf(project.getSavePath()) + File.separator + "da.trace");
        return success;
    }

    public static boolean saveToZip(String saveFileName) {
        Project project = Global.getProject();
        String sourcePath = project.getSavePath();
        project.save();
        DataManagerRegistry.saveData();
        SqlConnectionManager.closeConnection();
        File sourceFolder = new File(sourcePath);
        if (!sourceFolder.isDirectory()) {
            return false;
        }
        try {
            ZipUtils.zip(sourcePath, saveFileName);
        }
        catch (Exception exception) {
            return false;
        }
        SqlConnectionManager.establishConnection(String.valueOf(sourcePath) + File.separator + "da.trace");
        return true;
    }

    public static String loadFromZip(String zipfile) {
        String output = null;
        File zip = new File(zipfile);
        if (!zip.getName().toLowerCase().endsWith(".zip")) {
            return null;
        }
        File tempDir = new File(PathManager.DA_TEMP_FOLDER_PATH);
        output = String.valueOf(tempDir.getPath()) + File.separator + zip.getName().replace(".zip", "") + System.currentTimeMillis();
        File outputfoler = new File(output);
        if (outputfoler.exists()) {
            if (AnalyzerUtil.deleteFile(outputfoler)) {
                Logger.debug((Object)"Delete folder!");
            } else {
                Logger.debug((Object)"Delete folder fail...");
            }
        }
        outputfoler.mkdirs();
        try {
            ZipUtils.unzip(zip, outputfoler, false);
        }
        catch (Exception exception) {
            return null;
        }
        return output;
    }

    public static void startTrace(boolean bFromIDE) {
        boolean stateChange = DAState.changeCurrentState(DAState.PREPARE_START);
        if (!stateChange) {
            Logger.warning((Object)"Try to start trace though trace is not stopped completely");
            return;
        }
        if (Global.isGUIMode()) {
            CommandAction.updateUiOnStartTrace(bFromIDE);
        }
        Thread thread = new Thread(new StartTraceManager());
        thread.start();
    }

    private static void updateUiOnStartTrace(boolean bFromIDE) {
        Toolbar.INSTANCE.resetProcessCombo();
        Toolbar.INSTANCE.changeUIState(DAState.PREPARE_START);
        ShortCutManager.getInstance().setEnabled(false);
        if (!bFromIDE) {
            InteractiveDataManager.getInstance().clear();
        }
    }

    public static void stopTrace(DAResult error, boolean stopFromTarget) {
        boolean stateChange = DAState.changeCurrentState(DAState.PREPARE_STOP);
        if (!stateChange) {
            Logger.debug((Object)"Try to stop trace though trace is not running");
            return;
        }
        if (Global.isGUIMode()) {
            CommandAction.updateUiOnStopTrace();
        }
        Thread thread = new Thread(new StopTraceManager(error, stopFromTarget));
        thread.start();
    }

    private static void updateUiOnStopTrace() {
        Toolbar.INSTANCE.changeUIState(DAState.PREPARE_STOP);
        ShortCutManager.getInstance().setEnabled(false);
        Global.getProject().setReplayStopTime(Toolbar.INSTANCE.getTime());
    }
}

