/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.listeners;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerConstants;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.communicator.IDECommunicator;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;

public class TableTooltipListener
implements Listener {
    private Grid grid = null;
    private GridItem oldItem = null;
    private Shell tooltip;
    private boolean enabled = true;
    private boolean onViewSourceFromContext = false;
    private static final int MARGIN = 5;
    private static final int SPACING = 0;
    private static final int SOURCE_LINE_TOP = 5;
    private static final int SOURCE_LINE_BOTTOM = 11;
    private static final int TOOLTIP_OFFSET = 5;
    private static final Cursor sourceCursor = new Cursor(null, ImageResources.VIEW_SOURCE_CURSOR.getImageData(), 0, 0);
    private static Cursor defaultCursor = null;

    public TableTooltipListener(Grid table) {
        this.grid = table;
        defaultCursor = this.grid.getCursor();
    }

    public void handleEvent(Event event) {
        if (!Toolbar.INSTANCE.getButtonEnabled(4)) {
            return;
        }
        int columnHeight = this.grid.getHeaderHeight();
        boolean isHeader = false;
        if (event.y < columnHeight) {
            isHeader = true;
        }
        boolean isToggled = MenuBar.getInstance().getSourceView();
        if (this.enabled && !isHeader) {
            this.setViewCursor(isToggled);
        }
        switch (event.type) {
            case 12: {
                this.disposeTooltip();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.setViewCursor(isToggled);
                break;
            }
            case 6: {
                if (!isToggled || !this.enabled || this.onViewSourceFromContext) break;
                GridItem item = this.grid.getItem(new Point(event.x, event.y));
                SymbolManager.SourceLine sl = this.getCallerSourceLine(item);
                this.viewSource(event.x, event.y, sl, false);
                break;
            }
            case 7: {
                if (this.onViewSourceFromContext) break;
                this.disposeTooltip();
                break;
            }
            case 5: {
                if (this.onViewSourceFromContext) break;
                GridItem gridItem = this.grid.getItem(new Point(event.x, event.y));
                if (this.oldItem == null) {
                    this.oldItem = gridItem;
                }
                if (this.tooltip == null) break;
                if (gridItem != null) {
                    if (!gridItem.equals(this.oldItem)) {
                        this.oldItem = gridItem;
                    } else {
                        return;
                    }
                }
                this.tooltip.dispose();
                this.tooltip = null;
                break;
            }
            case 8: {
                if (!isToggled || !this.enabled) break;
                GridItem item = this.grid.getItem(new Point(event.x, event.y));
                SymbolManager.SourceLine sl = this.getCallerSourceLine(item);
                this.openIDE(sl, item);
                break;
            }
            case 32: {
                if (!isToggled || !this.enabled || this.onViewSourceFromContext) break;
                GridItem item = this.grid.getItem(new Point(event.x, event.y));
                SymbolManager.SourceLine sl = this.getCallerSourceLine(item);
                this.viewSource(event.x, event.y, sl, false);
                break;
            }
        }
    }

    public void setEnable(boolean enabled) {
        this.enabled = enabled;
    }

    public SymbolManager.SourceLine getCallerSourceLine(GridItem item) {
        if (item == null) {
            return null;
        }
        DATableDataFormat tableData = (DATableDataFormat)item.getData();
        LogData data = null;
        long addr = -1L;
        int pid = -1;
        long time = 0L;
        switch (tableData.getType()) {
            case 1: {
                addr = (Long)item.getData("address");
                pid = (Integer)item.getData("pid");
                time = (Long)item.getData("time");
                break;
            }
            case 4100: {
                addr = (Long)item.getData("caller address");
                pid = (Integer)item.getData("pid");
                time = (Long)item.getData("time");
                break;
            }
            case 2: {
                List<Object> failedData = tableData.getData();
                addr = (Long)failedData.get(8);
                pid = (Integer)failedData.get(7);
                time = (Long)failedData.get(1);
                break;
            }
            case 4: {
                List<Object> leakData = tableData.getData();
                addr = (Long)leakData.get(9);
                pid = (Integer)leakData.get(2);
                time = (Long)leakData.get(4);
                break;
            }
            case 8: {
                data = tableData.getLogData();
                ProbeCommonData pData = (ProbeCommonData)data;
                addr = pData.getCallerPcAddr();
                pid = data.getPid();
                time = data.getTime();
                break;
            }
            case 32: {
                List<Object> calltraceData = tableData.getData();
                addr = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.CALLER_PC_ADDRESS.index);
                pid = (Integer)calltraceData.get(FunctionEntryDBTable.COLUMN.PID.index);
                time = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
                break;
            }
            case 256: 
            case 512: 
            case 1024: {
                return null;
            }
            default: {
                data = tableData.getLogData();
                ProbeCommonData wData = (ProbeCommonData)data;
                addr = wData.getCallerPcAddr();
                pid = data.getPid();
                time = data.getTime();
            }
        }
        return this.getSourceLine(addr, pid, time);
    }

    public SymbolManager.SourceLine getDefinitionSourceLine(GridItem item) {
        if (item == null) {
            return null;
        }
        DATableDataFormat tableData = (DATableDataFormat)item.getData();
        long addr = -1L;
        int pid = -1;
        long time = 0L;
        switch (tableData.getType()) {
            case 32: {
                List<Object> calltraceData = tableData.getData();
                addr = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.START_PC_ADDRESS.index);
                pid = (Integer)calltraceData.get(FunctionEntryDBTable.COLUMN.PID.index);
                time = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
                break;
            }
            case 4100: {
                addr = (Long)item.getData("start address");
                pid = (Integer)item.getData("pid");
                time = (Long)item.getData("time");
                break;
            }
        }
        return this.getSourceLine(addr, pid, time);
    }

    public void viewSource(int x, int y, SymbolManager.SourceLine sl, boolean onViewSourceFromContext) {
        if (sl == null) {
            Logger.warning((Object)"Input SourceLine is null.");
            return;
        }
        this.onViewSourceFromContext = onViewSourceFromContext;
        GridItem item = this.grid.getItem(new Point(x, y));
        if (item != null) {
            StringBuilder bottomStr;
            StringBuilder centerStr;
            StringBuilder topStr;
            Label bottom;
            Label center;
            Label top;
            block18: {
                this.disposeTooltip();
                if (sl.getError() != 0) {
                    this.createErrorTooltip(x, y, sl.getError());
                    return;
                }
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                Display display = shell.getDisplay();
                display.addFilter(16, new Listener(){

                    public void handleEvent(Event event) {
                        TableTooltipListener.this.disposeTooltip();
                    }
                });
                display.addFilter(3, new Listener(){

                    public void handleEvent(Event event) {
                        TableTooltipListener.this.disposeTooltip();
                    }
                });
                this.tooltip = new Shell(shell, 540676);
                this.tooltip.setBackground(ColorResources.TOOLTIP);
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginTop = 5;
                gridLayout.marginBottom = 5;
                gridLayout.marginLeft = 5;
                gridLayout.marginRight = 5;
                gridLayout.verticalSpacing = 0;
                this.tooltip.setLayout((Layout)gridLayout);
                Label title = new Label((Composite)this.tooltip, 0);
                title.setFont(FontResources.TOOLTIP);
                title.setForeground(ColorResources.BLACK);
                title.setBackground(ColorResources.TOOLTIP);
                String filePath = this.getSourcePath(item, sl);
                int line = sl.getLineNumber();
                title.setText(String.valueOf(filePath) + " " + " " + "\n");
                top = new Label((Composite)this.tooltip, 0);
                top.setForeground(ColorResources.BLACK);
                top.setBackground(ColorResources.TOOLTIP);
                center = new Label((Composite)this.tooltip, 0);
                center.setForeground(ColorResources.RED);
                center.setBackground(ColorResources.TOOLTIP);
                bottom = new Label((Composite)this.tooltip, 0);
                bottom.setForeground(ColorResources.BLACK);
                bottom.setBackground(ColorResources.TOOLTIP);
                BufferedReader reader = null;
                topStr = new StringBuilder("");
                centerStr = new StringBuilder("");
                bottomStr = new StringBuilder("");
                try {
                    reader = new BufferedReader(new FileReader(filePath));
                    int topStart = line - 5;
                    if (topStart - 1 < 0) {
                        topStart = 1;
                    }
                    int topEnd = line;
                    int bottomStart = line + 1;
                    int bottomEnd = line + 11;
                    int i = 0;
                    while (i < topStart - 1) {
                        reader.readLine();
                        ++i;
                    }
                    String temp = null;
                    int i2 = topStart;
                    while (i2 < topEnd) {
                        temp = reader.readLine();
                        if (temp == null) break;
                        topStr.append(String.valueOf(i2) + "\t" + temp);
                        if (i2 != topEnd - 1) {
                            topStr.append("\n");
                        }
                        ++i2;
                    }
                    if ((temp = reader.readLine()) != null) {
                        centerStr.append(String.valueOf(line) + "\t" + temp);
                    }
                    i2 = bottomStart;
                    while (i2 < bottomEnd) {
                        temp = reader.readLine();
                        if (temp != null) {
                            bottomStr.append(String.valueOf(i2) + "\t" + temp);
                            if (i2 != bottomEnd - 1) {
                                bottomStr.append("\n");
                            }
                            ++i2;
                            continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.createErrorTooltip(x, y, 10);
                    CommonUtil.tryClose((Object[])new Object[]{reader});
                    break block18;
                }
                catch (IOException e) {
                    try {
                        Logger.exception((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CommonUtil.tryClose((Object[])new Object[]{reader});
                        throw throwable;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{reader});
                    break block18;
                }
                CommonUtil.tryClose((Object[])new Object[]{reader});
            }
            top.setText(topStr.toString());
            center.setText(centerStr.toString());
            bottom.setText(bottomStr.toString());
            this.tooltipShow(x, y);
        }
    }

    public void openIDE(SymbolManager.SourceLine sl, GridItem gridItem) {
        if (gridItem == null || sl == null || !sl.isValid()) {
            return;
        }
        if (!IDECommunicator.isConnected()) {
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.IDE_NOT_LAUNCHED);
            return;
        }
        String filePath = this.getSourcePath(gridItem, sl);
        int lineNum = sl.getLineNumber();
        IDECommunicator.sendCodeInfoToIDE(filePath, Integer.toString(lineNum));
    }

    private void setViewCursor(boolean toggled) {
        if (!toggled) {
            this.grid.setCursor(null);
        } else {
            this.grid.setCursor(sourceCursor);
        }
    }

    private void createErrorTooltip(int x, int y, int errno) {
        Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
        this.tooltip = new Shell(shell, 540676);
        this.tooltip.setBackground(ColorResources.TOOLTIP);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 5;
        gridLayout.marginBottom = 5;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        gridLayout.verticalSpacing = 0;
        this.tooltip.setLayout((Layout)gridLayout);
        Label title = new Label((Composite)this.tooltip, 0);
        title.setForeground(ColorResources.BLACK);
        title.setBackground(ColorResources.TOOLTIP);
        String text = AnalyzerConstants.sourcelineErrorMsg[errno];
        title.setText(text);
        this.tooltipShow(x, y);
    }

    private String getSourcePath(GridItem item, SymbolManager.SourceLine sourceLine) {
        String filePath = null;
        String libName = this.getLibPath(item);
        BinarySettingData binData = BinarySettingManager.getInstance().getBinarySetting(libName);
        if (binData != null) {
            if (binData.getUserSourceDir() != null && !binData.getUserSourceDir().isEmpty()) {
                String fileName = this.getSourceFilePath(sourceLine.getFilePath());
                filePath = String.valueOf(binData.getUserSourceDir()) + File.separator + fileName;
            } else {
                filePath = String.valueOf(binData.getRpmSourceDir()) + sourceLine.getFilePath();
            }
        } else {
            String sourcePath;
            AppInfo appInfo = Global.getProject().getApplicationInfo();
            BinaryInfo binfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(appInfo.getExecBinaryPath());
            filePath = binfo.getTargetBinaryPath().equals(libName) && appInfo.getAppType().contains("capp") ? ((sourcePath = appInfo.getSourcePath()) != null && !sourcePath.isEmpty() ? String.valueOf(appInfo.getSourcePath()) + sourceLine.getFilePath() : sourceLine.getFilePath()) : sourceLine.getFilePath();
        }
        return filePath;
    }

    private String getSourceFilePath(String sourcePath) {
        String separator = "src" + File.separator;
        int index = sourcePath.lastIndexOf(separator);
        String filePath = sourcePath.substring(index + 4, sourcePath.length());
        return filePath;
    }

    private void tooltipShow(int x, int y) {
        Point size = this.tooltip.computeSize(-1, -1);
        Point pt = this.grid.toDisplay(x, y);
        Rectangle displayRect = Display.getCurrent().getBounds();
        pt.x = pt.x + size.x > displayRect.width ? pt.x - size.x - 5 : pt.x + 5;
        pt.y = pt.y + size.y > displayRect.height ? pt.y - size.y - 5 : pt.y + 5;
        int startX = pt.x > 5 ? pt.x : 5;
        this.tooltip.setBounds(startX, pt.y, size.x, size.y);
        this.tooltip.setVisible(true);
    }

    private void disposeTooltip() {
        if (this.tooltip != null && !this.tooltip.isDisposed()) {
            this.tooltip.dispose();
            this.tooltip = null;
            this.onViewSourceFromContext = false;
        }
    }

    private String getLibPath(GridItem item) {
        DATableDataFormat tableData = (DATableDataFormat)item.getData();
        String libName = null;
        switch (tableData.getType()) {
            case 1: {
                libName = item.getText(2);
                break;
            }
            case 2: {
                List<Object> failedData = tableData.getData();
                libName = (String)failedData.get(9);
                break;
            }
            case 4: {
                List<Object> leakData = tableData.getData();
                libName = (String)leakData.get(7);
                break;
            }
            case 8: {
                ProbeCommonData pData = (ProbeCommonData)tableData.getLogData();
                libName = pData.getLibName();
                break;
            }
            case 32: {
                List<Object> calltraceData = tableData.getData();
                int binaryId = (Integer)calltraceData.get(FunctionEntryDBTable.COLUMN.BINARY_ID.index);
                BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(binaryId);
                libName = binInfo.getTargetBinaryPath();
                break;
            }
            case 4100: {
                libName = (String)item.getData("libName");
                break;
            }
            default: {
                ProbeCommonData wData = (ProbeCommonData)tableData.getLogData();
                libName = wData.getLibName();
            }
        }
        return libName;
    }

    private SymbolManager.SourceLine getSourceLine(long addr, int pid, long time) {
        Project project = Global.getProject();
        ProcessInformation process = project.getProcessInformation(pid);
        ProcessMemoryMap pmap = process.getProcessMemoryMap(time);
        LibraryObject libobj = null;
        if (pmap == null || (libobj = pmap.getLibraryByAddress(addr)) == null) {
            SymbolManager.SourceLine sl = new SymbolManager.SourceLine();
            sl.setError(8);
            return sl;
        }
        BinaryInfo binInfo = project.getDeviceStatusInfo().getBinaryInfo(libobj.getBinaryID());
        boolean isPieBuild = binInfo.getType() == 1;
        String baseAddr = null;
        String path = null;
        baseAddr = Long.toString(libobj.getLowestAddress());
        BinarySettingData binData = BinarySettingManager.getInstance().getBinarySetting(binInfo.getTargetBinaryPath());
        if (binData != null) {
            String debugPath = binData.getDebugFilePath();
            path = debugPath != null && !debugPath.isEmpty() ? debugPath : binInfo.getTempBinaryPath();
        } else {
            String debugPath;
            AppInfo appInfo = Global.getProject().getApplicationInfo();
            BinaryInfo binfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(appInfo.getExecBinaryPath());
            path = binInfo.getID() == binfo.getID() && appInfo.getAppType().contains("capp") ? ((debugPath = appInfo.getDebugFilePath()) != null && !debugPath.isEmpty() ? debugPath : binInfo.getTempBinaryPath()) : binInfo.getTempBinaryPath();
        }
        SymbolManager.SourceLine sl = SymbolManager.addr2line(path, addr, isPieBuild, baseAddr);
        return sl;
    }
}

