/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol.p30;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.protocol.IProtocolConfig;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.util.ByteUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public enum ProtocolConfig30 implements IProtocolConfig
{
    RESERVED1(0, 0, 0, null),
    RESERVED2(1, 0, 0, null),
    FUNCTION_PROFILING(2, 36, 5000, null),
    MEMORY_ALLOC_PROBE(3, 40, 623, null),
    FILE_API_PROBE(4, 26, 918, null),
    THREAD_API_PROBE(5, 0, 106, null),
    OSPUI_API_PROBE(6, 0, 0, null),
    SCREENSHOT(7, 62, 10, null),
    USER_EVENT(8, 0, 45, null),
    RECORDING(9, 996, 17, null),
    SYSCALL_FILE(10, 14, 0, null),
    SYSCALL_IPC(11, 14, 0, null),
    SYSCALL_PROCESS(12, 14, 0, null),
    SYSCALL_SIGNAL(13, 14, 0, null),
    SYSCALL_NETWORK(14, 14, 0, null),
    SYSCALL_DESC(15, 14, 0, null),
    CONTEXT_SWITCH(16, 14, 0, null),
    NETWORK_API_PROBE(17, 38, 10021, null),
    OPENGL_API_PROBE(18, 16, 50000, null),
    FUNCTION_SAMPLING(19, 68, 0, Feature.FUNCTION_SAMPLING_RATE),
    INTERNAL_MEMORY_ALLOC(28, 40, 0, null),
    INTERNAL_FILE_API(29, 26, 0, null),
    INTERNAL_THREAD_API(30, 0, 0, null),
    INTERNAL_OSPUI_API(31, 0, 0, null),
    INTERNAL_NETWORK_API(32, 38, 0, null),
    INTERNAL_OPENGL_API(33, 16, 0, null),
    SYSTEM_CPU(36, 2438, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_MEMORY(37, 2282, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_PROCESS(38, 2568, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_THREAD_LOAD(39, 2344, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_PROCESSES_LOAD(40, 2504, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_DISK(41, 1222, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_NETWORK(42, 162, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_DEVICE(43, 756, 0, Feature.SYSTEM_SAMPLING_RATE),
    SYSTEM_ENERGY(44, 452, 0, Feature.SYSTEM_SAMPLING_RATE);

    private static final Map<Feature, IProtocolConfig[]> featureProtocolMap;
    private static final Map<FlatFeature, IProtocolConfig[]> flatFeatureProtocolMap;
    private static final Map<FlatPreferences, IProtocolConfig[]> preferencesProtocolMap;
    private int bitShift;
    private int overheadValue;
    private int callCount;
    private Feature featureForFrequency;

    static {
        EnumMap<Enum, ProtocolConfig30[]> tempMap = new EnumMap<Feature, ProtocolConfig30[]>(Feature.class);
        tempMap.put(Feature.SYSTEM_CPU, new ProtocolConfig30[]{SYSTEM_CPU});
        tempMap.put(Feature.SYSTEM_PROCESS, new ProtocolConfig30[]{SYSTEM_PROCESS});
        tempMap.put(Feature.SYSTEM_MEMORY, new ProtocolConfig30[]{SYSTEM_MEMORY});
        tempMap.put(Feature.SYSTEM_ALL_PROCESSES, new ProtocolConfig30[]{SYSTEM_PROCESSES_LOAD});
        tempMap.put(Feature.SYSTEM_DISK, new ProtocolConfig30[]{SYSTEM_DISK});
        tempMap.put(Feature.SYSTEM_NETWORK, new ProtocolConfig30[]{SYSTEM_NETWORK});
        tempMap.put(Feature.SYSTEM_DEVICE, new ProtocolConfig30[]{SYSTEM_DEVICE});
        tempMap.put(Feature.SYSTEM_ENERGY, new ProtocolConfig30[]{SYSTEM_ENERGY});
        tempMap.put(Feature.FUNCTION_PROFILING, new ProtocolConfig30[]{FUNCTION_PROFILING});
        tempMap.put(Feature.FUNCTION_SAMPLING, new ProtocolConfig30[]{FUNCTION_SAMPLING});
        tempMap.put(Feature.MEMORY_ALLOCATION, new ProtocolConfig30[]{MEMORY_ALLOC_PROBE});
        tempMap.put(Feature.FILE_ANALYSIS, new ProtocolConfig30[]{FILE_API_PROBE, SYSCALL_FILE});
        tempMap.put(Feature.THREAD_ANALYSIS, new ProtocolConfig30[]{THREAD_API_PROBE, SYSTEM_THREAD_LOAD});
        tempMap.put(Feature.NETWORK_ANALYSIS, new ProtocolConfig30[]{NETWORK_API_PROBE});
        tempMap.put(Feature.OPENGL_ANALYSIS, new ProtocolConfig30[]{OPENGL_API_PROBE});
        tempMap.put(Feature.UI_EVENT_ANALYSIS, new ProtocolConfig30[]{USER_EVENT});
        tempMap.put(Feature.CONTEXT_SWITCH_ANALYSIS, new ProtocolConfig30[]{CONTEXT_SWITCH});
        tempMap.put(Feature.INTERNAL_PROBE_MEMORY, new ProtocolConfig30[]{INTERNAL_MEMORY_ALLOC});
        tempMap.put(Feature.INTERNAL_PROBE_FILE, new ProtocolConfig30[]{INTERNAL_FILE_API});
        tempMap.put(Feature.INTERNAL_PROBE_THREAD, new ProtocolConfig30[]{INTERNAL_THREAD_API});
        tempMap.put(Feature.INTERNAL_PROBE_NETWORK, new ProtocolConfig30[]{INTERNAL_NETWORK_API});
        tempMap.put(Feature.INTERNAL_PROBE_OPENGL, new ProtocolConfig30[]{INTERNAL_OPENGL_API});
        tempMap.put(Feature.SYSCALL_FILE, new ProtocolConfig30[]{SYSCALL_FILE});
        tempMap.put(Feature.SYSCALL_IPC, new ProtocolConfig30[]{SYSCALL_IPC});
        tempMap.put(Feature.SYSCALL_PROCESS, new ProtocolConfig30[]{SYSCALL_PROCESS});
        tempMap.put(Feature.SYSCALL_SIGNAL, new ProtocolConfig30[]{SYSCALL_SIGNAL});
        tempMap.put(Feature.SYSCALL_NETWORK, new ProtocolConfig30[]{SYSCALL_NETWORK});
        tempMap.put(Feature.SYSCALL_DESC, new ProtocolConfig30[]{SYSCALL_DESC});
        tempMap.put(Feature.SCREENSHOT_ON_SCENE_TRANSITION, new ProtocolConfig30[]{SCREENSHOT});
        tempMap.put(Feature.RECORDING, new ProtocolConfig30[]{RECORDING});
        featureProtocolMap = Collections.unmodifiableMap(tempMap);
        tempMap = new EnumMap(FlatFeature.class);
        tempMap.put((Feature)((Object)FlatFeature.CPU_USAGE), new ProtocolConfig30[]{SYSTEM_CPU});
        tempMap.put(FlatFeature.SYSTEM_MEMORY, new ProtocolConfig30[]{SYSTEM_MEMORY});
        tempMap.put(FlatFeature.PROCESS_MEMORY, new ProtocolConfig30[]{SYSTEM_PROCESS});
        tempMap.put(FlatFeature.MEMORY_ALLOC, new ProtocolConfig30[]{INTERNAL_MEMORY_ALLOC});
        tempMap.put(FlatFeature.DISK_IO, new ProtocolConfig30[]{SYSTEM_DISK});
        tempMap.put(FlatFeature.FILE_ANALYSIS, new ProtocolConfig30[]{FILE_API_PROBE, SYSCALL_FILE});
        tempMap.put(FlatFeature.OPENGLES_ANALYSIS, new ProtocolConfig30[]{OPENGL_API_PROBE});
        tempMap.put(FlatFeature.NETWORK_IO, new ProtocolConfig30[]{SYSTEM_NETWORK});
        tempMap.put(FlatFeature.NETWORK_ANALYSIS, new ProtocolConfig30[]{NETWORK_API_PROBE});
        tempMap.put(FlatFeature.UI_EVENT, new ProtocolConfig30[]{USER_EVENT});
        tempMap.put(FlatFeature.THREAD_ANALYSIS, new ProtocolConfig30[]{THREAD_API_PROBE, SYSTEM_THREAD_LOAD});
        tempMap.put(FlatFeature.PERIPHERAL_STATUS, new ProtocolConfig30[]{SYSTEM_DEVICE});
        tempMap.put(FlatFeature.POWER_ESTIMATION, new ProtocolConfig30[]{SYSTEM_ENERGY});
        flatFeatureProtocolMap = Collections.unmodifiableMap(tempMap);
        tempMap = new EnumMap(FlatPreferences.class);
        tempMap.put(FlatPreferences.RECORDING, new ProtocolConfig30[]{RECORDING});
        tempMap.put(FlatPreferences.FUNCTION_PROFILING, new ProtocolConfig30[]{FUNCTION_PROFILING});
        tempMap.put(FlatPreferences.FUNCTION_SAMPLING_RATE, new ProtocolConfig30[]{FUNCTION_SAMPLING});
        tempMap.put(FlatPreferences.SYSTEM_ALL_PROCESSES, new ProtocolConfig30[]{SYSTEM_PROCESSES_LOAD});
        tempMap.put(FlatPreferences.PROCESS_MEMORY, new ProtocolConfig30[]{SYSTEM_PROCESS});
        tempMap.put(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION, new ProtocolConfig30[]{SCREENSHOT});
        preferencesProtocolMap = Collections.unmodifiableMap(tempMap);
    }

    private ProtocolConfig30(int bitshift, int overhead, int callcount, Feature frequency) {
        this.bitShift = bitshift;
        this.overheadValue = overhead;
        this.callCount = callcount;
        this.featureForFrequency = frequency;
    }

    @Override
    public int getShift() {
        return this.bitShift;
    }

    @Override
    public int getOverhead() {
        return this.overheadValue;
    }

    @Override
    public int getCallcount() {
        return this.callCount;
    }

    @Override
    public Feature getFeatureForFrequency() {
        return this.featureForFrequency;
    }

    public static byte[] getFeatureFlagValue(Set<Feature> features) {
        long lowValue = 0L;
        long highValue = 0L;
        if (features != null) {
            for (Feature feature : features) {
                IProtocolConfig[] configs = featureProtocolMap.get((Object)feature);
                if (configs == null) continue;
                int i = 0;
                while (i < configs.length) {
                    int bitshift = configs[i].getShift();
                    if (bitshift >= 64) {
                        highValue |= 1L << bitshift - 64;
                    } else {
                        lowValue |= 1L << bitshift;
                    }
                    ++i;
                }
            }
        }
        byte[] lowbyte = ByteUtil.toBytes((long)lowValue);
        byte[] highbyte = ByteUtil.toBytes((long)highValue);
        byte[] ret = new byte[16];
        System.arraycopy(lowbyte, 0, ret, 0, 8);
        System.arraycopy(highbyte, 0, ret, 8, 8);
        return ret;
    }

    public static byte[] getFlatFeatureFlagValue(Set<FlatFeature> flatFeatures, Set<FlatPreferences> selectedPreferences) {
        int bitshift;
        int i;
        IProtocolConfig[] configs;
        long lowValue = 0L;
        long highValue = 0L;
        if (flatFeatures != null) {
            Logger.debug(flatFeatures);
            for (FlatFeature flatFeature : flatFeatures) {
                configs = flatFeatureProtocolMap.get((Object)flatFeature);
                if (configs == null) continue;
                i = 0;
                while (i < configs.length) {
                    bitshift = configs[i].getShift();
                    if (bitshift >= 64) {
                        highValue |= 1L << bitshift - 64;
                    } else {
                        lowValue |= 1L << bitshift;
                    }
                    ++i;
                }
            }
        }
        if (selectedPreferences != null) {
            for (FlatPreferences feature : selectedPreferences) {
                configs = preferencesProtocolMap.get((Object)feature);
                if (configs == null) continue;
                i = 0;
                while (i < configs.length) {
                    bitshift = configs[i].getShift();
                    if (bitshift >= 64) {
                        highValue |= 1L << bitshift - 64;
                    } else {
                        lowValue |= 1L << bitshift;
                    }
                    ++i;
                }
            }
        }
        byte[] lowbyte = ByteUtil.toBytes((long)lowValue);
        byte[] highbyte = ByteUtil.toBytes((long)highValue);
        byte[] ret = new byte[16];
        System.arraycopy(lowbyte, 0, ret, 0, 8);
        System.arraycopy(highbyte, 0, ret, 8, 8);
        return ret;
    }

    public static IProtocolConfig[] getProtocolConfig(Feature feature) {
        return featureProtocolMap.get((Object)feature);
    }

    public static IProtocolConfig[] getProtocolConfig(FlatFeature feature) {
        return flatFeatureProtocolMap.get((Object)feature);
    }
}

