/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.platform;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.util.FileUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.RpmUtil;

public class BinarySettingManager {
    private static BinarySettingManager instance = null;
    private List<BinarySettingData> targetBinaryList = new ArrayList<BinarySettingData>();
    private String debugRoot = PathManager.getRootstrapsPath((String)SettingDataManager.INSTANCE.getPlatform());

    public static synchronized BinarySettingManager getInstance() {
        if (instance == null) {
            instance = new BinarySettingManager();
        }
        return instance;
    }

    public void addBinarySettingData(BinarySettingData binData) {
        this.removeBinarySettingData(binData.getBinaryPath());
        this.targetBinaryList.add(binData);
    }

    public void addBinarySettingData(List<BinarySettingData> data) {
        for (BinarySettingData binData : data) {
            this.addBinarySettingData(binData);
        }
    }

    public void removeBinarySettingData(String binPath) {
        int i = 0;
        while (i < this.targetBinaryList.size()) {
            if (this.targetBinaryList.get(i).getBinaryPath().equals(binPath)) {
                this.targetBinaryList.remove(i);
                break;
            }
            ++i;
        }
    }

    public BinarySettingData getBinarySetting(String targetBinaryPath) {
        int size = this.targetBinaryList.size();
        BinarySettingData binData = null;
        int i = 0;
        while (i < size) {
            if (this.targetBinaryList.get(i).getBinaryPath().equals(targetBinaryPath)) {
                binData = this.targetBinaryList.get(i);
                break;
            }
            ++i;
        }
        return binData;
    }

    public List<BinarySettingData> getBinarySettingList() {
        return Collections.unmodifiableList(this.targetBinaryList);
    }

    public String getDebugRoot() {
        return this.debugRoot;
    }

    public void setDebugRoot(String debugRoot) {
        this.debugRoot = debugRoot;
    }

    public void saveData(BufferedWriter writer) {
        int size = this.targetBinaryList.size();
        int i = 0;
        while (i < size) {
            this.targetBinaryList.get(i).saveData(writer);
            ++i;
        }
    }

    public void openData(BufferedReader reader) throws IOException {
        String content;
        while ((content = reader.readLine()) != null) {
            BinarySettingData binaryData = new BinarySettingData();
            binaryData.openData(content);
            this.addBinarySettingData(binaryData);
        }
    }

    public void initBinarySettings() {
    }

    private String findSourceRpmPath(BinarySettingData binData) {
        String sourceCandidate;
        File sourceRpmFile;
        File debugRpmFile;
        String sourceRpm = null;
        String debugRpmPath = binData.getDebugRpmPath();
        if (debugRpmPath != null && !debugRpmPath.isEmpty() && (debugRpmFile = new File(debugRpmPath)).isFile() && (sourceRpmFile = new File(sourceCandidate = debugRpmPath.replace("debuginfo", "debugsource"))).isFile()) {
            sourceRpm = sourceCandidate;
            binData.setSourceRpmPath(sourceRpm);
        }
        return sourceRpm;
    }

    private String copyAndExtractRpmFile(BinarySettingData binData) {
        String from;
        String debugRpmSourcePath;
        String debugRpmPath;
        String rpmPath;
        block9: {
            String targetBinPath = binData.getBinaryPath();
            String[] splitTargetBin = targetBinPath.split("/");
            String dirName = splitTargetBin[splitTargetBin.length - 1];
            rpmPath = String.valueOf(PathManager.DA_RPM_PATH) + File.separator + dirName;
            File rpms = new File(rpmPath);
            if (!rpms.exists() && !rpms.mkdirs()) {
                Logger.debug((Object)"rpm directory create failed...");
                return null;
            }
            debugRpmPath = null;
            debugRpmSourcePath = null;
            from = binData.getDebugRpmPath();
            if (from != null && !from.isEmpty()) {
                try {
                    debugRpmPath = FileUtil.copyFileToDir((String)from, (String)rpmPath);
                    if (debugRpmPath == null) {
                        return null;
                    }
                    break block9;
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
            }
            return null;
        }
        from = binData.getSourceRpmPath();
        if (from != null && !from.isEmpty()) {
            try {
                debugRpmSourcePath = FileUtil.copyFileToDir((String)from, (String)rpmPath);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
        RpmUtil.extractRpm(rpmPath, debugRpmPath);
        if (debugRpmSourcePath != null) {
            RpmUtil.extractRpm(rpmPath, debugRpmSourcePath);
        }
        return rpmPath;
    }

    private void findRealDebugFile(BinarySettingData binData, String extractPath) {
        String targetBinPath = binData.getBinaryPath();
        String[] splitTargetBin = targetBinPath.split("/");
        String binName = splitTargetBin[splitTargetBin.length - 1];
        String debugRpmPath = binData.getDebugRpmPath();
        if (debugRpmPath.contains("debuginfo")) {
            String debugCandidate = "*" + binName + ".debug";
            List debugfilelist = FileUtil.findFilesInDir((String)extractPath, (String)debugCandidate, (boolean)true);
            if (debugfilelist.size() > 0) {
                binData.setDebugFilePath((String)debugfilelist.get(0));
                String debugSourceRpmPath = binData.getSourceRpmPath();
                if (debugSourceRpmPath != null && !debugSourceRpmPath.isEmpty()) {
                    Logger.debug((Object)("SOURCE PATH : " + extractPath));
                    binData.setRpmSourceDir(extractPath);
                } else {
                    binData.setRpmSourceDir(null);
                }
            } else {
                binData.setDebugFilePath(null);
            }
        } else if (debugRpmPath.contains("debug-")) {
            List debugfilelist = FileUtil.findFilesInDir((String)extractPath, (String)binName, (boolean)true);
            if (debugfilelist.size() > 0) {
                binData.setDebugFilePath((String)debugfilelist.get(0));
            } else {
                binData.setDebugFilePath(null);
            }
        } else {
            binData.setDebugFilePath(null);
        }
    }

    public void checkSourcePath(List<BinarySettingData> input) {
        int size = input.size();
        int i = 0;
        while (i < size) {
            String extractPath;
            BinarySettingData binData = input.get(i);
            if (binData.getSourceRpmPath() == null) {
                this.findSourceRpmPath(binData);
            }
            if ((extractPath = this.copyAndExtractRpmFile(binData)) != null) {
                this.findRealDebugFile(binData, extractPath);
            }
            ++i;
        }
    }

    private String findDebugRpmPath(String token, String rootPath, String binName) {
        String debugRpmPath = null;
        if (!rootPath.endsWith(File.separator)) {
            rootPath = String.valueOf(rootPath) + File.separator;
        }
        List rpmlist = FileUtil.findFilesInDir((String)rootPath, (String)token, (boolean)true);
        if (binName != null) {
            int i = 0;
            while (i < rpmlist.size()) {
                String rpmpath = (String)rpmlist.get(i);
                List<String> filelist = RpmUtil.getFileListInRpm(rpmpath);
                if (filelist != null && filelist.size() > 0) {
                    int filesize = filelist.size();
                    boolean bFound = false;
                    int k = 0;
                    while (k < filesize) {
                        if (filelist.get(k).contains(binName)) {
                            bFound = true;
                            break;
                        }
                        ++k;
                    }
                    if (bFound) {
                        debugRpmPath = rpmpath;
                        break;
                    }
                }
                ++i;
            }
        } else {
            String longest = null;
            for (String rpm : rpmlist) {
                if (longest == null) {
                    longest = rpm;
                    continue;
                }
                if (rpm.length() <= longest.length()) continue;
                longest = rpm;
            }
            if (longest != null) {
                debugRpmPath = String.valueOf(rootPath) + longest;
            }
        }
        return debugRpmPath;
    }

    public String getDebugRpmPath(String binPath, String rootPath) {
        File rootPathDir = new File(rootPath);
        if (!rootPathDir.isDirectory()) {
            return null;
        }
        String[] splitTargetBin = binPath.split("/");
        String binName = splitTargetBin[splitTargetBin.length - 1];
        int index = binName.indexOf(".so");
        String prefixToken = index < 0 ? "*" + binName + "*" : (binName.startsWith("lib") ? "*" + binName.substring(3, index) + "*" : "*" + binName.substring(0, index) + "*");
        String searchToken = String.valueOf(prefixToken) + "debuginfo" + "*" + ".rpm";
        String debugRpmPath = this.findDebugRpmPath(searchToken, rootPath, null);
        if (debugRpmPath != null) {
            return debugRpmPath;
        }
        searchToken = String.valueOf(prefixToken) + "debug-" + "*" + ".rpm";
        debugRpmPath = this.findDebugRpmPath(searchToken, rootPath, null);
        if (debugRpmPath != null) {
            return debugRpmPath;
        }
        searchToken = "*.rpm";
        debugRpmPath = this.findDebugRpmPath(searchToken, rootPath, binName);
        if (debugRpmPath != null) {
            return debugRpmPath;
        }
        return null;
    }
}

